/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.DateFormatClass$;
import org.apache.spark.sql.catalyst.expressions.DefaultStringProducingExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.TimestampFormatterHelper;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.catalyst.util.LegacyDateFormats$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(timestamp, fmt) - Converts `timestamp` to a value of string in the format specified by the date format `fmt`.", arguments="\n    Arguments:\n      * timestamp - A date/timestamp or string to be converted to the given format.\n      * fmt - Date/time format pattern to follow. See <a href=\"https://spark.apache.org/docs/latest/sql-ref-datetime-pattern.html\">Datetime Patterns</a> for valid date\n              and time format patterns.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('2016-04-08', 'y');\n       2016\n  ", group="datetime_funcs", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0005\t%d\u0001B\u0014)\u0001VB\u0001\"\u0016\u0001\u0003\u0016\u0004%\tA\u0016\u0005\t5\u0002\u0011\t\u0012)A\u0005/\"A1\f\u0001BK\u0002\u0013\u0005a\u000b\u0003\u0005]\u0001\tE\t\u0015!\u0003X\u0011!i\u0006A!f\u0001\n\u0003q\u0006\u0002\u00036\u0001\u0005#\u0005\u000b\u0011B0\t\u000b-\u0004A\u0011\u00017\t\u000bE\u0004A\u0011\t:\t\u000b-\u0004A\u0011\u0001<\t\u000be\u0004A\u0011\t>\t\u000f\u0005%\u0001\u0001\"\u0011\u0002\f!9\u0011Q\u0003\u0001\u0005R\u0005]\u0001bBA\u0014\u0001\u0011\u0005\u0013\u0011\u0006\u0005\b\u0003\u000b\u0002A\u0011IA$\u0011\u0019\tI\u0005\u0001C)-\"1\u00111\n\u0001\u0005RIDq!!\u0014\u0001\t#\ny\u0005C\u0004\u0002Z\u0001!)%a\u0017\t\u0013\u0005%\u0005!!A\u0005\u0002\u0005-\u0005\"CAJ\u0001E\u0005I\u0011AAK\u0011%\tY\u000bAI\u0001\n\u0003\t)\nC\u0005\u0002.\u0002\t\n\u0011\"\u0001\u00020\"I\u00111\u0017\u0001\u0002\u0002\u0013\u0005\u0013Q\u0017\u0005\n\u0003\u000b\u0004\u0011\u0011!C\u0001\u0003\u000fD\u0011\"a4\u0001\u0003\u0003%\t!!5\t\u0013\u0005]\u0007!!A\u0005B\u0005e\u0007\"CAt\u0001\u0005\u0005I\u0011AAu\u0011%\ti\u000fAA\u0001\n\u0003\ny\u000fC\u0005\u0002t\u0002\t\t\u0011\"\u0011\u0002v\u001eI!q\u0004\u0015\u0002\u0002#\u0005!\u0011\u0005\u0004\tO!\n\t\u0011#\u0001\u0003$!11n\bC\u0001\u0005wA\u0011B!\u0010 \u0003\u0003%)Ea\u0010\t\u0013\t\u0005s$!A\u0005\u0002\n\r\u0003\"\u0003B&?E\u0005I\u0011AAX\u0011%\u0011ieHA\u0001\n\u0003\u0013y\u0005C\u0005\u0003^}\t\n\u0011\"\u0001\u00020\"I!qL\u0010\u0002\u0002\u0013%!\u0011\r\u0002\u0010\t\u0006$XMR8s[\u0006$8\t\\1tg*\u0011\u0011FK\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002,Y\u0005A1-\u0019;bYf\u001cHO\u0003\u0002.]\u0005\u00191/\u001d7\u000b\u0005=\u0002\u0014!B:qCJ\\'BA\u00193\u0003\u0019\t\u0007/Y2iK*\t1'A\u0002pe\u001e\u001c\u0001aE\u0004\u0001mij\u0004iQ%\u0011\u0005]BT\"\u0001\u0015\n\u0005eB#\u0001\u0005\"j]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t94(\u0003\u0002=Q\tAB+[7fgR\fW\u000e\u001d$pe6\fG\u000f^3s\u0011\u0016d\u0007/\u001a:\u0011\u0005]r\u0014BA )\u0005YIU\u000e\u001d7jG&$8)Y:u\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bCA\u001cB\u0013\t\u0011\u0005F\u0001\u0011EK\u001a\fW\u000f\u001c;TiJLgn\u001a)s_\u0012,8-\u001b8h\u000bb\u0004(/Z:tS>t\u0007C\u0001#H\u001b\u0005)%\"\u0001$\u0002\u000bM\u001c\u0017\r\\1\n\u0005!+%a\u0002)s_\u0012,8\r\u001e\t\u0003\u0015Js!a\u0013)\u000f\u00051{U\"A'\u000b\u00059#\u0014A\u0002\u001fs_>$h(C\u0001G\u0013\t\tV)A\u0004qC\u000e\\\u0017mZ3\n\u0005M#&\u0001D*fe&\fG.\u001b>bE2,'BA)F\u0003\u0011aWM\u001a;\u0016\u0003]\u0003\"a\u000e-\n\u0005eC#AC#yaJ,7o]5p]\u0006)A.\u001a4uA\u0005)!/[4ii\u00061!/[4ii\u0002\n!\u0002^5nKj{g.Z%e+\u0005y\u0006c\u0001#aE&\u0011\u0011-\u0012\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\r<gB\u00013f!\taU)\u0003\u0002g\u000b\u00061\u0001K]3eK\u001aL!\u0001[5\u0003\rM#(/\u001b8h\u0015\t1W)A\u0006uS6,'l\u001c8f\u0013\u0012\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003n]>\u0004\bCA\u001c\u0001\u0011\u0015)v\u00011\u0001X\u0011\u0015Yv\u00011\u0001X\u0011\u001div\u0001%AA\u0002}\u000baB\\;mY&sGo\u001c7fe\u0006tG/F\u0001t!\t!E/\u0003\u0002v\u000b\n9!i\\8mK\u0006tGcA7xq\")Q+\u0003a\u0001/\")1,\u0003a\u0001/\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0003m\u00042A\u0013?\u007f\u0013\tiHKA\u0002TKF\u00042a`A\u0003\u001b\t\t\tAC\u0002\u0002\u00041\nQ\u0001^=qKNLA!a\u0002\u0002\u0002\t\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\ro&$\b\u000eV5nKj{g.\u001a\u000b\u0005\u0003\u001b\t\u0019\u0002E\u00028\u0003\u001fI1!!\u0005)\u0005]!\u0016.\\3[_:,\u0017i^1sK\u0016C\bO]3tg&|g\u000eC\u0003^\u0017\u0001\u0007!-\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\u0004\u0002\u001a\u0005}\u00111\u0005\t\u0004\t\u0006m\u0011bAA\u000f\u000b\n\u0019\u0011I\\=\t\u000f\u0005\u0005B\u00021\u0001\u0002\u001a\u0005IA/[7fgR\fW\u000e\u001d\u0005\b\u0003Ka\u0001\u0019AA\r\u0003\u00191wN]7bi\u0006IAm\\$f]\u000e{G-\u001a\u000b\u0007\u0003W\t9$!\u0011\u0011\t\u00055\u00121G\u0007\u0003\u0003_Q1!!\r)\u0003\u001d\u0019w\u000eZ3hK:LA!!\u000e\u00020\tAQ\t\u001f9s\u0007>$W\rC\u0004\u0002:5\u0001\r!a\u000f\u0002\u0007\r$\b\u0010\u0005\u0003\u0002.\u0005u\u0012\u0002BA \u0003_\u0011abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0004\u0002D5\u0001\r!a\u000b\u0002\u0005\u00154\u0018A\u00039sKR$\u0018PT1nKV\t!-\u0001\u0007g_Jl\u0017\r^*ue&tw-A\u0005jgB\u000b'o]5oO\u00069r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\u0006[\u0006E\u0013Q\u000b\u0005\u0007\u0003'\n\u0002\u0019A,\u0002\u000f9,w\u000fT3gi\"1\u0011qK\tA\u0002]\u000b\u0001B\\3x%&<\u0007\u000e^\u0001\u0015]>$W\rU1ui\u0016\u0014hn]%oi\u0016\u0014h.\u00197\u0015\u0005\u0005u\u0003\u0003\u0002&}\u0003?\u0002B!!\u0019\u0002\u0004:!\u00111MA?\u001d\u0011\t)'!\u001f\u000f\t\u0005\u001d\u0014q\u000f\b\u0005\u0003S\n)H\u0004\u0003\u0002l\u0005Md\u0002BA7\u0003cr1\u0001TA8\u0013\u0005\u0019\u0014BA\u00193\u0013\ty\u0003'\u0003\u0002.]%\u00111\u0006L\u0005\u0004\u0003wR\u0013!\u0002;sK\u0016\u001c\u0018\u0002BA@\u0003\u0003\u000b1\u0002\u0016:fKB\u000bG\u000f^3s]*\u0019\u00111\u0010\u0016\n\t\u0005\u0015\u0015q\u0011\u0002\f)J,W\rU1ui\u0016\u0014hN\u0003\u0003\u0002\u0000\u0005\u0005\u0015\u0001B2paf$r!\\AG\u0003\u001f\u000b\t\nC\u0004V'A\u0005\t\u0019A,\t\u000fm\u001b\u0002\u0013!a\u0001/\"9Ql\u0005I\u0001\u0002\u0004y\u0016AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003/S3aVAMW\t\tY\n\u0005\u0003\u0002\u001e\u0006\u001dVBAAP\u0015\u0011\t\t+a)\u0002\u0013Ut7\r[3dW\u0016$'bAAS\u000b\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005%\u0016q\u0014\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\t\tLK\u0002`\u00033\u000bQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\\!\u0011\tI,a1\u000e\u0005\u0005m&\u0002BA_\u0003\u007f\u000bA\u0001\\1oO*\u0011\u0011\u0011Y\u0001\u0005U\u00064\u0018-C\u0002i\u0003w\u000bA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!3\u0011\u0007\u0011\u000bY-C\u0002\u0002N\u0016\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\u0007\u0002T\"I\u0011Q[\r\u0002\u0002\u0003\u0007\u0011\u0011Z\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005m\u0007CBAo\u0003G\fI\"\u0004\u0002\u0002`*\u0019\u0011\u0011]#\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002f\u0006}'\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2a]Av\u0011%\t)nGA\u0001\u0002\u0004\tI\"\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA\\\u0003cD\u0011\"!6\u001d\u0003\u0003\u0005\r!!3\u0002\r\u0015\fX/\u00197t)\r\u0019\u0018q\u001f\u0005\n\u0003+l\u0012\u0011!a\u0001\u00033As\u0003AA~\u0005\u0003\u0011\u0019Aa\u0002\u0003\n\t5!q\u0002B\n\u0005+\u0011IBa\u0007\u0011\u0007]\ni0C\u0002\u0002\u0000\"\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0003\u0006\u0005!xLR+O\u0007~CC/[7fgR\fW\u000e\u001d\u0017!M6$\u0018\u0006I\u0017!\u0007>tg/\u001a:ug\u0002\u0002G/[7fgR\fW\u000e\u001d1!i>\u0004\u0013\r\t<bYV,\u0007e\u001c4!gR\u0014\u0018N\\4!S:\u0004C\u000f[3!M>\u0014X.\u0019;!gB,7-\u001b4jK\u0012\u0004#-\u001f\u0011uQ\u0016\u0004C-\u0019;fA\u0019|'/\\1uA\u00014W\u000e\u001e1/\u0003%\t'oZ;nK:$8/\t\u0002\u0003\f\u0005\u0011iG\u0003\u0011!A\u0001\n%oZ;nK:$8O\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!i&lWm\u001d;b[B\u0004S\u0006I!!I\u0006$Xm\f;j[\u0016\u001cH/Y7qA=\u0014\be\u001d;sS:<\u0007\u0005^8!E\u0016\u00043m\u001c8wKJ$X\r\u001a\u0011u_\u0002\"\b.\u001a\u0011hSZ,g\u000e\t4pe6\fGO\f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!M6$\b%\f\u0011ECR,w\u0006^5nK\u00022wN]7bi\u0002\u0002\u0018\r\u001e;fe:\u0004Co\u001c\u0011g_2dwn\u001e\u0018!'\u0016,\u0007\u0005P1!QJ,g-\u0010\u0012iiR\u00048OO\u00180gB\f'o\u001b\u0018ba\u0006\u001c\u0007.\u001a\u0018pe\u001e|Cm\\2t_1\fG/Z:u_M\fH.\f:fM6\"\u0017\r^3uS6,W\u0006]1ui\u0016\u0014hN\f5u[2\u0014c\bR1uKRLW.\u001a\u0011QCR$XM\u001d8ty=\ng\b\t4pe\u00022\u0018\r\\5eA\u0011\fG/\u001a\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011b]\u0012\u0004C/[7fA\u0019|'/\\1uAA\fG\u000f^3s]Nt#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#A!\u0005\u0002\u000f*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CsE\r\u00192m5\u0002D'\f\u00199O1\u0002s%_\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012\u0004'\r\u001c\u000bA\u0001\nQa\u001a:pkB\f#Aa\u0006\u0002\u001d\u0011\fG/\u001a;j[\u0016|f-\u001e8dg\u0006)1/\u001b8dK\u0006\u0012!QD\u0001\u0006c9*d\u0006M\u0001\u0010\t\u0006$XMR8s[\u0006$8\t\\1tgB\u0011qgH\n\u0006?\t\u0015\"\u0011\u0007\t\t\u0005O\u0011icV,`[6\u0011!\u0011\u0006\u0006\u0004\u0005W)\u0015a\u0002:v]RLW.Z\u0005\u0005\u0005_\u0011ICA\tBEN$(/Y2u\rVt7\r^5p]N\u0002BAa\r\u0003:5\u0011!Q\u0007\u0006\u0005\u0005o\ty,\u0001\u0002j_&\u00191K!\u000e\u0015\u0005\t\u0005\u0012\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005]\u0016!B1qa2LHcB7\u0003F\t\u001d#\u0011\n\u0005\u0006+\n\u0002\ra\u0016\u0005\u00067\n\u0002\ra\u0016\u0005\b;\n\u0002\n\u00111\u0001`\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u001a\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0005#\u0012I\u0006\u0005\u0003EA\nM\u0003C\u0002#\u0003V];v,C\u0002\u0003X\u0015\u0013a\u0001V;qY\u0016\u001c\u0004\u0002\u0003B.I\u0005\u0005\t\u0019A7\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0005G\u0002B!!/\u0003f%!!qMA^\u0005\u0019y%M[3di\u0002")
public class DateFormatClass
extends BinaryExpression
implements TimestampFormatterHelper,
ImplicitCastInputTypes,
DefaultStringProducingExpression,
Serializable {
    private final Expression left;
    private final Expression right;
    private final Option<String> timeZoneId;
    private transient Option<TimestampFormatter> formatterOption;
    private boolean resolved;
    private Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<String> $lessinit$greater$default$3() {
        return DateFormatClass$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, Option<String>>> unapply(DateFormatClass x$0) {
        return DateFormatClass$.MODULE$.unapply(x$0);
    }

    public static Option<String> apply$default$3() {
        return DateFormatClass$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Expression, Expression, Option<String>>, DateFormatClass> tupled() {
        return DateFormatClass$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Option<String>, DateFormatClass>>> curried() {
        return DateFormatClass$.MODULE$.curried();
    }

    @Override
    public DataType dataType() {
        return DefaultStringProducingExpression.dataType$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public boolean forTimestampNTZ() {
        return TimestampFormatterHelper.forTimestampNTZ$(this);
    }

    @Override
    public final TimestampFormatter getFormatter(String fmt) {
        return TimestampFormatterHelper.getFormatter$(this, fmt);
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    private Option<TimestampFormatter> formatterOption$lzycompute() {
        DateFormatClass dateFormatClass = this;
        synchronized (dateFormatClass) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.formatterOption = TimestampFormatterHelper.formatterOption$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.formatterOption;
    }

    @Override
    public final Option<TimestampFormatter> formatterOption() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.formatterOption$lzycompute();
        }
        return this.formatterOption;
    }

    private boolean resolved$lzycompute() {
        DateFormatClass dateFormatClass = this;
        synchronized (dateFormatClass) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if (!this.bitmap$0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        DateFormatClass dateFormatClass = this;
        synchronized (dateFormatClass) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.zoneId$lzycompute();
        }
        return this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)TimestampType$.MODULE$, (List)new .colon.colon((Object)StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), (List)Nil$.MODULE$));
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, (Option<String>)x$1);
    }

    @Override
    public Object nullSafeEval(Object timestamp, Object format) {
        TimestampFormatter formatter = (TimestampFormatter)this.formatterOption().getOrElse((Function0 & Serializable)() -> this.getFormatter(format.toString()));
        return UTF8String.fromString((String)formatter.format(BoxesRunTime.unboxToLong((Object)timestamp)));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return (ExprCode)this.formatterOption().map((Function1 & Serializable)tf -> {
            String timestampFormatter = ctx.addReferenceObj("timestampFormatter", tf, ctx.addReferenceObj$default$3());
            return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(timestamp, x$3) -> "UTF8String.fromString(" + timestampFormatter + ".format(" + timestamp + "))");
        }).getOrElse((Function0 & Serializable)() -> {
            String tf = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(TimestampFormatter$.MODULE$.getClass().getName()), "$");
            String ldf = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(LegacyDateFormats$.MODULE$.getClass().getName()), "$");
            String zid = ctx.addReferenceObj("zoneId", this.zoneId(), ZoneId.class.getName());
            return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(timestamp, format) -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|UTF8String.fromString(" + tf + "$.MODULE$.apply(\n            |  " + format + ".toString(),\n            |  " + zid + ",\n            |  " + ldf + "$.MODULE$.SIMPLE_DATE_FORMAT(),\n            |  false)\n            |.format(" + timestamp + "))")));
        });
    }

    @Override
    public String prettyName() {
        return "date_format";
    }

    @Override
    public Expression formatString() {
        return this.right();
    }

    @Override
    public boolean isParsing() {
        return false;
    }

    @Override
    public DateFormatClass withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3());
    }

    @Override
    public final Seq<Enumeration.Value> nodePatternsInternal() {
        return new .colon.colon((Object)TreePattern$.MODULE$.DATETIME(), (List)Nil$.MODULE$);
    }

    public DateFormatClass copy(Expression left, Expression right, Option<String> timeZoneId) {
        return new DateFormatClass(left, right, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "DateFormatClass";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
            case 2: {
                return this.timeZoneId();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DateFormatClass;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
            case 2: {
                return "timeZoneId";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DateFormatClass)) return false;
        boolean bl = true;
        if (!bl) return false;
        DateFormatClass dateFormatClass = (DateFormatClass)x$1;
        Expression expression = this.left();
        Expression expression2 = dateFormatClass.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = dateFormatClass.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = dateFormatClass.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!dateFormatClass.canEqual(this)) return false;
        return true;
    }

    public DateFormatClass(Expression left, Expression right, Option<String> timeZoneId) {
        this.left = left;
        this.right = right;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        TimestampFormatterHelper.$init$(this);
        ExpectsInputTypes.$init$(this);
        DefaultStringProducingExpression.$init$(this);
        Statics.releaseFence();
    }

    public DateFormatClass(Expression left, Expression right) {
        this(left, right, (Option<String>)None$.MODULE$);
    }
}

