/*
 * Decompiled with CFR 0.152.
 */
package spire.math;

import algebra.ring.AdditiveMonoid;
import algebra.ring.CommutativeRing;
import cats.kernel.Eq;
import scala.Tuple2;
import scala.runtime.BoxesRunTime;
import spire.algebra.Field;
import spire.algebra.IsReal;
import spire.algebra.NRoot;
import spire.algebra.Signed;
import spire.algebra.Trig;
import spire.math.Complex;
import spire.math.Complex$;
import spire.math.Quaternion;
import spire.math.Quaternion$mcF$sp;
import spire.math.package$;

public final class Complex$mcF$sp
extends Complex<Object> {
    public static final long serialVersionUID = 0L;
    public final float real$mcF$sp;
    public final float imag$mcF$sp;

    @Override
    public float real$mcF$sp() {
        return this.real$mcF$sp;
    }

    @Override
    public float real() {
        return this.real$mcF$sp();
    }

    @Override
    public float imag$mcF$sp() {
        return this.imag$mcF$sp;
    }

    @Override
    public float imag() {
        return this.imag$mcF$sp();
    }

    @Override
    public Complex<Object> complexSignum(Field<Object> f, NRoot<Object> n, Signed<Object> s) {
        return this.complexSignum$mcF$sp(f, n, s);
    }

    @Override
    public Complex<Object> complexSignum$mcF$sp(Field<Object> f, NRoot<Object> n, Signed<Object> s) {
        return this.isZero$mcF$sp(s) ? this : this.$div$mcF$sp(this.abs$mcF$sp(f, n, s), f);
    }

    @Override
    public float abs(Field<Object> f, NRoot<Object> n, Signed<Object> s) {
        return this.abs$mcF$sp(f, n, s);
    }

    @Override
    public float abs$mcF$sp(Field<Object> f, NRoot<Object> n, Signed<Object> s) {
        return package$.MODULE$.hypot$mFc$sp(this.real(), this.imag(), f, n, s);
    }

    @Override
    public float absSquare(CommutativeRing<Object> r) {
        return this.absSquare$mcF$sp(r);
    }

    @Override
    public float absSquare$mcF$sp(CommutativeRing<Object> r) {
        return r.plus$mcF$sp(r.times$mcF$sp(this.real(), this.real()), r.times$mcF$sp(this.imag(), this.imag()));
    }

    @Override
    public float arg(Field<Object> f, Signed<Object> s, Trig<Object> t) {
        return this.arg$mcF$sp(f, s, t);
    }

    @Override
    public float arg$mcF$sp(Field<Object> f, Signed<Object> s, Trig<Object> t) {
        return this.isZero$mcF$sp(s) ? f.zero$mcF$sp() : t.atan2$mcF$sp(this.imag(), this.real());
    }

    @Override
    public float norm(Field<Object> f, NRoot<Object> n, Signed<Object> s) {
        return this.norm$mcF$sp(f, n, s);
    }

    @Override
    public float norm$mcF$sp(Field<Object> f, NRoot<Object> n, Signed<Object> s) {
        return package$.MODULE$.hypot$mFc$sp(this.real(), this.imag(), f, n, s);
    }

    @Override
    public Complex<Object> conjugate(CommutativeRing<Object> f) {
        return this.conjugate$mcF$sp(f);
    }

    @Override
    public Complex<Object> conjugate$mcF$sp(CommutativeRing<Object> f) {
        return new Complex$mcF$sp(this.real(), f.negate$mcF$sp(this.imag()));
    }

    @Override
    public Tuple2<Object, Object> asTuple() {
        return this.asTuple$mcF$sp();
    }

    @Override
    public Tuple2<Object, Object> asTuple$mcF$sp() {
        return new Tuple2((Object)BoxesRunTime.boxToFloat((float)this.real()), (Object)BoxesRunTime.boxToFloat((float)this.imag()));
    }

    @Override
    public Tuple2<Object, Object> asPolarTuple(Field<Object> f, NRoot<Object> n, Signed<Object> s, Trig<Object> t) {
        return this.asPolarTuple$mcF$sp(f, n, s, t);
    }

    @Override
    public Tuple2<Object, Object> asPolarTuple$mcF$sp(Field<Object> f, NRoot<Object> n, Signed<Object> s, Trig<Object> t) {
        return new Tuple2((Object)BoxesRunTime.boxToFloat((float)this.abs$mcF$sp(f, n, s)), (Object)BoxesRunTime.boxToFloat((float)this.arg$mcF$sp(f, s, t)));
    }

    @Override
    public boolean isZero(Signed<Object> s) {
        return this.isZero$mcF$sp(s);
    }

    @Override
    public boolean isZero$mcF$sp(Signed<Object> s) {
        return s.isSignZero$mcF$sp(this.real()) && s.isSignZero$mcF$sp(this.imag());
    }

    @Override
    public boolean isImaginary(Signed<Object> s) {
        return this.isImaginary$mcF$sp(s);
    }

    @Override
    public boolean isImaginary$mcF$sp(Signed<Object> s) {
        return s.isSignZero$mcF$sp(this.real());
    }

    @Override
    public boolean isReal(Signed<Object> s) {
        return this.isReal$mcF$sp(s);
    }

    @Override
    public boolean isReal$mcF$sp(Signed<Object> s) {
        return s.isSignZero$mcF$sp(this.imag());
    }

    @Override
    public boolean eqv(Complex<Object> b, Eq<Object> o) {
        return this.eqv$mcF$sp(b, o);
    }

    @Override
    public boolean eqv$mcF$sp(Complex<Object> b, Eq<Object> o) {
        return o.eqv$mcF$sp(this.real(), b.real$mcF$sp()) && o.eqv$mcF$sp(this.imag(), b.imag$mcF$sp());
    }

    @Override
    public boolean neqv(Complex<Object> b, Eq<Object> o) {
        return this.neqv$mcF$sp(b, o);
    }

    @Override
    public boolean neqv$mcF$sp(Complex<Object> b, Eq<Object> o) {
        return o.neqv$mcF$sp(this.real(), b.real$mcF$sp()) || o.neqv$mcF$sp(this.imag(), b.imag$mcF$sp());
    }

    @Override
    public Complex<Object> unary_$minus(CommutativeRing<Object> r) {
        return this.unary_$minus$mcF$sp(r);
    }

    @Override
    public Complex<Object> unary_$minus$mcF$sp(CommutativeRing<Object> r) {
        return new Complex$mcF$sp(r.negate$mcF$sp(this.real()), r.negate$mcF$sp(this.imag()));
    }

    @Override
    public Complex<Object> $plus(float rhs, CommutativeRing<Object> r) {
        return this.$plus$mcF$sp(rhs, r);
    }

    @Override
    public Complex<Object> $plus$mcF$sp(float rhs, CommutativeRing<Object> r) {
        return new Complex$mcF$sp(r.plus$mcF$sp(this.real(), rhs), this.imag());
    }

    @Override
    public Complex<Object> $minus(float rhs, CommutativeRing<Object> r) {
        return this.$minus$mcF$sp(rhs, r);
    }

    @Override
    public Complex<Object> $minus$mcF$sp(float rhs, CommutativeRing<Object> r) {
        return new Complex$mcF$sp(r.minus$mcF$sp(this.real(), rhs), this.imag());
    }

    @Override
    public Complex<Object> $times(float rhs, CommutativeRing<Object> r) {
        return this.$times$mcF$sp(rhs, r);
    }

    @Override
    public Complex<Object> $times$mcF$sp(float rhs, CommutativeRing<Object> r) {
        return new Complex$mcF$sp(r.times$mcF$sp(this.real(), rhs), r.times$mcF$sp(this.imag(), rhs));
    }

    @Override
    public Complex<Object> $div(float rhs, Field<Object> r) {
        return this.$div$mcF$sp(rhs, r);
    }

    @Override
    public Complex<Object> $div$mcF$sp(float rhs, Field<Object> r) {
        return new Complex$mcF$sp(r.div$mcF$sp(this.real(), rhs), r.div$mcF$sp(this.imag(), rhs));
    }

    @Override
    public Complex<Object> $times$times(float e, Field<Object> f, NRoot<Object> n, Signed<Object> s, Trig<Object> t) {
        return this.$times$times$mcF$sp(e, f, n, s, t);
    }

    @Override
    public Complex<Object> $times$times$mcF$sp(float e, Field<Object> f, NRoot<Object> n, Signed<Object> s, Trig<Object> t) {
        return this.pow$mcF$sp(e, f, n, s, t);
    }

    @Override
    public Complex<Object> pow(float e, Field<Object> f, NRoot<Object> n, Signed<Object> s, Trig<Object> t) {
        return this.pow$mcF$sp(e, f, n, s, t);
    }

    @Override
    public Complex<Object> pow$mcF$sp(float e, Field<Object> f, NRoot<Object> n, Signed<Object> s, Trig<Object> t) {
        Complex<Object> complex;
        if (s.isSignZero$mcF$sp(e)) {
            complex = Complex$.MODULE$.one$mFc$sp(f);
        } else if (this.isZero$mcF$sp(s)) {
            if (s.lt$mcF$sp(e, f.zero$mcF$sp())) {
                throw new Exception("raising 0 to negative/complex power");
            }
            complex = Complex$.MODULE$.zero$mFc$sp(f);
        } else {
            complex = Complex$.MODULE$.polar$mFc$sp(n.fpow$mcF$sp(this.abs$mcF$sp(f, n, s), e), f.times$mcF$sp(this.arg$mcF$sp(f, s, t), e), f, t);
        }
        return complex;
    }

    @Override
    public Complex<Object> $plus(Complex<Object> b, CommutativeRing<Object> r) {
        return this.$plus$mcF$sp(b, r);
    }

    @Override
    public Complex<Object> $plus$mcF$sp(Complex<Object> b, CommutativeRing<Object> r) {
        return new Complex$mcF$sp(r.plus$mcF$sp(this.real(), b.real$mcF$sp()), r.plus$mcF$sp(this.imag(), b.imag$mcF$sp()));
    }

    @Override
    public Complex<Object> $minus(Complex<Object> b, CommutativeRing<Object> r) {
        return this.$minus$mcF$sp(b, r);
    }

    @Override
    public Complex<Object> $minus$mcF$sp(Complex<Object> b, CommutativeRing<Object> r) {
        return new Complex$mcF$sp(r.minus$mcF$sp(this.real(), b.real$mcF$sp()), r.minus$mcF$sp(this.imag(), b.imag$mcF$sp()));
    }

    @Override
    public Complex<Object> $times(Complex<Object> b, CommutativeRing<Object> r) {
        return this.$times$mcF$sp(b, r);
    }

    @Override
    public Complex<Object> $times$mcF$sp(Complex<Object> b, CommutativeRing<Object> r) {
        return new Complex$mcF$sp(r.minus$mcF$sp(r.times$mcF$sp(this.real(), b.real$mcF$sp()), r.times$mcF$sp(this.imag(), b.imag$mcF$sp())), r.plus$mcF$sp(r.times$mcF$sp(this.imag(), b.real$mcF$sp()), r.times$mcF$sp(this.real(), b.imag$mcF$sp())));
    }

    @Override
    public Complex<Object> $div(Complex<Object> b, Field<Object> f, Signed<Object> s) {
        return this.$div$mcF$sp(b, f, s);
    }

    @Override
    public Complex<Object> $div$mcF$sp(Complex<Object> b, Field<Object> f, Signed<Object> s) {
        Complex$mcF$sp complex$mcF$sp;
        float abs_bimag;
        float abs_breal = s.abs$mcF$sp(b.real$mcF$sp());
        if (s.gteqv$mcF$sp(abs_breal, abs_bimag = s.abs$mcF$sp(b.imag$mcF$sp()))) {
            if (s.eqv$mcF$sp(abs_breal, f.zero$mcF$sp())) {
                throw new Exception("/ by zero");
            }
            float ratio = f.div$mcF$sp(b.imag$mcF$sp(), b.real$mcF$sp());
            float denom = f.plus$mcF$sp(b.real$mcF$sp(), f.times$mcF$sp(b.imag$mcF$sp(), ratio));
            complex$mcF$sp = new Complex$mcF$sp(f.div$mcF$sp(f.plus$mcF$sp(this.real(), f.times$mcF$sp(this.imag(), ratio)), denom), f.div$mcF$sp(f.minus$mcF$sp(this.imag(), f.times$mcF$sp(this.real(), ratio)), denom));
        } else {
            if (s.eqv$mcF$sp(abs_bimag, f.zero$mcF$sp())) {
                throw new Exception("/ by zero");
            }
            float ratio = f.div$mcF$sp(b.real$mcF$sp(), b.imag$mcF$sp());
            float denom = f.plus$mcF$sp(f.times$mcF$sp(b.real$mcF$sp(), ratio), b.imag$mcF$sp());
            complex$mcF$sp = new Complex$mcF$sp(f.div$mcF$sp(f.plus$mcF$sp(f.times$mcF$sp(this.real(), ratio), this.imag()), denom), f.div$mcF$sp(f.minus$mcF$sp(f.times$mcF$sp(this.imag(), ratio), this.real()), denom));
        }
        return complex$mcF$sp;
    }

    @Override
    public Complex<Object> $times$times(int b, Field<Object> f, NRoot<Object> n, Signed<Object> s, Trig<Object> t) {
        return this.$times$times$mcF$sp(b, f, n, s, t);
    }

    @Override
    public Complex<Object> $times$times$mcF$sp(int b, Field<Object> f, NRoot<Object> n, Signed<Object> s, Trig<Object> t) {
        return this.pow$mcF$sp(b, f, n, s, t);
    }

    @Override
    public Complex<Object> nroot(int k, Field<Object> f, NRoot<Object> n, Signed<Object> s, Trig<Object> t) {
        return this.nroot$mcF$sp(k, f, n, s, t);
    }

    @Override
    public Complex<Object> nroot$mcF$sp(int k, Field<Object> f, NRoot<Object> n, Signed<Object> s, Trig<Object> t) {
        return this.isZero$mcF$sp(s) ? Complex$.MODULE$.zero$mFc$sp(f) : this.pow$mcF$sp(new Complex$mcF$sp(f.reciprocal$mcF$sp(f.fromInt$mcF$sp(k)), f.zero$mcF$sp()), f, n, s, t);
    }

    @Override
    public Complex<Object> pow(int b, Field<Object> f, NRoot<Object> n, Signed<Object> s, Trig<Object> t) {
        return this.pow$mcF$sp(b, f, n, s, t);
    }

    @Override
    public Complex<Object> pow$mcF$sp(int b, Field<Object> f, NRoot<Object> n, Signed<Object> s, Trig<Object> t) {
        return this.isZero$mcF$sp(s) ? Complex$.MODULE$.zero$mFc$sp(f) : Complex$.MODULE$.polar$mFc$sp(f.pow$mcF$sp(this.abs$mcF$sp(f, n, s), b), f.times$mcF$sp(this.arg$mcF$sp(f, s, t), f.fromInt$mcF$sp(b)), f, t);
    }

    @Override
    public Complex<Object> $times$times(Complex<Object> b, Field<Object> f, NRoot<Object> n, Signed<Object> s, Trig<Object> t) {
        return this.$times$times$mcF$sp(b, f, n, s, t);
    }

    @Override
    public Complex<Object> $times$times$mcF$sp(Complex<Object> b, Field<Object> f, NRoot<Object> n, Signed<Object> s, Trig<Object> t) {
        return this.pow$mcF$sp(b, f, n, s, t);
    }

    @Override
    public Complex<Object> pow(Complex<Object> b, Field<Object> f, NRoot<Object> n, Signed<Object> s, Trig<Object> t) {
        return this.pow$mcF$sp(b, f, n, s, t);
    }

    @Override
    public Complex<Object> pow$mcF$sp(Complex<Object> b, Field<Object> f, NRoot<Object> n, Signed<Object> s, Trig<Object> t) {
        Complex<Object> complex;
        if (b.isZero$mcF$sp(s)) {
            complex = Complex$.MODULE$.one$mFc$sp(f);
        } else if (this.isZero$mcF$sp(s)) {
            if (s.neqv$mcF$sp(b.imag$mcF$sp(), f.zero$mcF$sp()) || s.lt$mcF$sp(b.real$mcF$sp(), f.zero$mcF$sp())) {
                throw new Exception("raising 0 to negative/complex power");
            }
            complex = Complex$.MODULE$.zero$mFc$sp(f);
        } else if (s.neqv$mcF$sp(b.imag$mcF$sp(), f.zero$mcF$sp())) {
            float len = f.div$mcF$sp(n.fpow$mcF$sp(this.abs$mcF$sp(f, n, s), b.real$mcF$sp()), t.exp$mcF$sp(f.times$mcF$sp(this.arg$mcF$sp(f, s, t), b.imag$mcF$sp())));
            float phase = f.plus$mcF$sp(f.times$mcF$sp(this.arg$mcF$sp(f, s, t), b.real$mcF$sp()), f.times$mcF$sp(t.log$mcF$sp(this.abs$mcF$sp(f, n, s)), b.imag$mcF$sp()));
            complex = Complex$.MODULE$.polar$mFc$sp(len, phase, f, t);
        } else {
            complex = Complex$.MODULE$.polar$mFc$sp(n.fpow$mcF$sp(this.abs$mcF$sp(f, n, s), b.real$mcF$sp()), f.times$mcF$sp(this.arg$mcF$sp(f, s, t), b.real$mcF$sp()), f, t);
        }
        return complex;
    }

    @Override
    public Complex<Object> log(Field<Object> f, NRoot<Object> n, Trig<Object> t, Signed<Object> s) {
        return this.log$mcF$sp(f, n, t, s);
    }

    @Override
    public Complex<Object> log$mcF$sp(Field<Object> f, NRoot<Object> n, Trig<Object> t, Signed<Object> s) {
        if (this.isZero$mcF$sp(s)) {
            throw new IllegalArgumentException("log(0) undefined");
        }
        return new Complex$mcF$sp(t.log$mcF$sp(this.abs$mcF$sp(f, n, s)), this.arg$mcF$sp(f, s, t));
    }

    @Override
    public Complex<Object> sqrt(Field<Object> f, NRoot<Object> n0, Signed<Object> s) {
        return this.sqrt$mcF$sp(f, n0, s);
    }

    @Override
    public Complex<Object> sqrt$mcF$sp(Field<Object> f, NRoot<Object> n0, Signed<Object> s) {
        Complex$mcF$sp complex$mcF$sp;
        if (this.isZero$mcF$sp(s)) {
            complex$mcF$sp = this;
        } else if (s.isSignZero$mcF$sp(this.imag())) {
            complex$mcF$sp = s.isSignNegative$mcF$sp(this.real()) ? new Complex$mcF$sp(f.zero$mcF$sp(), n0.sqrt$mcF$sp(s.abs$mcF$sp(this.real()))) : new Complex$mcF$sp(n0.sqrt$mcF$sp(s.abs$mcF$sp(this.real())), f.zero$mcF$sp());
        } else {
            float two = f.fromInt$mcF$sp(2);
            float abs = this.abs$mcF$sp(f, n0, s);
            float a = n0.sqrt$mcF$sp(f.div$mcF$sp(f.plus$mcF$sp(abs, this.real()), two));
            float b = n0.sqrt$mcF$sp(f.div$mcF$sp(f.minus$mcF$sp(abs, this.real()), two));
            complex$mcF$sp = s.isSignNegative$mcF$sp(this.imag()) ? new Complex$mcF$sp(a, f.negate$mcF$sp(b)) : new Complex$mcF$sp(a, b);
        }
        return complex$mcF$sp;
    }

    @Override
    public Complex<Object> floor(IsReal<Object> o) {
        return this.floor$mcF$sp(o);
    }

    @Override
    public Complex<Object> floor$mcF$sp(IsReal<Object> o) {
        return new Complex$mcF$sp(o.floor$mcF$sp(this.real()), o.floor$mcF$sp(this.imag()));
    }

    @Override
    public Complex<Object> ceil(IsReal<Object> o) {
        return this.ceil$mcF$sp(o);
    }

    @Override
    public Complex<Object> ceil$mcF$sp(IsReal<Object> o) {
        return new Complex$mcF$sp(o.ceil$mcF$sp(this.real()), o.ceil$mcF$sp(this.imag()));
    }

    @Override
    public Complex<Object> round(IsReal<Object> o) {
        return this.round$mcF$sp(o);
    }

    @Override
    public Complex<Object> round$mcF$sp(IsReal<Object> o) {
        return new Complex$mcF$sp(o.round$mcF$sp(this.real()), o.round$mcF$sp(this.imag()));
    }

    @Override
    public Complex<Object> acos(Field<Object> f, NRoot<Object> n, Trig<Object> t, Signed<Object> s0) {
        return this.acos$mcF$sp(f, n, t, s0);
    }

    @Override
    public Complex<Object> acos$mcF$sp(Field<Object> f, NRoot<Object> n, Trig<Object> t, Signed<Object> s0) {
        Complex<Object> z2 = this.$times$mcF$sp(this, f);
        Complex<Object> s = new Complex$mcF$sp(f.minus$mcF$sp(f.one$mcF$sp(), z2.real$mcF$sp()), f.negate$mcF$sp(z2.imag$mcF$sp())).sqrt$mcF$sp(f, n, s0);
        Complex<Object> l = new Complex$mcF$sp(f.plus$mcF$sp(this.real(), s.imag$mcF$sp()), f.plus$mcF$sp(this.imag(), s.real$mcF$sp())).log$mcF$sp(f, n, t, s0);
        return new Complex$mcF$sp(l.imag$mcF$sp(), f.negate$mcF$sp(l.real$mcF$sp()));
    }

    @Override
    public Complex<Object> asin(Field<Object> f, NRoot<Object> n, Trig<Object> t, Signed<Object> s0) {
        return this.asin$mcF$sp(f, n, t, s0);
    }

    @Override
    public Complex<Object> asin$mcF$sp(Field<Object> f, NRoot<Object> n, Trig<Object> t, Signed<Object> s0) {
        Complex<Object> z2 = this.$times$mcF$sp(this, f);
        Complex<Object> s = new Complex$mcF$sp(f.minus$mcF$sp(f.one$mcF$sp(), z2.real$mcF$sp()), f.negate$mcF$sp(z2.imag$mcF$sp())).sqrt$mcF$sp(f, n, s0);
        Complex<Object> l = new Complex$mcF$sp(f.plus$mcF$sp(s.real$mcF$sp(), f.negate$mcF$sp(this.imag())), f.plus$mcF$sp(s.imag$mcF$sp(), this.real())).log$mcF$sp(f, n, t, s0);
        return new Complex$mcF$sp(l.imag$mcF$sp(), f.negate$mcF$sp(l.real$mcF$sp()));
    }

    @Override
    public Complex<Object> atan(Field<Object> f, NRoot<Object> r, Trig<Object> t, Signed<Object> s0) {
        return this.atan$mcF$sp(f, r, t, s0);
    }

    @Override
    public Complex<Object> atan$mcF$sp(Field<Object> f, NRoot<Object> r, Trig<Object> t, Signed<Object> s0) {
        Complex$mcF$sp n = new Complex$mcF$sp(this.real(), f.plus$mcF$sp(this.imag(), f.one$mcF$sp()));
        Complex$mcF$sp d = new Complex$mcF$sp(f.negate$mcF$sp(this.real()), f.minus$mcF$sp(f.one$mcF$sp(), this.imag()));
        Complex<Object> l = ((Complex)n).$div$mcF$sp(d, f, s0).log$mcF$sp(f, r, t, s0);
        return new Complex$mcF$sp(f.div$mcF$sp(l.imag$mcF$sp(), f.fromInt$mcF$sp(-2)), f.div$mcF$sp(l.real$mcF$sp(), f.fromInt$mcF$sp(2)));
    }

    @Override
    public Complex<Object> exp(Field<Object> f, Trig<Object> t) {
        return this.exp$mcF$sp(f, t);
    }

    @Override
    public Complex<Object> exp$mcF$sp(Field<Object> f, Trig<Object> t) {
        return new Complex$mcF$sp(f.times$mcF$sp(t.exp$mcF$sp(this.real()), t.cos$mcF$sp(this.imag())), f.times$mcF$sp(t.exp$mcF$sp(this.real()), t.sin$mcF$sp(this.imag())));
    }

    @Override
    public Complex<Object> sin(Field<Object> f, Trig<Object> t) {
        return this.sin$mcF$sp(f, t);
    }

    @Override
    public Complex<Object> sin$mcF$sp(Field<Object> f, Trig<Object> t) {
        return new Complex$mcF$sp(f.times$mcF$sp(t.sin$mcF$sp(this.real()), t.cosh$mcF$sp(this.imag())), f.times$mcF$sp(t.cos$mcF$sp(this.real()), t.sinh$mcF$sp(this.imag())));
    }

    @Override
    public Complex<Object> sinh(Field<Object> f, Trig<Object> t) {
        return this.sinh$mcF$sp(f, t);
    }

    @Override
    public Complex<Object> sinh$mcF$sp(Field<Object> f, Trig<Object> t) {
        return new Complex$mcF$sp(f.times$mcF$sp(t.sinh$mcF$sp(this.real()), t.cos$mcF$sp(this.imag())), f.times$mcF$sp(t.cosh$mcF$sp(this.real()), t.sin$mcF$sp(this.imag())));
    }

    @Override
    public Complex<Object> cos(Field<Object> f, Trig<Object> t) {
        return this.cos$mcF$sp(f, t);
    }

    @Override
    public Complex<Object> cos$mcF$sp(Field<Object> f, Trig<Object> t) {
        return new Complex$mcF$sp(f.times$mcF$sp(t.cos$mcF$sp(this.real()), t.cosh$mcF$sp(this.imag())), f.times$mcF$sp(f.negate$mcF$sp(t.sin$mcF$sp(this.real())), t.sinh$mcF$sp(this.imag())));
    }

    @Override
    public Complex<Object> cosh(Field<Object> f, Trig<Object> t) {
        return this.cosh$mcF$sp(f, t);
    }

    @Override
    public Complex<Object> cosh$mcF$sp(Field<Object> f, Trig<Object> t) {
        return new Complex$mcF$sp(f.times$mcF$sp(t.cosh$mcF$sp(this.real()), t.cos$mcF$sp(this.imag())), f.times$mcF$sp(t.sinh$mcF$sp(this.real()), t.sin$mcF$sp(this.imag())));
    }

    @Override
    public Complex<Object> tan(Field<Object> f, Trig<Object> t) {
        return this.tan$mcF$sp(f, t);
    }

    @Override
    public Complex<Object> tan$mcF$sp(Field<Object> f, Trig<Object> t) {
        float r2 = f.plus$mcF$sp(this.real(), this.real());
        float i2 = f.plus$mcF$sp(this.imag(), this.imag());
        float d = f.plus$mcF$sp(t.cos$mcF$sp(r2), t.cosh$mcF$sp(i2));
        return new Complex$mcF$sp(f.div$mcF$sp(t.sin$mcF$sp(r2), d), f.div$mcF$sp(t.sinh$mcF$sp(i2), d));
    }

    @Override
    public Complex<Object> tanh(Field<Object> f, Trig<Object> t) {
        return this.tanh$mcF$sp(f, t);
    }

    @Override
    public Complex<Object> tanh$mcF$sp(Field<Object> f, Trig<Object> t) {
        float r2 = f.plus$mcF$sp(this.real(), this.real());
        float i2 = f.plus$mcF$sp(this.imag(), this.imag());
        float d = f.plus$mcF$sp(t.cos$mcF$sp(r2), t.cosh$mcF$sp(i2));
        return new Complex$mcF$sp(f.div$mcF$sp(t.sinh$mcF$sp(r2), d), f.div$mcF$sp(t.sin$mcF$sp(i2), d));
    }

    @Override
    public Quaternion<Object> toQuaternion(AdditiveMonoid<Object> ev) {
        return this.toQuaternion$mcF$sp(ev);
    }

    @Override
    public Quaternion<Object> toQuaternion$mcF$sp(AdditiveMonoid<Object> ev) {
        return new Quaternion$mcF$sp(this.real(), this.imag(), ev.zero$mcF$sp(), ev.zero$mcF$sp());
    }

    @Override
    public <T> float copy$default$1() {
        return this.copy$default$1$mcF$sp();
    }

    @Override
    public <T> float copy$default$1$mcF$sp() {
        return this.real();
    }

    @Override
    public <T> float copy$default$2() {
        return this.copy$default$2$mcF$sp();
    }

    @Override
    public <T> float copy$default$2$mcF$sp() {
        return this.imag();
    }

    @Override
    public boolean specInstance$() {
        return true;
    }

    public Complex$mcF$sp(float real$mcF$sp, float imag$mcF$sp) {
        this.real$mcF$sp = real$mcF$sp;
        this.imag$mcF$sp = imag$mcF$sp;
        super(null, null);
    }
}

