/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.jwt;

import com.google.crypto.tink.PrimitiveSet;
import com.google.crypto.tink.PrimitiveWrapper;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.jwt.JwtFormat;
import com.google.crypto.tink.jwt.JwtInvalidException;
import com.google.crypto.tink.jwt.JwtMac;
import com.google.crypto.tink.jwt.JwtMacInternal;
import com.google.crypto.tink.jwt.JwtValidator;
import com.google.crypto.tink.jwt.RawJwt;
import com.google.crypto.tink.jwt.VerifiedJwt;
import com.google.crypto.tink.proto.OutputPrefixType;
import com.google.errorprone.annotations.Immutable;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Optional;

class JwtMacWrapper
implements PrimitiveWrapper<JwtMacInternal, JwtMac> {
    private static final JwtMacWrapper WRAPPER = new JwtMacWrapper();

    private static void validate(PrimitiveSet<JwtMacInternal> primitiveSet) throws GeneralSecurityException {
        if (primitiveSet.getPrimary() == null) {
            throw new GeneralSecurityException("Primitive set has no primary.");
        }
        for (List<PrimitiveSet.Entry<JwtMacInternal>> entries : primitiveSet.getAll()) {
            for (PrimitiveSet.Entry<JwtMacInternal> entry : entries) {
                if (entry.getOutputPrefixType() == OutputPrefixType.RAW || entry.getOutputPrefixType() == OutputPrefixType.TINK) continue;
                throw new GeneralSecurityException("unsupported OutputPrefixType");
            }
        }
    }

    JwtMacWrapper() {
    }

    @Override
    public JwtMac wrap(PrimitiveSet<JwtMacInternal> primitives) throws GeneralSecurityException {
        JwtMacWrapper.validate(primitives);
        return new WrappedJwtMac(primitives);
    }

    @Override
    public Class<JwtMac> getPrimitiveClass() {
        return JwtMac.class;
    }

    @Override
    public Class<JwtMacInternal> getInputPrimitiveClass() {
        return JwtMacInternal.class;
    }

    public static void register() throws GeneralSecurityException {
        Registry.registerPrimitiveWrapper(WRAPPER);
    }

    @Immutable
    private static class WrappedJwtMac
    implements JwtMac {
        private final PrimitiveSet<JwtMacInternal> primitives;

        private WrappedJwtMac(PrimitiveSet<JwtMacInternal> primitives) {
            this.primitives = primitives;
        }

        @Override
        public String computeMacAndEncode(RawJwt token) throws GeneralSecurityException {
            PrimitiveSet.Entry<JwtMacInternal> entry = this.primitives.getPrimary();
            Optional<String> kid = JwtFormat.getKid(entry.getKeyId(), entry.getOutputPrefixType());
            return entry.getPrimitive().computeMacAndEncodeWithKid(token, kid);
        }

        @Override
        public VerifiedJwt verifyMacAndDecode(String compact, JwtValidator validator) throws GeneralSecurityException {
            GeneralSecurityException interestingException = null;
            for (List<PrimitiveSet.Entry<JwtMacInternal>> entries : this.primitives.getAll()) {
                for (PrimitiveSet.Entry<JwtMacInternal> entry : entries) {
                    try {
                        Optional<String> kid = JwtFormat.getKid(entry.getKeyId(), entry.getOutputPrefixType());
                        return entry.getPrimitive().verifyMacAndDecodeWithKid(compact, validator, kid);
                    }
                    catch (GeneralSecurityException e) {
                        if (!(e instanceof JwtInvalidException)) continue;
                        interestingException = e;
                    }
                }
            }
            if (interestingException != null) {
                throw interestingException;
            }
            throw new GeneralSecurityException("invalid MAC");
        }
    }
}

