/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.ContainerFluentImpl;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarSourceBuilder;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodFluentImpl;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.Quantity;
import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import javax.ws.rs.core.UriBuilder;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesDriverConf;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.features.KubernetesFeatureConfigStep;
import org.apache.spark.deploy.k8s.submit.NonJVMResource;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.resource.ResourceProfile$;
import org.apache.spark.ui.SparkUI$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001]4Q!\u0007\u000e\u0001A\u0019B\u0001\"\r\u0001\u0003\u0002\u0003\u0006Ia\r\u0005\u0006o\u0001!\t\u0001\u000f\u0005\bw\u0001\u0011\r\u0011\"\u0003=\u0011\u0019A\u0005\u0001)A\u0005{!9\u0011\n\u0001b\u0001\n\u0013a\u0004B\u0002&\u0001A\u0003%Q\bC\u0004L\u0001\t\u0007I\u0011\u0002'\t\rA\u0003\u0001\u0015!\u0003N\u0011\u001d\t\u0006A1A\u0005\nqBaA\u0015\u0001!\u0002\u0013i\u0004bB*\u0001\u0005\u0004%I\u0001\u0016\u0005\u00071\u0002\u0001\u000b\u0011B+\t\u000fe\u0003!\u0019!C\u00055\"1a\f\u0001Q\u0001\nmCqa\u0018\u0001C\u0002\u0013%\u0001\r\u0003\u0004e\u0001\u0001\u0006I!\u0019\u0005\bK\u0002\u0011\r\u0011\"\u0003a\u0011\u00191\u0007\u0001)A\u0005C\"9q\r\u0001b\u0001\n\u0013Q\u0006B\u00025\u0001A\u0003%1\fC\u0004j\u0001\t\u0007I\u0011\u0002.\t\r)\u0004\u0001\u0015!\u0003\\\u0011\u0015Y\u0007\u0001\"\u0011m\u0011\u0015\u0011\b\u0001\"\u0011t\u0005Y\u0011\u0015m]5d\tJLg/\u001a:GK\u0006$XO]3Ti\u0016\u0004(BA\u000e\u001d\u0003!1W-\u0019;ve\u0016\u001c(BA\u000f\u001f\u0003\rY\u0007h\u001d\u0006\u0003?\u0001\na\u0001Z3qY>L(BA\u0011#\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0019C%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002K\u0005\u0019qN]4\u0014\u0007\u00019S\u0006\u0005\u0002)W5\t\u0011FC\u0001+\u0003\u0015\u00198-\u00197b\u0013\ta\u0013F\u0001\u0004B]f\u0014VM\u001a\t\u0003]=j\u0011AG\u0005\u0003ai\u00111dS;cKJtW\r^3t\r\u0016\fG/\u001e:f\u0007>tg-[4Ti\u0016\u0004\u0018\u0001B2p]\u001a\u001c\u0001\u0001\u0005\u00025k5\tA$\u0003\u000279\t!2*\u001e2fe:,G/Z:Ee&4XM]\"p]\u001a\fa\u0001P5oSRtDCA\u001d;!\tq\u0003\u0001C\u00032\u0005\u0001\u00071'A\u0007ee&4XM\u001d)pI:\u000bW.Z\u000b\u0002{A\u0011a(\u0012\b\u0003\u007f\r\u0003\"\u0001Q\u0015\u000e\u0003\u0005S!A\u0011\u001a\u0002\rq\u0012xn\u001c;?\u0013\t!\u0015&\u0001\u0004Qe\u0016$WMZ\u0005\u0003\r\u001e\u0013aa\u0015;sS:<'B\u0001#*\u00039!'/\u001b<feB{GMT1nK\u0002\nA\u0003\u001a:jm\u0016\u00148i\u001c8uC&tWM]%nC\u001e,\u0017!\u00063sSZ,'oQ8oi\u0006Lg.\u001a:J[\u0006<W\rI\u0001\u000fIJLg/\u001a:DaV\u001cuN]3t+\u0005i\u0005C\u0001\u0015O\u0013\ty\u0015FA\u0002J]R\fq\u0002\u001a:jm\u0016\u00148\t];D_J,7\u000fI\u0001\u0013IJLg/\u001a:D_J,7OU3rk\u0016\u001cH/A\nee&4XM]\"pe\u0016\u001c(+Z9vKN$\b%\u0001\tee&4XM\u001d'j[&$8i\u001c:fgV\tQ\u000bE\u0002)-vJ!aV\u0015\u0003\r=\u0003H/[8o\u0003E!'/\u001b<fe2KW.\u001b;D_J,7\u000fI\u0001\u0010IJLg/\u001a:NK6|'/_'j\u0005V\t1\f\u0005\u0002)9&\u0011Q,\u000b\u0002\u0005\u0019>tw-\u0001\tee&4XM]'f[>\u0014\u00180T5CA\u0005)B-\u001a4bk2$xJ^3sQ\u0016\fGMR1di>\u0014X#A1\u0011\u0005!\u0012\u0017BA2*\u0005\u0019!u.\u001e2mK\u00061B-\u001a4bk2$xJ^3sQ\u0016\fGMR1di>\u0014\b%\u0001\u000bnK6|'/_(wKJDW-\u00193GC\u000e$xN]\u0001\u0016[\u0016lwN]=Pm\u0016\u0014\b.Z1e\r\u0006\u001cGo\u001c:!\u0003EiW-\\8ss>3XM\u001d5fC\u0012l\u0015NQ\u0001\u0013[\u0016lwN]=Pm\u0016\u0014\b.Z1e\u001b&\u0014\u0005%A\u000eee&4XM]'f[>\u0014\u0018pV5uQ>3XM\u001d5fC\u0012l\u0015NQ\u0001\u001dIJLg/\u001a:NK6|'/_,ji\"|e/\u001a:iK\u0006$W*\u001b\"!\u00031\u0019wN\u001c4jOV\u0014X\rU8e)\ti\u0007\u000f\u0005\u00025]&\u0011q\u000e\b\u0002\t'B\f'o\u001b)pI\")\u0011o\u0006a\u0001[\u0006\u0019\u0001o\u001c3\u0002A\u001d,G/\u00113eSRLwN\\1m!>$7+_:uK6\u0004&o\u001c9feRLWm\u001d\u000b\u0002iB!a(^\u001f>\u0013\t1xIA\u0002NCB\u0004")
public class BasicDriverFeatureStep
implements KubernetesFeatureConfigStep {
    private final KubernetesDriverConf conf;
    private final String driverPodName;
    private final String driverContainerImage;
    private final int driverCpuCores;
    private final String driverCoresRequest;
    private final Option<String> driverLimitCores;
    private final long driverMemoryMiB;
    private final double defaultOverheadFactor;
    private final double memoryOverheadFactor;
    private final long memoryOverheadMiB;
    private final long driverMemoryWithOverheadMiB;

    @Override
    public Seq<HasMetadata> getAdditionalPreKubernetesResources() {
        return KubernetesFeatureConfigStep.getAdditionalPreKubernetesResources$(this);
    }

    @Override
    public Seq<HasMetadata> getAdditionalKubernetesResources() {
        return KubernetesFeatureConfigStep.getAdditionalKubernetesResources$(this);
    }

    private String driverPodName() {
        return this.driverPodName;
    }

    private String driverContainerImage() {
        return this.driverContainerImage;
    }

    private int driverCpuCores() {
        return this.driverCpuCores;
    }

    private String driverCoresRequest() {
        return this.driverCoresRequest;
    }

    private Option<String> driverLimitCores() {
        return this.driverLimitCores;
    }

    private long driverMemoryMiB() {
        return this.driverMemoryMiB;
    }

    private double defaultOverheadFactor() {
        return this.defaultOverheadFactor;
    }

    private double memoryOverheadFactor() {
        return this.memoryOverheadFactor;
    }

    private long memoryOverheadMiB() {
        return this.memoryOverheadMiB;
    }

    private long driverMemoryWithOverheadMiB() {
        return this.driverMemoryWithOverheadMiB;
    }

    @Override
    public SparkPod configurePod(SparkPod pod) {
        Seq<EnvVar> driverCustomEnvs = KubernetesUtils$.MODULE$.buildEnvVars((Seq<Tuple2<String, String>>)((Seq)((TraversableLike)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_APPLICATION_ID()), (Object)this.conf.appId()), (List)Nil$.MODULE$)).$plus$plus(this.conf.environment(), Seq$.MODULE$.canBuildFrom())));
        Quantity driverCpuQuantity = new Quantity(this.driverCoresRequest());
        Quantity driverMemoryQuantity = new Quantity(new StringBuilder(2).append(this.driverMemoryWithOverheadMiB()).append("Mi").toString());
        Option maybeCpuLimitQuantity = this.driverLimitCores().map((Function1 & Serializable & scala.Serializable)limitCores -> new Tuple2((Object)"cpu", (Object)new Quantity(limitCores)));
        scala.collection.immutable.Map<String, Quantity> driverResourceQuantities = KubernetesUtils$.MODULE$.buildResourcesQuantities(org.apache.spark.internal.config.package$.MODULE$.SPARK_DRIVER_PREFIX(), this.conf.sparkConf());
        int driverPort = this.conf.sparkConf().getInt(org.apache.spark.internal.config.package$.MODULE$.DRIVER_PORT().key(), Constants$.MODULE$.DEFAULT_DRIVER_PORT());
        int driverBlockManagerPort = this.conf.sparkConf().getInt(org.apache.spark.internal.config.package$.MODULE$.DRIVER_BLOCK_MANAGER_PORT().key(), this.conf.sparkConf().getInt(org.apache.spark.internal.config.package$.MODULE$.BLOCK_MANAGER_PORT().key(), Constants$.MODULE$.DEFAULT_BLOCKMANAGER_PORT()));
        int driverUIPort = SparkUI$.MODULE$.getUIPort(this.conf.sparkConf());
        Container driverContainer = ((ContainerBuilder)((ContainerFluent.ResourcesNested)((ContainerFluentImpl)((ContainerFluent.EnvNested)((ContainerFluentImpl)((ContainerFluentImpl)((ContainerFluent.EnvNested)((ContainerFluentImpl)((ContainerFluent.PortsNested)((ContainerFluentImpl)((ContainerFluent.PortsNested)((ContainerFluentImpl)((ContainerFluent.PortsNested)((ContainerFluentImpl)((ContainerFluentImpl)((ContainerFluentImpl)new ContainerBuilder(pod.container()).withName((String)Option$.MODULE$.apply((Object)pod.container().getName()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Constants$.MODULE$.DEFAULT_DRIVER_CONTAINER_NAME()))).withImage(this.driverContainerImage())).withImagePullPolicy(this.conf.imagePullPolicy())).addNewPort().withName(Constants$.MODULE$.DRIVER_PORT_NAME()).withContainerPort(Predef$.MODULE$.int2Integer(driverPort)).withProtocol("TCP")).endPort()).addNewPort().withName(Constants$.MODULE$.BLOCK_MANAGER_PORT_NAME()).withContainerPort(Predef$.MODULE$.int2Integer(driverBlockManagerPort)).withProtocol("TCP")).endPort()).addNewPort().withName(Constants$.MODULE$.UI_PORT_NAME()).withContainerPort(Predef$.MODULE$.int2Integer(driverUIPort)).withProtocol("TCP")).endPort()).addNewEnv().withName(Constants$.MODULE$.ENV_SPARK_USER()).withValue(Utils$.MODULE$.getCurrentUserName())).endEnv()).addAllToEnv((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(driverCustomEnvs).asJava())).addNewEnv().withName(Constants$.MODULE$.ENV_DRIVER_BIND_ADDRESS()).withValueFrom(((EnvVarSourceBuilder)new EnvVarSourceBuilder().withNewFieldRef("v1", "status.podIP")).build())).endEnv()).editOrNewResources().addToRequests("cpu", driverCpuQuantity).addToLimits((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Option$.MODULE$.option2Iterable(maybeCpuLimitQuantity).toMap(Predef$.MODULE$.$conforms())).asJava()).addToRequests("memory", driverMemoryQuantity).addToLimits("memory", driverMemoryQuantity).addToLimits((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(driverResourceQuantities).asJava())).endResources()).build();
        Pod driverPod = ((PodBuilder)((PodFluent.SpecNested)((PodFluentImpl)((PodFluent.MetadataNested)new PodBuilder(pod.pod()).editOrNewMetadata().withName(this.driverPodName()).addToLabels((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.conf.labels()).asJava()).addToAnnotations((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)this.conf.annotations().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return new Tuple2((Object)k, (Object)Utils$.MODULE$.substituteAppNExecIds(v, $this.conf.appId(), ""));
            }
            throw new MatchError((Object)tuple2);
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom())).asJava())).endMetadata()).editOrNewSpec().withRestartPolicy("Never").addToNodeSelector((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.conf.nodeSelector()).asJava()).addToNodeSelector((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.conf.driverNodeSelector()).asJava()).addToImagePullSecrets((LocalObjectReference[])this.conf.imagePullSecrets().toArray(ClassTag$.MODULE$.apply(LocalObjectReference.class)))).endSpec()).build();
        PodSpec podSpec = driverPod.getSpec();
        this.conf.schedulerName().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            podSpec.setSchedulerName(x$1);
            return BoxedUnit.UNIT;
        });
        return new SparkPod(driverPod, driverContainer);
    }

    @Override
    public scala.collection.immutable.Map<String, String> getAdditionalPodSystemProperties() {
        scala.collection.mutable.Map additionalProps = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Config$.MODULE$.KUBERNETES_DRIVER_POD_NAME().key()), (Object)this.driverPodName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.app.id"), (Object)this.conf.appId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Config$.MODULE$.KUBERNETES_DRIVER_SUBMIT_CHECK().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Config$.MODULE$.MEMORY_OVERHEAD_FACTOR().key()), (Object)Double.toString(this.defaultOverheadFactor()))}));
        ((IterableLike)new .colon.colon((Object)org.apache.spark.internal.config.package$.MODULE$.JARS(), (List)new .colon.colon((Object)org.apache.spark.internal.config.package$.MODULE$.FILES(), (List)new .colon.colon((Object)org.apache.spark.internal.config.package$.MODULE$.ARCHIVES(), (List)new .colon.colon((Object)org.apache.spark.internal.config.package$.MODULE$.SUBMIT_PYTHON_FILES(), (List)Nil$.MODULE$))))).foreach((Function1 & Serializable & scala.Serializable)key -> {
            Tuple2 tuple2 = ((TraversableLike)$this.conf.get(key)).partition((Function1 & Serializable & scala.Serializable)uri -> BoxesRunTime.boxToBoolean((boolean)KubernetesUtils$.MODULE$.isLocalAndResolvable(uri)));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq localUris = (Seq)tuple2._1();
            Seq remoteUris = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)localUris, (Object)remoteUris);
            Seq localUris2 = (Seq)tuple22._1();
            Seq remoteUris2 = (Seq)tuple22._2();
            ConfigEntry configEntry = key;
            ConfigEntry configEntry2 = org.apache.spark.internal.config.package$.MODULE$.ARCHIVES();
            Seq value = !(configEntry != null ? !configEntry.equals(configEntry2) : configEntry2 != null) ? (Seq)((TraversableLike)localUris2.map((Function1 & Serializable & scala.Serializable)x$2 -> UriBuilder.fromUri((String)x$2).fragment(null).build(new Object[0]), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toString(), Seq$.MODULE$.canBuildFrom()) : localUris2;
            Iterable resolved = KubernetesUtils$.MODULE$.uploadAndTransformFileUris((Iterable<String>)value, (Option<SparkConf>)new Some((Object)$this.conf.sparkConf()));
            if (resolved.nonEmpty()) {
                ConfigEntry configEntry3 = key;
                ConfigEntry configEntry4 = org.apache.spark.internal.config.package$.MODULE$.ARCHIVES();
                Iterable resolvedValue = !(configEntry3 != null ? !configEntry3.equals(configEntry4) : configEntry4 != null) ? (Iterable)((TraversableLike)localUris2.zip(resolved, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        String uri = (String)tuple2._1();
                        String r = (String)tuple2._2();
                        return UriBuilder.fromUri((String)r).fragment(new URI(uri).getFragment()).build(new Object[0]).toString();
                    }
                    throw new MatchError((Object)tuple2);
                }, Seq$.MODULE$.canBuildFrom()) : resolved;
                return additionalProps.put((Object)key.key(), (Object)((TraversableOnce)resolvedValue.$plus$plus((GenTraversableOnce)remoteUris2, Iterable$.MODULE$.canBuildFrom())).mkString(","));
            }
            return BoxedUnit.UNIT;
        });
        return additionalProps.toMap(Predef$.MODULE$.$conforms());
    }

    public BasicDriverFeatureStep(KubernetesDriverConf conf) {
        this.conf = conf;
        KubernetesFeatureConfigStep.$init$(this);
        this.driverPodName = (String)((Option)conf.get(Config$.MODULE$.KUBERNETES_DRIVER_POD_NAME())).getOrElse((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(7).append($this.conf.resourceNamePrefix()).append("-driver").toString());
        this.driverContainerImage = (String)conf.get(Config$.MODULE$.DRIVER_CONTAINER_IMAGE()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new SparkException("Must specify the driver container image");
        });
        this.driverCpuCores = BoxesRunTime.unboxToInt(conf.get(org.apache.spark.internal.config.package$.MODULE$.DRIVER_CORES()));
        this.driverCoresRequest = (String)((Option)conf.get(Config$.MODULE$.KUBERNETES_DRIVER_REQUEST_CORES())).getOrElse((Function0 & Serializable & scala.Serializable)() -> Integer.toString(this.driverCpuCores()));
        this.driverLimitCores = (Option)conf.get(Config$.MODULE$.KUBERNETES_DRIVER_LIMIT_CORES());
        this.driverMemoryMiB = BoxesRunTime.unboxToLong(conf.get(org.apache.spark.internal.config.package$.MODULE$.DRIVER_MEMORY()));
        this.defaultOverheadFactor = conf.mainAppResource() instanceof NonJVMResource ? (conf.contains(Config$.MODULE$.MEMORY_OVERHEAD_FACTOR()) ? BoxesRunTime.unboxToDouble((Object)conf.get(Config$.MODULE$.MEMORY_OVERHEAD_FACTOR())) : Constants$.MODULE$.NON_JVM_MEMORY_OVERHEAD_FACTOR()) : BoxesRunTime.unboxToDouble((Object)conf.get(Config$.MODULE$.MEMORY_OVERHEAD_FACTOR()));
        this.memoryOverheadFactor = conf.contains(org.apache.spark.internal.config.package$.MODULE$.DRIVER_MEMORY_OVERHEAD_FACTOR()) ? BoxesRunTime.unboxToDouble(conf.get(org.apache.spark.internal.config.package$.MODULE$.DRIVER_MEMORY_OVERHEAD_FACTOR())) : this.defaultOverheadFactor();
        this.memoryOverheadMiB = BoxesRunTime.unboxToLong((Object)((Option)conf.get(org.apache.spark.internal.config.package$.MODULE$.DRIVER_MEMORY_OVERHEAD())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> package$.MODULE$.max((long)((int)(this.memoryOverheadFactor() * (double)this.driverMemoryMiB())), ResourceProfile$.MODULE$.MEMORY_OVERHEAD_MIN_MIB())));
        this.driverMemoryWithOverheadMiB = this.driverMemoryMiB() + this.memoryOverheadMiB();
    }
}

