/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ui.storage;

import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import org.apache.spark.status.api.v1.ExecutorSummary;
import org.apache.spark.status.api.v1.RDDPartitionInfo;
import org.apache.spark.ui.PagedTable;
import org.apache.spark.ui.storage.BlockDataSource;
import org.apache.spark.ui.storage.BlockTableRowData;
import org.apache.spark.util.Utils$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;

@ScalaSignature(bytes="\u0006\u0001\u0005}b!\u0002\r\u001a\u0001m\u0019\u0003\u0002\u0003\u001a\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001b\t\u0011y\u0002!\u0011!Q\u0001\n}B\u0001B\u0013\u0001\u0003\u0002\u0003\u0006Ia\u0010\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\u0019\"AA\f\u0001B\u0001B\u0003%Q\fC\u0003i\u0001\u0011\u0005\u0011\u000e\u0003\u0006q\u0001A\u0005\t1!Q\u0001\nEDqA\u001f\u0001C\u0002\u0013%1\u0010\u0003\u0004}\u0001\u0001\u0006Ia\u0010\u0005\b{\u0002\u0011\r\u0011\"\u0003\u007f\u0011\u0019y\b\u0001)A\u0005i\"I\u0011\u0011\u0001\u0001C\u0002\u0013%\u00111\u0001\u0005\b\u0003\u000b\u0001\u0001\u0015!\u0003x\u0011\u0019\t9\u0001\u0001C!w\"1\u0011\u0011\u0002\u0001\u0005BmDa!a\u0003\u0001\t\u0003Z\bBBA\u0007\u0001\u0011\u00053\u0010C\u0005\u0002\u0010\u0001\u0011\r\u0011\"\u0011\u0002\u0012!A\u0011\u0011\u0004\u0001!\u0002\u0013\t\u0019\u0002C\u0004\u0002\u001c\u0001!\t%!\b\t\r\u0005\r\u0002\u0001\"\u0011|\u0011\u001d\t)\u0003\u0001C!\u0003OAq!a\u000e\u0001\t\u0003\nIDA\bCY>\u001c7\u000eU1hK\u0012$\u0016M\u00197f\u0015\tQ2$A\u0004ti>\u0014\u0018mZ3\u000b\u0005qi\u0012AA;j\u0015\tqr$A\u0003ta\u0006\u00148N\u0003\u0002!C\u00051\u0011\r]1dQ\u0016T\u0011AI\u0001\u0004_J<7c\u0001\u0001%UA\u0011Q\u0005K\u0007\u0002M)\tq%A\u0003tG\u0006d\u0017-\u0003\u0002*M\t1\u0011I\\=SK\u001a\u00042a\u000b\u0017/\u001b\u0005Y\u0012BA\u0017\u001c\u0005)\u0001\u0016mZ3e)\u0006\u0014G.\u001a\t\u0003_Aj\u0011!G\u0005\u0003ce\u0011\u0011C\u00117pG.$\u0016M\u00197f%><H)\u0019;b\u0003\u001d\u0011X-];fgR\u001c\u0001\u0001\u0005\u00026y5\taG\u0003\u00028q\u0005!\u0001\u000e\u001e;q\u0015\tI$(A\u0004tKJ4H.\u001a;\u000b\u0003m\nQA[1wCbL!!\u0010\u001c\u0003%!#H\u000f]*feZdW\r\u001e*fcV,7\u000f^\u0001\u0007e\u0012$G+Y4\u0011\u0005\u0001;eBA!F!\t\u0011e%D\u0001D\u0015\t!5'\u0001\u0004=e>|GOP\u0005\u0003\r\u001a\na\u0001\u0015:fI\u00164\u0017B\u0001%J\u0005\u0019\u0019FO]5oO*\u0011aIJ\u0001\tE\u0006\u001cX\rU1uQ\u0006i!\u000f\u001a3QCJ$\u0018\u000e^5p]N\u00042!\u0014)S\u001b\u0005q%BA('\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003#:\u00131aU3r!\t\u0019&,D\u0001U\u0015\t)f+\u0001\u0002wc)\u0011q\u000bW\u0001\u0004CBL'BA-\u001e\u0003\u0019\u0019H/\u0019;vg&\u00111\f\u0016\u0002\u0011%\u0012#\u0005+\u0019:uSRLwN\\%oM>\f\u0011#\u001a=fGV$xN]*v[6\f'/[3t!\rq6-\u001a\b\u0003?\u0006t!A\u00111\n\u0003\u001dJ!A\u0019\u0014\u0002\u000fA\f7m[1hK&\u0011\u0011\u000b\u001a\u0006\u0003E\u001a\u0002\"a\u00154\n\u0005\u001d$&aD#yK\u000e,Ho\u001c:Tk6l\u0017M]=\u0002\rqJg.\u001b;?)\u0019Q7\u000e\\7o_B\u0011q\u0006\u0001\u0005\u0006e\u0019\u0001\r\u0001\u000e\u0005\u0006}\u0019\u0001\ra\u0010\u0005\u0006\u0015\u001a\u0001\ra\u0010\u0005\u0006\u0017\u001a\u0001\r\u0001\u0014\u0005\u00069\u001a\u0001\r!X\u0001\u0004q\u0012J\u0004#B\u0013s\u007fQ<\u0018BA:'\u0005\u0019!V\u000f\u001d7fgA\u0011Q%^\u0005\u0003m\u001a\u0012qAQ8pY\u0016\fg\u000e\u0005\u0002&q&\u0011\u0011P\n\u0002\u0004\u0013:$\u0018AC:peR\u001cu\u000e\\;n]V\tq(A\u0006t_J$8i\u001c7v[:\u0004\u0013\u0001\u00023fg\u000e,\u0012\u0001^\u0001\u0006I\u0016\u001c8\rI\u0001\ta\u0006<WmU5{KV\tq/A\u0005qC\u001e,7+\u001b>fA\u00059A/\u00192mK&#\u0017!\u0004;bE2,7i]:DY\u0006\u001c8/A\tqC\u001e,7+\u001b>f\r>\u0014XNR5fY\u0012\f1\u0003]1hK:+XNY3s\r>\u0014XNR5fY\u0012\f!\u0002Z1uCN{WO]2f+\t\t\u0019\u0002E\u00020\u0003+I1!a\u0006\u001a\u0005=\u0011En\\2l\t\u0006$\u0018mU8ve\u000e,\u0017a\u00033bi\u0006\u001cv.\u001e:dK\u0002\n\u0001\u0002]1hK2Kgn\u001b\u000b\u0004\u007f\u0005}\u0001BBA\u0011)\u0001\u0007q/\u0001\u0003qC\u001e,\u0017\u0001E4p\u0005V$Ho\u001c8G_Jl\u0007+\u0019;i\u0003\u001dAW-\u00193feN,\"!!\u000b\u0011\ty\u001b\u00171\u0006\t\u0005\u0003[\t\u0019$\u0004\u0002\u00020)\u0019\u0011\u0011\u0007\u0014\u0002\u0007alG.\u0003\u0003\u00026\u0005=\"\u0001\u0002(pI\u0016\f1A]8x)\u0011\tI#a\u000f\t\r\u0005ur\u00031\u0001/\u0003\u0015\u0011Gn\\2l\u0001")
public class BlockPagedTable
implements PagedTable<BlockTableRowData> {
    private final String rddTag;
    private final String basePath;
    private final /* synthetic */ Tuple3 x$9;
    private final String sortColumn;
    private final boolean desc;
    private final int pageSize;
    private final BlockDataSource dataSource;

    @Override
    public Seq<Node> table(int page) {
        return PagedTable.table$(this, page);
    }

    @Override
    public Seq<Node> pageNavigation(int page, int pageSize, int totalPages, String navigationId) {
        return PagedTable.pageNavigation$(this, page, pageSize, totalPages, navigationId);
    }

    @Override
    public String pageNavigation$default$4() {
        return PagedTable.pageNavigation$default$4$(this);
    }

    @Override
    public String getParameterOtherTable(HttpServletRequest request, String tableTag) {
        return PagedTable.getParameterOtherTable$(this, request, tableTag);
    }

    @Override
    public Tuple3<String, Object, Object> getTableParameters(HttpServletRequest request, String tableTag, String defaultSortColumn) {
        return PagedTable.getTableParameters$(this, request, tableTag, defaultSortColumn);
    }

    @Override
    public void isSortColumnValid(Seq<Tuple3<String, Object, Option<String>>> headerInfo, String sortColumn) {
        PagedTable.isSortColumnValid$(this, headerInfo, sortColumn);
    }

    @Override
    public Seq<Node> headerRow(Seq<Tuple3<String, Object, Option<String>>> headerInfo, boolean desc, int pageSize, String sortColumn, String parameterPath, String tableTag, String headerId) {
        return PagedTable.headerRow$(this, headerInfo, desc, pageSize, sortColumn, parameterPath, tableTag, headerId);
    }

    private String sortColumn() {
        return this.sortColumn;
    }

    private boolean desc() {
        return this.desc;
    }

    private int pageSize() {
        return this.pageSize;
    }

    @Override
    public String tableId() {
        return "rdd-storage-by-block-table";
    }

    @Override
    public String tableCssClass() {
        return "table table-bordered table-sm table-striped table-head-clickable";
    }

    @Override
    public String pageSizeFormField() {
        return new StringBuilder(9).append(this.rddTag).append(".pageSize").toString();
    }

    @Override
    public String pageNumberFormField() {
        return new StringBuilder(5).append(this.rddTag).append(".page").toString();
    }

    public BlockDataSource dataSource() {
        return this.dataSource;
    }

    @Override
    public String pageLink(int page) {
        String encodedSortColumn = URLEncoder.encode(this.sortColumn(), StandardCharsets.UTF_8.name());
        return new StringBuilder(28).append(this.basePath).append("&").append(this.pageNumberFormField()).append("=").append(page).append("&block.sort=").append(encodedSortColumn).append("&block.desc=").append(this.desc()).append("&").append(this.pageSizeFormField()).append("=").append(this.pageSize()).toString();
    }

    @Override
    public String goButtonFormPath() {
        String encodedSortColumn = URLEncoder.encode(this.sortColumn(), StandardCharsets.UTF_8.name());
        return new StringBuilder(24).append(this.basePath).append("&block.sort=").append(encodedSortColumn).append("&block.desc=").append(this.desc()).toString();
    }

    @Override
    public Seq<Node> headers() {
        Seq blockHeaders = (Seq)((TraversableLike)new .colon.colon((Object)"Block Name", (List)new .colon.colon((Object)"Storage Level", (List)new .colon.colon((Object)"Size in Memory", (List)new .colon.colon((Object)"Size on Disk", (List)new .colon.colon((Object)"Executors", (List)Nil$.MODULE$)))))).map((Function1 & Serializable & scala.Serializable)x -> new Tuple3(x, (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$), Seq$.MODULE$.canBuildFrom());
        this.isSortColumnValid((Seq<Tuple3<String, Object, Option<String>>>)blockHeaders, this.sortColumn());
        return this.headerRow((Seq<Tuple3<String, Object, Option<String>>>)blockHeaders, this.desc(), this.pageSize(), this.sortColumn(), this.basePath, this.rddTag, "block");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Seq<Node> row(BlockTableRowData block) {
        void var2_2;
        void var3_3;
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)block.blockName());
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_3));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)block.storageLevel());
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)Utils$.MODULE$.bytesToString(block.memoryUsed()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)Utils$.MODULE$.bytesToString(block.diskUsed()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)block.executors());
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var2_2);
    }

    public BlockPagedTable(HttpServletRequest request, String rddTag, String basePath, Seq<RDDPartitionInfo> rddPartitions, Seq<ExecutorSummary> executorSummaries) {
        this.rddTag = rddTag;
        this.basePath = basePath;
        PagedTable.$init$(this);
        Tuple3<String, Object, Object> tuple3 = this.getTableParameters(request, rddTag, "Block Name");
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String sortColumn = (String)tuple3._1();
        boolean desc = BoxesRunTime.unboxToBoolean((Object)tuple3._2());
        int pageSize = BoxesRunTime.unboxToInt((Object)tuple3._3());
        this.x$9 = new Tuple3((Object)sortColumn, (Object)BoxesRunTime.boxToBoolean((boolean)desc), (Object)BoxesRunTime.boxToInteger((int)pageSize));
        this.sortColumn = (String)this.x$9._1();
        this.desc = BoxesRunTime.unboxToBoolean((Object)this.x$9._2());
        this.pageSize = BoxesRunTime.unboxToInt((Object)this.x$9._3());
        this.dataSource = new BlockDataSource(rddPartitions, this.pageSize(), this.sortColumn(), this.desc(), (Map<String, String>)((TraversableOnce)executorSummaries.map((Function1 & Serializable & scala.Serializable)ex -> new Tuple2((Object)ex.id(), (Object)ex.hostPort()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
    }
}

