/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.lang.reflect.Method;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.NucleusLogger;

public class TypeConverterHelper {
    public static Class getMemberTypeForTypeConverter(TypeConverter conv, Class datastoreType) {
        try {
            Method m = conv.getClass().getMethod("toMemberType", datastoreType);
            return m.getReturnType();
        }
        catch (Exception e) {
            try {
                Method m = conv.getClass().getMethod("getMemberClass", new Class[0]);
                return (Class)m.invoke((Object)conv, new Object[0]);
            }
            catch (Exception e2) {
                NucleusLogger.GENERAL.warn("Converter " + conv + " didn't have adequate information from toMemberType nor from getMemberClass");
                return null;
            }
        }
    }

    public static Class getDatastoreTypeForTypeConverter(TypeConverter conv, Class memberType) {
        try {
            Method m = conv.getClass().getMethod("toDatastoreType", memberType);
            return m.getReturnType();
        }
        catch (Exception m) {
            try {
                Method m2 = conv.getClass().getMethod("getDatastoreClass", new Class[0]);
                return (Class)m2.invoke((Object)conv, new Object[0]);
            }
            catch (Exception m2) {
                try {
                    Method[] methods = conv.getClass().getMethods();
                    if (methods != null) {
                        for (int i = 0; i < methods.length; ++i) {
                            Class<?>[] paramTypes = methods[i].getParameterTypes();
                            if (!methods[i].getName().equals("toDatastoreType") || methods[i].getReturnType() == Object.class || paramTypes == null || paramTypes.length != 1) continue;
                            return methods[i].getReturnType();
                        }
                    }
                }
                catch (Exception e3) {
                    NucleusLogger.GENERAL.warn("Converter " + conv + " didn't have adequate information from toDatastoreType nor from getDatastoreClass");
                }
                return null;
            }
        }
    }
}

