/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.handlers;

import java.io.IOException;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.sling.feature.cpconverter.ContentPackage2FeatureModelConverter;
import org.apache.sling.feature.cpconverter.handlers.EntryHandler;
import org.apache.sling.feature.cpconverter.vltpkg.VaultPackageAssembler;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHandler
implements EntryHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultHandler.class);
    private static final String INSTALL_HOOK_ROOT = "/META-INF/vault/hooks";
    private final VaultPackageAssembler mainPackageAssembler;
    private final boolean removeInstallHooks;

    public DefaultHandler(@NotNull VaultPackageAssembler mainPackageAssembler, boolean removeInstallHooks) {
        this.mainPackageAssembler = mainPackageAssembler;
        this.removeInstallHooks = removeInstallHooks;
    }

    @Override
    public boolean matches(@NotNull String path) {
        return true;
    }

    @Override
    public void handle(@NotNull String path, @NotNull Archive archive, @NotNull Archive.Entry entry, @NotNull ContentPackage2FeatureModelConverter converter, String runMode) throws IOException {
        if (this.removeInstallHooks && path.startsWith(INSTALL_HOOK_ROOT)) {
            log.info("Skipping install hook {} from original package", (Object)path);
        } else {
            this.mainPackageAssembler.addEntry(path, archive, entry);
        }
    }
}

