/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.repoinit;

import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sling.feature.cpconverter.accesscontrol.EnforceInfo;
import org.apache.sling.feature.cpconverter.repoinit.ConversionMap;
import org.apache.sling.feature.cpconverter.repoinit.NoOpVisitor;
import org.apache.sling.repoinit.parser.operations.AclLine;
import org.apache.sling.repoinit.parser.operations.SetAclPaths;
import org.apache.sling.repoinit.parser.operations.SetAclPrincipals;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AccessControlVisitor
extends NoOpVisitor {
    private final Formatter formatter;
    private final EnforceInfo enforceInfo;
    private final ConversionMap toConvert;

    AccessControlVisitor(@NotNull Formatter formatter, @NotNull EnforceInfo enforceInfo, @NotNull ConversionMap toConvert) {
        this.formatter = formatter;
        this.enforceInfo = enforceInfo;
        this.toConvert = toConvert;
    }

    @Override
    public void visitSetAclPrincipal(SetAclPrincipals setAclPrincipals) {
        Map<List<AclLine>, List<String>> notConverted = this.convertLines(setAclPrincipals);
        if (!notConverted.isEmpty()) {
            for (Map.Entry<List<AclLine>, List<String>> entry : notConverted.entrySet()) {
                List<AclLine> lines = entry.getKey();
                List<String> principalNames = entry.getValue();
                SetAclPrincipals operation = new SetAclPrincipals(principalNames, lines, setAclPrincipals.getOptions());
                this.formatter.format("%s", operation.asRepoInitString());
            }
        }
    }

    @NotNull
    private Map<List<AclLine>, List<String>> convertLines(@NotNull SetAclPrincipals setAclPrincipals) {
        HashMap<List<AclLine>, List<String>> notConverted = new HashMap<List<AclLine>, List<String>>();
        ArrayList allLines = new ArrayList(setAclPrincipals.getLines());
        ArrayList<AclLine> removeLines = new ArrayList<AclLine>(allLines);
        removeLines.removeIf(line -> !AccessControlVisitor.isRemoveAction(line));
        ArrayList<AclLine> lines = new ArrayList<AclLine>(allLines);
        lines.removeAll(removeLines);
        if (!lines.isEmpty()) {
            for (String principalName : setAclPrincipals.getPrincipals()) {
                List principalNames;
                if (this.enforcePrincipalBased(principalName)) {
                    this.toConvert.putAll(principalName, setAclPrincipals.getOptions(), lines);
                    if (removeLines.isEmpty()) continue;
                    principalNames = notConverted.computeIfAbsent(removeLines, k -> new ArrayList());
                    principalNames.add(principalName);
                    continue;
                }
                principalNames = notConverted.computeIfAbsent(allLines, k -> new ArrayList());
                principalNames.add(principalName);
            }
        } else {
            notConverted.put(allLines, setAclPrincipals.getPrincipals());
        }
        return notConverted;
    }

    @Override
    public void visitSetAclPaths(SetAclPaths setAclPaths) {
        ArrayList<AclLine> lines = new ArrayList<AclLine>();
        for (AclLine line : setAclPaths.getLines()) {
            ArrayList<String> principalNames = new ArrayList<String>(line.getProperty("principals"));
            if (!AccessControlVisitor.isRemoveAction(line)) {
                for (String principalName : line.getProperty("principals")) {
                    if (!this.enforcePrincipalBased(principalName)) continue;
                    AclLine newLine = AccessControlVisitor.createAclLine(line, null, setAclPaths.getPaths());
                    this.toConvert.put(principalName, setAclPaths.getOptions(), newLine);
                    principalNames.remove(principalName);
                }
            }
            if (principalNames.equals(line.getProperty("principals"))) {
                lines.add(line);
                continue;
            }
            if (principalNames.isEmpty()) continue;
            AclLine modified = AccessControlVisitor.createAclLine(line, principalNames, null);
            lines.add(modified);
        }
        if (!lines.isEmpty()) {
            SetAclPaths operation = new SetAclPaths(setAclPaths.getPaths(), lines, setAclPaths.getOptions());
            this.formatter.format("%s", operation.asRepoInitString());
        }
    }

    private boolean enforcePrincipalBased(@NotNull String principalName) {
        return this.enforceInfo.enforcePrincipalBased(principalName);
    }

    @NotNull
    private static AclLine createAclLine(@NotNull AclLine base, @Nullable List<String> principalNames, @Nullable List<String> paths) {
        AclLine al = new AclLine(base.getAction());
        if (principalNames != null) {
            al.setProperty("principals", principalNames);
        }
        if (paths != null && !paths.isEmpty()) {
            al.setProperty("paths", paths);
        }
        al.setProperty("privileges", base.getProperty("privileges"));
        al.setProperty("nodetypes", base.getProperty("nodetypes"));
        al.setRestrictions(base.getRestrictions());
        return al;
    }

    private static boolean isRemoveAction(@NotNull AclLine line) {
        AclLine.Action action = line.getAction();
        return action == AclLine.Action.REMOVE_ALL || action == AclLine.Action.REMOVE;
    }
}

