/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.media.format.impl;

import com.google.common.collect.ImmutableSortedSet;
import io.wcm.handler.media.MediaFileType;
import io.wcm.handler.media.format.MediaFormat;
import io.wcm.handler.media.format.MediaFormatHandler;
import io.wcm.handler.media.format.MediaFormatProviderManager;
import io.wcm.handler.media.format.MediaFormatRankingComparator;
import io.wcm.handler.media.format.MediaFormatSizeRankingComparator;
import io.wcm.handler.media.format.Ratio;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Model(adaptables={SlingHttpServletRequest.class, Resource.class}, adapters={MediaFormatHandler.class})
public final class MediaFormatHandlerImpl
implements MediaFormatHandler {
    @SlingObject
    private Resource currentResource;
    @OSGiService
    private MediaFormatProviderManager mediaFormatProviderManager;
    private SortedSet<MediaFormat> mediaFormats;
    private Map<String, MediaFormat> mediaFormatMap;

    private SortedSet<MediaFormat> getMediaFormatsForCurrentResource() {
        if (this.mediaFormats == null) {
            this.mediaFormats = this.mediaFormatProviderManager.getMediaFormats(this.currentResource);
        }
        return this.mediaFormats;
    }

    private Map<String, MediaFormat> getMediaFormatMap() {
        if (this.mediaFormatMap == null) {
            this.mediaFormatMap = new HashMap<String, MediaFormat>();
            for (MediaFormat mediaFormat : this.getMediaFormatsForCurrentResource()) {
                this.mediaFormatMap.put(mediaFormat.getName(), mediaFormat);
            }
        }
        return this.mediaFormatMap;
    }

    @Override
    public MediaFormat getMediaFormat(@NotNull String mediaFormatName) {
        return this.getMediaFormatMap().get(mediaFormatName);
    }

    @Override
    @NotNull
    public SortedSet<MediaFormat> getMediaFormats() {
        return this.getMediaFormatsForCurrentResource();
    }

    @Override
    @NotNull
    public SortedSet<MediaFormat> getMediaFormats(@NotNull Comparator<MediaFormat> comparator) {
        TreeSet<MediaFormat> set = new TreeSet<MediaFormat>(comparator);
        set.addAll(this.getMediaFormatsForCurrentResource());
        return ImmutableSortedSet.copyOf(set);
    }

    @Override
    @NotNull
    public SortedSet<MediaFormat> getSameBiggerMediaFormats(@NotNull MediaFormat mediaFormatRequested, boolean filterRenditionGroup) {
        TreeSet<MediaFormat> matchingFormats = new TreeSet<MediaFormat>(new MediaFormatSizeRankingComparator());
        if (filterRenditionGroup && StringUtils.isEmpty((CharSequence)mediaFormatRequested.getRenditionGroup())) {
            matchingFormats.add(mediaFormatRequested);
        } else {
            for (MediaFormat mediaFormat : this.getMediaFormats()) {
                if (filterRenditionGroup && !StringUtils.equals((CharSequence)mediaFormat.getRenditionGroup(), (CharSequence)mediaFormatRequested.getRenditionGroup()) || !this.isRenditionMatchSizeSameBigger(mediaFormat, mediaFormatRequested) || !Ratio.matches(mediaFormat, mediaFormatRequested) && mediaFormat.hasRatio() && mediaFormatRequested.hasRatio() || !this.isRenditionMatchExtension(mediaFormat)) continue;
                matchingFormats.add(mediaFormat);
            }
        }
        return matchingFormats;
    }

    @Override
    @NotNull
    public SortedSet<MediaFormat> getSameSmallerMediaFormats(@NotNull MediaFormat mediaFormatRequested, boolean filterRenditionGroup) {
        TreeSet<MediaFormat> matchingFormats = new TreeSet<MediaFormat>(new MediaFormatSizeRankingComparator());
        if (filterRenditionGroup && StringUtils.isEmpty((CharSequence)mediaFormatRequested.getRenditionGroup())) {
            matchingFormats.add(mediaFormatRequested);
        } else {
            for (MediaFormat mediaFormat : this.getMediaFormats()) {
                if (filterRenditionGroup && !StringUtils.equals((CharSequence)mediaFormat.getRenditionGroup(), (CharSequence)mediaFormatRequested.getRenditionGroup()) || !this.isRenditionMatchSizeSameSmaller(mediaFormat, mediaFormatRequested) || !Ratio.matches(mediaFormat, mediaFormatRequested) && mediaFormat.hasRatio() && mediaFormatRequested.hasRatio() || !this.isRenditionMatchExtension(mediaFormat)) continue;
                matchingFormats.add(mediaFormat);
            }
        }
        return matchingFormats;
    }

    private boolean isRenditionMatchSizeSameBigger(MediaFormat mediaFormat, MediaFormat mediaFormatRequested) {
        long widthRequested = mediaFormatRequested.getEffectiveMinWidth();
        long heightRequested = mediaFormatRequested.getEffectiveMinHeight();
        long widthMax = mediaFormat.getEffectiveMaxWidth();
        long heightMax = mediaFormat.getEffectiveMaxHeight();
        return !(widthMax < widthRequested && widthMax != 0L || heightMax < heightRequested && heightMax != 0L);
    }

    private boolean isRenditionMatchSizeSameSmaller(MediaFormat mediaFormat, MediaFormat mediaFormatRequested) {
        long widthRequested = mediaFormatRequested.getEffectiveMinWidth();
        long heightRequested = mediaFormatRequested.getEffectiveMinHeight();
        long widthMin = mediaFormat.getEffectiveMinWidth();
        long heightMin = mediaFormat.getEffectiveMinHeight();
        return widthMin <= widthRequested && heightMin <= heightRequested;
    }

    private boolean isRenditionMatchExtension(MediaFormat mediaFormat) {
        for (String extension : mediaFormat.getExtensions()) {
            if (!MediaFileType.isImage(extension)) continue;
            return true;
        }
        return false;
    }

    @Override
    public MediaFormat detectMediaFormat(@Nullable String extension, long fileSize, long width, long height) {
        SortedSet<MediaFormat> matchingFormats = this.detectMediaFormats(extension, fileSize, width, height);
        return !matchingFormats.isEmpty() ? matchingFormats.first() : null;
    }

    @Override
    @NotNull
    public SortedSet<MediaFormat> detectMediaFormats(@Nullable String extension, long fileSize, long width, long height) {
        TreeSet<MediaFormat> matchingFormats = new TreeSet<MediaFormat>(new MediaFormatRankingComparator());
        for (MediaFormat mediaFormat : this.getMediaFormats()) {
            if (mediaFormat.getRanking() < 0L) continue;
            boolean extensionMatch = false;
            if (mediaFormat.getExtensions() != null) {
                for (String ext : mediaFormat.getExtensions()) {
                    if (!StringUtils.equalsIgnoreCase((CharSequence)ext, (CharSequence)extension)) continue;
                    extensionMatch = true;
                    break;
                }
            } else {
                extensionMatch = true;
            }
            boolean fileSizeMatch = false;
            fileSizeMatch = mediaFormat.getFileSizeMax() > 0L ? fileSize <= mediaFormat.getFileSizeMax() : true;
            boolean dimensionMatch = false;
            dimensionMatch = width > 0L && height > 0L ? !(mediaFormat.getEffectiveMinWidth() != 0L && width < mediaFormat.getEffectiveMinWidth() || mediaFormat.getEffectiveMaxWidth() != 0L && width > mediaFormat.getEffectiveMaxWidth() || mediaFormat.getEffectiveMinHeight() != 0L && height < mediaFormat.getEffectiveMinHeight() || mediaFormat.getEffectiveMaxHeight() != 0L && height > mediaFormat.getEffectiveMaxHeight()) : true;
            boolean ratioMatch = false;
            if (mediaFormat.hasRatio() && width > 0L && height > 0L) {
                double formatRatio = mediaFormat.getRatio();
                double ratio = (double)width / (double)height;
                ratioMatch = Ratio.matches(ratio, formatRatio);
            } else {
                ratioMatch = true;
            }
            if (!extensionMatch || !fileSizeMatch || !dimensionMatch || !ratioMatch) continue;
            matchingFormats.add(mediaFormat);
        }
        return matchingFormats;
    }
}

