/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.peaberry.osgi;

import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scope;
import java.util.Collections;
import java.util.Dictionary;
import org.ops4j.peaberry.ServiceException;
import org.ops4j.peaberry.internal.InvalidSyntaxException;
import org.ops4j.peaberry.osgi.AttributeDictionary;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BundleScopeImpl
implements Scope {
    private static final String BUNDLE_ID = "bundle.id";
    final Provider<BundleContext> contextProvider;

    BundleScopeImpl(Provider<BundleContext> contextProvider) {
        this.contextProvider = contextProvider;
    }

    public <T> Provider<T> scope(Key<T> key, final Provider<T> creator) {
        final String clazzName = key.getTypeLiteral().getRawType().getName();
        return new Provider<T>(){
            private volatile T instance;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public T get() {
                if (null == this.instance) {
                    BundleContext bundleContext;
                    BundleContext bundleContext2 = bundleContext = (BundleContext)BundleScopeImpl.this.contextProvider.get();
                    synchronized (bundleContext2) {
                        if (null == this.instance) {
                            ServiceReference[] refs;
                            long bundleId = bundleContext.getBundle().getBundleId();
                            String filter = "(bundle.id=" + bundleId + ')';
                            try {
                                refs = bundleContext.getServiceReferences(clazzName, filter);
                            }
                            catch (InvalidSyntaxException e) {
                                throw new ServiceException(e);
                            }
                            if (null != refs && refs.length > 0) {
                                this.instance = bundleContext.getService(refs[0]);
                            } else {
                                this.instance = creator.get();
                                bundleContext.registerService(clazzName, this.instance, (Dictionary)new AttributeDictionary(Collections.singletonMap(BundleScopeImpl.BUNDLE_ID, bundleId)));
                            }
                        }
                    }
                }
                return this.instance;
            }

            public String toString() {
                return String.format("%s[BundleScope [%s]]", creator, ((BundleContext)BundleScopeImpl.this.contextProvider.get()).getBundle());
            }
        };
    }

    public String toString() {
        return "BundleScope";
    }
}

