/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.peaberry.internal;

import java.util.Iterator;
import java.util.Map;
import org.ops4j.peaberry.Export;
import org.ops4j.peaberry.Import;
import org.ops4j.peaberry.ServiceWatcher;
import org.ops4j.peaberry.util.SimpleExport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ConcurrentServiceWatcher<S>
implements ServiceWatcher<S> {
    final Iterable<Import<S>> services;
    final ServiceWatcher<? super S> watcher;
    Import<S> currentImport;
    Export<S> currentExport;

    ConcurrentServiceWatcher(Iterable<Import<S>> services, ServiceWatcher<? super S> watcher) {
        this.services = services;
        this.watcher = watcher;
    }

    @Override
    public synchronized <T extends S> Export<T> add(Import<T> service) {
        this.updateBestService();
        return new TrackingExport<T>(service);
    }

    void updateBestService() {
        Import<S> bestImport;
        Iterator<Import<S>> i = this.services.iterator();
        Import<S> import_ = bestImport = i.hasNext() ? i.next() : null;
        if (null != this.currentImport && this.currentImport.equals(bestImport)) {
            return;
        }
        if (null != this.currentExport) {
            this.currentExport.unput();
        }
        this.currentImport = bestImport;
        this.currentExport = null == bestImport ? null : this.watcher.add(bestImport);
    }

    public boolean equals(Object rhs) {
        if (rhs instanceof ConcurrentServiceWatcher) {
            ConcurrentServiceWatcher concurrentWatcher = (ConcurrentServiceWatcher)rhs;
            return this.services.equals(concurrentWatcher.services) && this.watcher.equals(concurrentWatcher.watcher);
        }
        return false;
    }

    public int hashCode() {
        return this.services.hashCode() ^ this.watcher.hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class TrackingExport<T>
    extends SimpleExport<T> {
        private final Import<T> thisImport;

        TrackingExport(Import<T> thisImport) {
            super(thisImport);
            this.thisImport = thisImport;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void put(T newInstance) {
            super.put(newInstance);
            ConcurrentServiceWatcher concurrentServiceWatcher = ConcurrentServiceWatcher.this;
            synchronized (concurrentServiceWatcher) {
                if (null != ConcurrentServiceWatcher.this.currentExport && this.thisImport.equals(ConcurrentServiceWatcher.this.currentImport)) {
                    ConcurrentServiceWatcher.this.currentExport.put(newInstance);
                    if (null == newInstance) {
                        ConcurrentServiceWatcher.this.updateBestService();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void attributes(Map<String, ?> newAttributes) {
            super.attributes(newAttributes);
            ConcurrentServiceWatcher concurrentServiceWatcher = ConcurrentServiceWatcher.this;
            synchronized (concurrentServiceWatcher) {
                if (null != ConcurrentServiceWatcher.this.currentExport && this.thisImport.equals(ConcurrentServiceWatcher.this.currentImport)) {
                    ConcurrentServiceWatcher.this.currentExport.attributes(newAttributes);
                }
                ConcurrentServiceWatcher.this.updateBestService();
            }
        }
    }
}

