/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.file;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import io.netty.handler.codec.DateFormatter;
import java.util.Date;

public final class HttpFileAttributes {
    private final long length;
    private final long lastModifiedMillis;

    public HttpFileAttributes(long length, long lastModifiedMillis) {
        Preconditions.checkArgument(length >= 0L, "length: %s (expected: >= 0)", length);
        this.length = length;
        this.lastModifiedMillis = lastModifiedMillis;
    }

    public long length() {
        return this.length;
    }

    public long lastModifiedMillis() {
        return this.lastModifiedMillis;
    }

    public int hashCode() {
        return (int)(this.length * 31L + this.lastModifiedMillis);
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null || obj.getClass() != HttpFileAttributes.class) {
            return false;
        }
        HttpFileAttributes that = (HttpFileAttributes)obj;
        return this.length == that.length && this.lastModifiedMillis == that.lastModifiedMillis;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("length", this.length).add("lastModified", DateFormatter.format(new Date(this.lastModifiedMillis))).toString();
    }
}

