/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.query.enumeration.Order;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.input.RecordCondition;
import org.apache.skywalking.oap.server.core.query.type.Record;
import org.apache.skywalking.oap.server.core.storage.query.IRecordsQueryDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCClient;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.SQLAndParameters;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.TableHelper;

public class JDBCRecordsQueryDAO
implements IRecordsQueryDAO {
    private final JDBCClient jdbcClient;
    private final TableHelper tableHelper;

    public List<Record> readRecords(RecordCondition condition, String valueColumnName, Duration duration) {
        List<String> tables = this.tableHelper.getTablesForRead(condition.getName(), duration.getStartTimeBucket(), duration.getEndTimeBucket());
        ArrayList<Record> results = new ArrayList<Record>();
        for (String table : tables) {
            SQLAndParameters sqlAndParameters = JDBCRecordsQueryDAO.buildSQL(condition, valueColumnName, duration, table);
            this.jdbcClient.executeQuery(sqlAndParameters.sql(), resultSet -> {
                while (resultSet.next()) {
                    Record record = new Record();
                    record.setName(resultSet.getString("statement"));
                    String refId = resultSet.getString("trace_id");
                    record.setRefId(StringUtil.isEmpty((String)refId) ? "" : refId);
                    record.setId(record.getRefId());
                    record.setValue(String.valueOf(resultSet.getInt(valueColumnName)));
                    results.add(record);
                }
                return null;
            }, sqlAndParameters.parameters());
        }
        return results;
    }

    protected static SQLAndParameters buildSQL(RecordCondition condition, String valueColumnName, Duration duration, String table) {
        StringBuilder sql = new StringBuilder("select * from " + table + " where ");
        ArrayList<Object> parameters = new ArrayList<Object>(10);
        sql.append("table_name").append(" = ?");
        parameters.add(condition.getName());
        sql.append(" and ").append("entity_id").append(" = ? and");
        parameters.add(condition.getParentEntity().buildId());
        sql.append(" ").append("time_bucket").append(" >= ?");
        parameters.add(duration.getStartTimeBucketInSec());
        sql.append(" and ").append("time_bucket").append(" <= ?");
        parameters.add(duration.getEndTimeBucketInSec());
        sql.append(" order by ").append(valueColumnName);
        if (condition.getOrder().equals((Object)Order.DES)) {
            sql.append(" desc ");
        } else {
            sql.append(" asc ");
        }
        sql.append(" limit ").append(condition.getTopN());
        return new SQLAndParameters(sql.toString(), parameters);
    }

    @Generated
    public JDBCRecordsQueryDAO(JDBCClient jdbcClient, TableHelper tableHelper) {
        this.jdbcClient = jdbcClient;
        this.tableHelper = tableHelper;
    }
}

