/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis;

import java.lang.annotation.Annotation;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.meter.function.MeterFunction;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.MetricsFunction;

public enum FunctionCategory {
    METER("meter", MeterFunction.class),
    METRICS("metrics", MetricsFunction.class);

    private final String name;
    private final Class<? extends Annotation> annotationClass;

    public static String uniqueFunctionName(Class<?> aClass) {
        Annotation annotation = FunctionCategory.doGetAnnotation(aClass, MeterFunction.class);
        if (annotation != null) {
            return (METER.getName() + "-" + ((MeterFunction)annotation).functionName()).toLowerCase();
        }
        annotation = FunctionCategory.doGetAnnotation(aClass, MetricsFunction.class);
        if (annotation != null) {
            return (METRICS.getName() + "-" + ((MetricsFunction)annotation).functionName()).toLowerCase();
        }
        return "";
    }

    private static Annotation doGetAnnotation(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        Annotation[] annotations;
        if (clazz.equals(Object.class)) {
            return null;
        }
        for (Annotation annotation : annotations = clazz.getAnnotations()) {
            if (!annotation.annotationType().equals(annotationClass)) continue;
            return annotation;
        }
        return FunctionCategory.doGetAnnotation(clazz.getSuperclass(), annotationClass);
    }

    @Generated
    private FunctionCategory(String name, Class<? extends Annotation> annotationClass) {
        this.name = name;
        this.annotationClass = annotationClass;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Class<? extends Annotation> getAnnotationClass() {
        return this.annotationClass;
    }
}

