/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.grpc.protocol;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.grpc.protocol.ArmeriaMessageDeframer;
import com.linecorp.armeria.common.grpc.protocol.ArmeriaStatusException;
import com.linecorp.armeria.common.grpc.protocol.Decompressor;
import com.linecorp.armeria.common.grpc.protocol.DeframedMessage;
import com.linecorp.armeria.common.stream.StreamDecoderInput;
import com.linecorp.armeria.internal.shaded.guava.annotations.VisibleForTesting;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class AbstractMessageDeframer {
    public static final int NO_MAX_INBOUND_MESSAGE_SIZE = -1;
    private static final String DEBUG_STRING = ArmeriaMessageDeframer.class.getName();
    private static final int HEADER_LENGTH = 5;
    private static final int COMPRESSED_FLAG_MASK = 1;
    private static final int RESERVED_MASK = 126;
    static final int UNINITIALIZED_TYPE = -1;
    private final int maxMessageLength;
    private int currentType = -1;
    private int requiredLength = 5;
    @Nullable
    private Decompressor decompressor;

    protected AbstractMessageDeframer(int maxMessageLength) {
        this.maxMessageLength = maxMessageLength > 0 ? maxMessageLength : Integer.MAX_VALUE;
    }

    final int requiredLength() {
        return this.requiredLength;
    }

    boolean isUninitializedType() {
        return this.currentType == -1;
    }

    protected final void readHeader(StreamDecoderInput in) {
        short type = in.readUnsignedByte();
        if ((type & 0x7E) != 0) {
            throw new ArmeriaStatusException(13, DEBUG_STRING + ": Frame header malformed: reserved bits not zero");
        }
        this.requiredLength = in.readInt();
        if (this.requiredLength < 0 || this.requiredLength > this.maxMessageLength) {
            throw new ArmeriaStatusException(8, String.format("%s: Frame size %d exceeds maximum: %d. ", DEBUG_STRING, this.requiredLength, this.maxMessageLength));
        }
        this.currentType = type;
    }

    protected final DeframedMessage readBody(StreamDecoderInput in) {
        ByteBuf buf = this.requiredLength == 0 ? Unpooled.EMPTY_BUFFER : in.readBytes(this.requiredLength);
        boolean isCompressed = (this.currentType & 1) != 0;
        DeframedMessage msg = isCompressed ? this.getCompressedBody(buf) : this.getUncompressedBody(buf);
        this.currentType = -1;
        this.requiredLength = 5;
        return msg;
    }

    private DeframedMessage getUncompressedBody(ByteBuf buf) {
        return new DeframedMessage(buf, this.currentType);
    }

    private DeframedMessage getCompressedBody(ByteBuf buf) {
        if (this.decompressor == null) {
            buf.release();
            throw new ArmeriaStatusException(13, DEBUG_STRING + ": Can't decode compressed frame as compression not configured.");
        }
        try {
            InputStream unlimitedStream = this.decompressor.decompress((InputStream)new ByteBufInputStream(buf, true));
            return new DeframedMessage(new SizeEnforcingInputStream(unlimitedStream, this.maxMessageLength, DEBUG_STRING), this.currentType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected AbstractMessageDeframer decompressor(@Nullable Decompressor decompressor) {
        this.decompressor = decompressor;
        return this;
    }

    @VisibleForTesting
    static final class SizeEnforcingInputStream
    extends FilterInputStream {
        private final int maxMessageSize;
        private final String debugString;
        private long maxCount;
        private long count;
        private long mark = -1L;

        SizeEnforcingInputStream(InputStream in, int maxMessageSize, String debugString) {
            super(in);
            this.maxMessageSize = maxMessageSize;
            this.debugString = debugString;
        }

        @Override
        public int read() throws IOException {
            int result = this.in.read();
            if (result != -1) {
                ++this.count;
            }
            this.verifySize();
            this.reportCount();
            return result;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int result = this.in.read(b, off, len);
            if (result != -1) {
                this.count += (long)result;
            }
            this.verifySize();
            this.reportCount();
            return result;
        }

        @Override
        public long skip(long n) throws IOException {
            long result = this.in.skip(n);
            this.count += result;
            this.verifySize();
            this.reportCount();
            return result;
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.in.mark(readlimit);
            this.mark = this.count;
        }

        @Override
        public synchronized void reset() throws IOException {
            if (!this.in.markSupported()) {
                throw new IOException("Mark not supported");
            }
            if (this.mark == -1L) {
                throw new IOException("Mark not set");
            }
            this.in.reset();
            this.count = this.mark;
        }

        private void reportCount() {
            if (this.count > this.maxCount) {
                this.maxCount = this.count;
            }
        }

        private void verifySize() {
            if (this.count > (long)this.maxMessageSize) {
                throw new ArmeriaStatusException(8, String.format("%s: Compressed frame exceeds maximum frame size: %d. Bytes read: %d. ", this.debugString, this.maxMessageSize, this.count));
            }
        }
    }
}

