/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.validation;

import graphql.Internal;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLTypeVisitorStub;
import graphql.schema.validation.SchemaValidationError;
import graphql.schema.validation.SchemaValidationErrorCollector;
import graphql.schema.validation.SchemaValidationErrorType;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

@Internal
public class NoUnbrokenInputCycles
extends GraphQLTypeVisitorStub {
    @Override
    public TraversalControl visitGraphQLFieldDefinition(GraphQLFieldDefinition fieldDef, TraverserContext<GraphQLSchemaElement> context) {
        SchemaValidationErrorCollector validationErrorCollector = context.getVarFromParents(SchemaValidationErrorCollector.class);
        for (GraphQLArgument argument : fieldDef.getArguments()) {
            GraphQLInputType argumentType = argument.getType();
            if (!(argumentType instanceof GraphQLInputObjectType)) continue;
            ArrayList<String> path = new ArrayList<String>();
            this.check((GraphQLInputObjectType)argumentType, new LinkedHashSet<GraphQLType>(), path, validationErrorCollector);
        }
        return TraversalControl.CONTINUE;
    }

    private void check(GraphQLInputObjectType type, Set<GraphQLType> seen, List<String> path, SchemaValidationErrorCollector validationErrorCollector) {
        if (seen.contains(type)) {
            validationErrorCollector.addError(new SchemaValidationError(SchemaValidationErrorType.UnbrokenInputCycle, this.getErrorMessage(path)));
            return;
        }
        seen.add(type);
        for (GraphQLInputObjectField field : type.getFieldDefinitions()) {
            GraphQLType unwrapped;
            if (!GraphQLTypeUtil.isNonNull(field.getType()) || !((unwrapped = this.unwrapNonNull((GraphQLNonNull)field.getType())) instanceof GraphQLInputObjectType)) continue;
            path = new ArrayList<String>(path);
            path.add(field.getName() + "!");
            this.check((GraphQLInputObjectType)unwrapped, new LinkedHashSet<GraphQLType>(seen), path, validationErrorCollector);
        }
    }

    private GraphQLType unwrapNonNull(GraphQLNonNull type) {
        if (GraphQLTypeUtil.isList(type.getWrappedType())) {
            GraphQLList listType = (GraphQLList)type.getWrappedType();
            if (GraphQLTypeUtil.isNonNull(listType.getWrappedType())) {
                return GraphQLTypeUtil.unwrapAll(listType.getWrappedType());
            }
            return type.getWrappedType();
        }
        return GraphQLTypeUtil.unwrapAll(type.getWrappedType());
    }

    private String getErrorMessage(List<String> path) {
        StringBuilder message = new StringBuilder();
        message.append("[");
        for (int i = 0; i < path.size(); ++i) {
            if (i != 0) {
                message.append(".");
            }
            message.append(path.get(i));
        }
        message.append("] forms an unsatisfiable cycle");
        return message.toString();
    }
}

