/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.batch.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluentImpl;
import io.fabric8.kubernetes.api.model.batch.v1.JobSpec;
import io.fabric8.kubernetes.api.model.batch.v1.JobSpecFluent;
import io.fabric8.kubernetes.api.model.batch.v1.PodFailurePolicy;
import io.fabric8.kubernetes.api.model.batch.v1.PodFailurePolicyBuilder;
import io.fabric8.kubernetes.api.model.batch.v1.PodFailurePolicyFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class JobSpecFluentImpl<A extends JobSpecFluent<A>>
extends BaseFluent<A>
implements JobSpecFluent<A> {
    private Long activeDeadlineSeconds;
    private Integer backoffLimit;
    private String completionMode;
    private Integer completions;
    private Boolean manualSelector;
    private Integer parallelism;
    private PodFailurePolicyBuilder podFailurePolicy;
    private LabelSelectorBuilder selector;
    private Boolean suspend;
    private PodTemplateSpecBuilder template;
    private Integer ttlSecondsAfterFinished;
    private Map<String, Object> additionalProperties;

    public JobSpecFluentImpl() {
    }

    public JobSpecFluentImpl(JobSpec instance) {
        if (instance != null) {
            this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds());
            this.withBackoffLimit(instance.getBackoffLimit());
            this.withCompletionMode(instance.getCompletionMode());
            this.withCompletions(instance.getCompletions());
            this.withManualSelector(instance.getManualSelector());
            this.withParallelism(instance.getParallelism());
            this.withPodFailurePolicy(instance.getPodFailurePolicy());
            this.withSelector(instance.getSelector());
            this.withSuspend(instance.getSuspend());
            this.withTemplate(instance.getTemplate());
            this.withTtlSecondsAfterFinished(instance.getTtlSecondsAfterFinished());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public Long getActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds;
    }

    @Override
    public A withActiveDeadlineSeconds(Long activeDeadlineSeconds) {
        this.activeDeadlineSeconds = activeDeadlineSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds != null;
    }

    @Override
    public Integer getBackoffLimit() {
        return this.backoffLimit;
    }

    @Override
    public A withBackoffLimit(Integer backoffLimit) {
        this.backoffLimit = backoffLimit;
        return (A)this;
    }

    @Override
    public Boolean hasBackoffLimit() {
        return this.backoffLimit != null;
    }

    @Override
    public String getCompletionMode() {
        return this.completionMode;
    }

    @Override
    public A withCompletionMode(String completionMode) {
        this.completionMode = completionMode;
        return (A)this;
    }

    @Override
    public Boolean hasCompletionMode() {
        return this.completionMode != null;
    }

    @Override
    public Integer getCompletions() {
        return this.completions;
    }

    @Override
    public A withCompletions(Integer completions) {
        this.completions = completions;
        return (A)this;
    }

    @Override
    public Boolean hasCompletions() {
        return this.completions != null;
    }

    @Override
    public Boolean getManualSelector() {
        return this.manualSelector;
    }

    @Override
    public A withManualSelector(Boolean manualSelector) {
        this.manualSelector = manualSelector;
        return (A)this;
    }

    @Override
    public Boolean hasManualSelector() {
        return this.manualSelector != null;
    }

    @Override
    public Integer getParallelism() {
        return this.parallelism;
    }

    @Override
    public A withParallelism(Integer parallelism) {
        this.parallelism = parallelism;
        return (A)this;
    }

    @Override
    public Boolean hasParallelism() {
        return this.parallelism != null;
    }

    @Override
    @Deprecated
    public PodFailurePolicy getPodFailurePolicy() {
        return this.podFailurePolicy != null ? this.podFailurePolicy.build() : null;
    }

    @Override
    public PodFailurePolicy buildPodFailurePolicy() {
        return this.podFailurePolicy != null ? this.podFailurePolicy.build() : null;
    }

    @Override
    public A withPodFailurePolicy(PodFailurePolicy podFailurePolicy) {
        this._visitables.get((Object)"podFailurePolicy").remove(this.podFailurePolicy);
        if (podFailurePolicy != null) {
            this.podFailurePolicy = new PodFailurePolicyBuilder(podFailurePolicy);
            this._visitables.get((Object)"podFailurePolicy").add(this.podFailurePolicy);
        } else {
            this.podFailurePolicy = null;
            this._visitables.get((Object)"podFailurePolicy").remove(this.podFailurePolicy);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPodFailurePolicy() {
        return this.podFailurePolicy != null;
    }

    @Override
    public JobSpecFluent.PodFailurePolicyNested<A> withNewPodFailurePolicy() {
        return new PodFailurePolicyNestedImpl();
    }

    @Override
    public JobSpecFluent.PodFailurePolicyNested<A> withNewPodFailurePolicyLike(PodFailurePolicy item) {
        return new PodFailurePolicyNestedImpl(item);
    }

    @Override
    public JobSpecFluent.PodFailurePolicyNested<A> editPodFailurePolicy() {
        return this.withNewPodFailurePolicyLike(this.getPodFailurePolicy());
    }

    @Override
    public JobSpecFluent.PodFailurePolicyNested<A> editOrNewPodFailurePolicy() {
        return this.withNewPodFailurePolicyLike(this.getPodFailurePolicy() != null ? this.getPodFailurePolicy() : new PodFailurePolicyBuilder().build());
    }

    @Override
    public JobSpecFluent.PodFailurePolicyNested<A> editOrNewPodFailurePolicyLike(PodFailurePolicy item) {
        return this.withNewPodFailurePolicyLike(this.getPodFailurePolicy() != null ? this.getPodFailurePolicy() : item);
    }

    @Override
    @Deprecated
    public LabelSelector getSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public LabelSelector buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public A withSelector(LabelSelector selector) {
        this._visitables.get((Object)"selector").remove(this.selector);
        if (selector != null) {
            this.selector = new LabelSelectorBuilder(selector);
            this._visitables.get((Object)"selector").add(this.selector);
        } else {
            this.selector = null;
            this._visitables.get((Object)"selector").remove(this.selector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSelector() {
        return this.selector != null;
    }

    @Override
    public JobSpecFluent.SelectorNested<A> withNewSelector() {
        return new SelectorNestedImpl();
    }

    @Override
    public JobSpecFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item) {
        return new SelectorNestedImpl(item);
    }

    @Override
    public JobSpecFluent.SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(this.getSelector());
    }

    @Override
    public JobSpecFluent.SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : new LabelSelectorBuilder().build());
    }

    @Override
    public JobSpecFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : item);
    }

    @Override
    public Boolean getSuspend() {
        return this.suspend;
    }

    @Override
    public A withSuspend(Boolean suspend) {
        this.suspend = suspend;
        return (A)this;
    }

    @Override
    public Boolean hasSuspend() {
        return this.suspend != null;
    }

    @Override
    @Deprecated
    public PodTemplateSpec getTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    @Override
    public PodTemplateSpec buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    @Override
    public A withTemplate(PodTemplateSpec template) {
        this._visitables.get((Object)"template").remove(this.template);
        if (template != null) {
            this.template = new PodTemplateSpecBuilder(template);
            this._visitables.get((Object)"template").add(this.template);
        } else {
            this.template = null;
            this._visitables.get((Object)"template").remove(this.template);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTemplate() {
        return this.template != null;
    }

    @Override
    public JobSpecFluent.TemplateNested<A> withNewTemplate() {
        return new TemplateNestedImpl();
    }

    @Override
    public JobSpecFluent.TemplateNested<A> withNewTemplateLike(PodTemplateSpec item) {
        return new TemplateNestedImpl(item);
    }

    @Override
    public JobSpecFluent.TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(this.getTemplate());
    }

    @Override
    public JobSpecFluent.TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(this.getTemplate() != null ? this.getTemplate() : new PodTemplateSpecBuilder().build());
    }

    @Override
    public JobSpecFluent.TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item) {
        return this.withNewTemplateLike(this.getTemplate() != null ? this.getTemplate() : item);
    }

    @Override
    public Integer getTtlSecondsAfterFinished() {
        return this.ttlSecondsAfterFinished;
    }

    @Override
    public A withTtlSecondsAfterFinished(Integer ttlSecondsAfterFinished) {
        this.ttlSecondsAfterFinished = ttlSecondsAfterFinished;
        return (A)this;
    }

    @Override
    public Boolean hasTtlSecondsAfterFinished() {
        return this.ttlSecondsAfterFinished != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JobSpecFluentImpl that = (JobSpecFluentImpl)o;
        if (!Objects.equals(this.activeDeadlineSeconds, that.activeDeadlineSeconds)) {
            return false;
        }
        if (!Objects.equals(this.backoffLimit, that.backoffLimit)) {
            return false;
        }
        if (!Objects.equals(this.completionMode, that.completionMode)) {
            return false;
        }
        if (!Objects.equals(this.completions, that.completions)) {
            return false;
        }
        if (!Objects.equals(this.manualSelector, that.manualSelector)) {
            return false;
        }
        if (!Objects.equals(this.parallelism, that.parallelism)) {
            return false;
        }
        if (!Objects.equals(this.podFailurePolicy, that.podFailurePolicy)) {
            return false;
        }
        if (!Objects.equals(this.selector, that.selector)) {
            return false;
        }
        if (!Objects.equals(this.suspend, that.suspend)) {
            return false;
        }
        if (!Objects.equals(this.template, that.template)) {
            return false;
        }
        if (!Objects.equals(this.ttlSecondsAfterFinished, that.ttlSecondsAfterFinished)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.activeDeadlineSeconds, this.backoffLimit, this.completionMode, this.completions, this.manualSelector, this.parallelism, this.podFailurePolicy, this.selector, this.suspend, this.template, this.ttlSecondsAfterFinished, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.activeDeadlineSeconds != null) {
            sb.append("activeDeadlineSeconds:");
            sb.append(this.activeDeadlineSeconds + ",");
        }
        if (this.backoffLimit != null) {
            sb.append("backoffLimit:");
            sb.append(this.backoffLimit + ",");
        }
        if (this.completionMode != null) {
            sb.append("completionMode:");
            sb.append(this.completionMode + ",");
        }
        if (this.completions != null) {
            sb.append("completions:");
            sb.append(this.completions + ",");
        }
        if (this.manualSelector != null) {
            sb.append("manualSelector:");
            sb.append(this.manualSelector + ",");
        }
        if (this.parallelism != null) {
            sb.append("parallelism:");
            sb.append(this.parallelism + ",");
        }
        if (this.podFailurePolicy != null) {
            sb.append("podFailurePolicy:");
            sb.append(this.podFailurePolicy + ",");
        }
        if (this.selector != null) {
            sb.append("selector:");
            sb.append(this.selector + ",");
        }
        if (this.suspend != null) {
            sb.append("suspend:");
            sb.append(this.suspend + ",");
        }
        if (this.template != null) {
            sb.append("template:");
            sb.append(this.template + ",");
        }
        if (this.ttlSecondsAfterFinished != null) {
            sb.append("ttlSecondsAfterFinished:");
            sb.append(this.ttlSecondsAfterFinished + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withManualSelector() {
        return this.withManualSelector(true);
    }

    @Override
    public A withSuspend() {
        return this.withSuspend(true);
    }

    class TemplateNestedImpl<N>
    extends PodTemplateSpecFluentImpl<JobSpecFluent.TemplateNested<N>>
    implements JobSpecFluent.TemplateNested<N>,
    Nested<N> {
        PodTemplateSpecBuilder builder;

        TemplateNestedImpl(PodTemplateSpec item) {
            this.builder = new PodTemplateSpecBuilder((PodTemplateSpecFluent)this, item);
        }

        TemplateNestedImpl() {
            this.builder = new PodTemplateSpecBuilder((PodTemplateSpecFluent)this);
        }

        @Override
        public N and() {
            return (N)JobSpecFluentImpl.this.withTemplate(this.builder.build());
        }

        @Override
        public N endTemplate() {
            return this.and();
        }
    }

    class SelectorNestedImpl<N>
    extends LabelSelectorFluentImpl<JobSpecFluent.SelectorNested<N>>
    implements JobSpecFluent.SelectorNested<N>,
    Nested<N> {
        LabelSelectorBuilder builder;

        SelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this, item);
        }

        SelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this);
        }

        @Override
        public N and() {
            return (N)JobSpecFluentImpl.this.withSelector(this.builder.build());
        }

        @Override
        public N endSelector() {
            return this.and();
        }
    }

    class PodFailurePolicyNestedImpl<N>
    extends PodFailurePolicyFluentImpl<JobSpecFluent.PodFailurePolicyNested<N>>
    implements JobSpecFluent.PodFailurePolicyNested<N>,
    Nested<N> {
        PodFailurePolicyBuilder builder;

        PodFailurePolicyNestedImpl(PodFailurePolicy item) {
            this.builder = new PodFailurePolicyBuilder(this, item);
        }

        PodFailurePolicyNestedImpl() {
            this.builder = new PodFailurePolicyBuilder(this);
        }

        @Override
        public N and() {
            return (N)JobSpecFluentImpl.this.withPodFailurePolicy(this.builder.build());
        }

        @Override
        public N endPodFailurePolicy() {
            return this.and();
        }
    }
}

