/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.option;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.orbitz.consul.option.EventOptions;
import com.orbitz.consul.option.ParamAdder;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="EventOptions", generator="Immutables")
@Immutable
public final class ImmutableEventOptions
extends EventOptions {
    private final ImmutableList<String> toQueryParameters;
    private final ImmutableMap<String, String> toHeaders;
    @Nullable
    private final String datacenter;
    @Nullable
    private final String nodeFilter;
    @Nullable
    private final String serviceFilter;
    @Nullable
    private final String tagFilter;

    private ImmutableEventOptions(ImmutableList<String> toQueryParameters, ImmutableMap<String, String> toHeaders, @Nullable String datacenter, @Nullable String nodeFilter, @Nullable String serviceFilter, @Nullable String tagFilter) {
        this.toQueryParameters = toQueryParameters;
        this.toHeaders = toHeaders;
        this.datacenter = datacenter;
        this.nodeFilter = nodeFilter;
        this.serviceFilter = serviceFilter;
        this.tagFilter = tagFilter;
    }

    public ImmutableList<String> toQueryParameters() {
        return this.toQueryParameters;
    }

    public ImmutableMap<String, String> toHeaders() {
        return this.toHeaders;
    }

    @Override
    public Optional<String> getDatacenter() {
        return Optional.ofNullable(this.datacenter);
    }

    @Override
    public Optional<String> getNodeFilter() {
        return Optional.ofNullable(this.nodeFilter);
    }

    @Override
    public Optional<String> getServiceFilter() {
        return Optional.ofNullable(this.serviceFilter);
    }

    @Override
    public Optional<String> getTagFilter() {
        return Optional.ofNullable(this.tagFilter);
    }

    public final ImmutableEventOptions withToQueryParameters(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableEventOptions((ImmutableList<String>)newValue, this.toHeaders, this.datacenter, this.nodeFilter, this.serviceFilter, this.tagFilter);
    }

    public final ImmutableEventOptions withToQueryParameters(Iterable<String> elements) {
        if (this.toQueryParameters == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableEventOptions((ImmutableList<String>)newValue, this.toHeaders, this.datacenter, this.nodeFilter, this.serviceFilter, this.tagFilter);
    }

    public final ImmutableEventOptions withToHeaders(Map<String, ? extends String> entries) {
        if (this.toHeaders == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableEventOptions(this.toQueryParameters, (ImmutableMap<String, String>)newValue, this.datacenter, this.nodeFilter, this.serviceFilter, this.tagFilter);
    }

    public final ImmutableEventOptions withDatacenter(String value) {
        String newValue = Objects.requireNonNull(value, "datacenter");
        if (Objects.equals(this.datacenter, newValue)) {
            return this;
        }
        return new ImmutableEventOptions(this.toQueryParameters, this.toHeaders, newValue, this.nodeFilter, this.serviceFilter, this.tagFilter);
    }

    public final ImmutableEventOptions withDatacenter(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.datacenter, value)) {
            return this;
        }
        return new ImmutableEventOptions(this.toQueryParameters, this.toHeaders, value, this.nodeFilter, this.serviceFilter, this.tagFilter);
    }

    public final ImmutableEventOptions withNodeFilter(String value) {
        String newValue = Objects.requireNonNull(value, "nodeFilter");
        if (Objects.equals(this.nodeFilter, newValue)) {
            return this;
        }
        return new ImmutableEventOptions(this.toQueryParameters, this.toHeaders, this.datacenter, newValue, this.serviceFilter, this.tagFilter);
    }

    public final ImmutableEventOptions withNodeFilter(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.nodeFilter, value)) {
            return this;
        }
        return new ImmutableEventOptions(this.toQueryParameters, this.toHeaders, this.datacenter, value, this.serviceFilter, this.tagFilter);
    }

    public final ImmutableEventOptions withServiceFilter(String value) {
        String newValue = Objects.requireNonNull(value, "serviceFilter");
        if (Objects.equals(this.serviceFilter, newValue)) {
            return this;
        }
        return new ImmutableEventOptions(this.toQueryParameters, this.toHeaders, this.datacenter, this.nodeFilter, newValue, this.tagFilter);
    }

    public final ImmutableEventOptions withServiceFilter(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.serviceFilter, value)) {
            return this;
        }
        return new ImmutableEventOptions(this.toQueryParameters, this.toHeaders, this.datacenter, this.nodeFilter, value, this.tagFilter);
    }

    public final ImmutableEventOptions withTagFilter(String value) {
        String newValue = Objects.requireNonNull(value, "tagFilter");
        if (Objects.equals(this.tagFilter, newValue)) {
            return this;
        }
        return new ImmutableEventOptions(this.toQueryParameters, this.toHeaders, this.datacenter, this.nodeFilter, this.serviceFilter, newValue);
    }

    public final ImmutableEventOptions withTagFilter(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.tagFilter, value)) {
            return this;
        }
        return new ImmutableEventOptions(this.toQueryParameters, this.toHeaders, this.datacenter, this.nodeFilter, this.serviceFilter, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEventOptions && this.equalTo((ImmutableEventOptions)another);
    }

    private boolean equalTo(ImmutableEventOptions another) {
        return this.toQueryParameters.equals(another.toQueryParameters) && this.toHeaders.equals(another.toHeaders) && Objects.equals(this.datacenter, another.datacenter) && Objects.equals(this.nodeFilter, another.nodeFilter) && Objects.equals(this.serviceFilter, another.serviceFilter) && Objects.equals(this.tagFilter, another.tagFilter);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.toQueryParameters.hashCode();
        h += (h << 5) + this.toHeaders.hashCode();
        h += (h << 5) + Objects.hashCode(this.datacenter);
        h += (h << 5) + Objects.hashCode(this.nodeFilter);
        h += (h << 5) + Objects.hashCode(this.serviceFilter);
        h += (h << 5) + Objects.hashCode(this.tagFilter);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"EventOptions").omitNullValues().add("toQueryParameters", this.toQueryParameters).add("toHeaders", this.toHeaders).add("datacenter", (Object)this.datacenter).add("nodeFilter", (Object)this.nodeFilter).add("serviceFilter", (Object)this.serviceFilter).add("tagFilter", (Object)this.tagFilter).toString();
    }

    public static ImmutableEventOptions copyOf(EventOptions instance) {
        if (instance instanceof ImmutableEventOptions) {
            return (ImmutableEventOptions)instance;
        }
        return ImmutableEventOptions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="EventOptions", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private ImmutableList.Builder<String> toQueryParameters = ImmutableList.builder();
        private ImmutableMap.Builder<String, String> toHeaders = ImmutableMap.builder();
        @Nullable
        private String datacenter;
        @Nullable
        private String nodeFilter;
        @Nullable
        private String serviceFilter;
        @Nullable
        private String tagFilter;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ParamAdder instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(EventOptions instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ParamAdder instance;
            if (object instanceof ParamAdder) {
                instance = (ParamAdder)object;
                this.addAllToQueryParameters(instance.toQueryParameters());
                this.putAllToHeaders(instance.toHeaders());
            }
            if (object instanceof EventOptions) {
                Optional<String> datacenterOptional;
                Optional<String> nodeFilterOptional;
                Optional<String> tagFilterOptional;
                instance = (EventOptions)object;
                Optional<String> serviceFilterOptional = ((EventOptions)instance).getServiceFilter();
                if (serviceFilterOptional.isPresent()) {
                    this.serviceFilter(serviceFilterOptional);
                }
                if ((tagFilterOptional = ((EventOptions)instance).getTagFilter()).isPresent()) {
                    this.tagFilter(tagFilterOptional);
                }
                if ((nodeFilterOptional = ((EventOptions)instance).getNodeFilter()).isPresent()) {
                    this.nodeFilter(nodeFilterOptional);
                }
                if ((datacenterOptional = ((EventOptions)instance).getDatacenter()).isPresent()) {
                    this.datacenter(datacenterOptional);
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder addToQueryParameters(String element) {
            this.toQueryParameters.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addToQueryParameters(String ... elements) {
            this.toQueryParameters.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder toQueryParameters(Iterable<String> elements) {
            this.toQueryParameters = ImmutableList.builder();
            return this.addAllToQueryParameters(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllToQueryParameters(Iterable<String> elements) {
            this.toQueryParameters.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putToHeaders(String key, String value) {
            this.toHeaders.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putToHeaders(Map.Entry<String, ? extends String> entry) {
            this.toHeaders.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder toHeaders(Map<String, ? extends String> entries) {
            this.toHeaders = ImmutableMap.builder();
            return this.putAllToHeaders(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllToHeaders(Map<String, ? extends String> entries) {
            this.toHeaders.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder datacenter(String datacenter) {
            this.datacenter = Objects.requireNonNull(datacenter, "datacenter");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder datacenter(Optional<String> datacenter) {
            this.datacenter = datacenter.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder nodeFilter(String nodeFilter) {
            this.nodeFilter = Objects.requireNonNull(nodeFilter, "nodeFilter");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder nodeFilter(Optional<String> nodeFilter) {
            this.nodeFilter = nodeFilter.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder serviceFilter(String serviceFilter) {
            this.serviceFilter = Objects.requireNonNull(serviceFilter, "serviceFilter");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder serviceFilter(Optional<String> serviceFilter) {
            this.serviceFilter = serviceFilter.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tagFilter(String tagFilter) {
            this.tagFilter = Objects.requireNonNull(tagFilter, "tagFilter");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tagFilter(Optional<String> tagFilter) {
            this.tagFilter = tagFilter.orElse(null);
            return this;
        }

        public ImmutableEventOptions build() {
            return new ImmutableEventOptions(this.toQueryParameters.build(), this.toHeaders.build(), this.datacenter, this.nodeFilter, this.serviceFilter, this.tagFilter);
        }
    }
}

