/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.ratelimit.client.flow;

import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.ratelimit.client.flow.HostIdentifier;
import com.tencent.polaris.ratelimit.client.flow.RateLimitWindow;
import com.tencent.polaris.ratelimit.client.flow.ServiceIdentifier;
import com.tencent.polaris.ratelimit.client.flow.StreamResource;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;

public class StreamCounterSet {
    private static final Logger LOG = LoggerFactory.getLogger(StreamCounterSet.class);
    private final AtomicInteger reference = new AtomicInteger();
    private final Object resourceLock = new Object();
    private final HostIdentifier identifier;
    private final AtomicReference<StreamResource> currentStreamResource = new AtomicReference();

    public StreamCounterSet(HostIdentifier identifier) {
        this.identifier = identifier;
    }

    public HostIdentifier getIdentifier() {
        return this.identifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamResource checkAndCreateResource(ServiceIdentifier serviceIdentifier, RateLimitWindow rateLimitWindow) {
        StreamResource streamResource = this.currentStreamResource.get();
        if (null != streamResource && !streamResource.isEndStream()) {
            return streamResource;
        }
        Object object = this.resourceLock;
        synchronized (object) {
            streamResource = this.currentStreamResource.get();
            if (null == streamResource || streamResource.isEndStream()) {
                LOG.info("[RateLimit] stream resource for {} not exists or destroyed, start to create", (Object)this.identifier);
                streamResource = new StreamResource(this.identifier);
                this.currentStreamResource.set(streamResource);
            }
            return streamResource;
        }
    }

    public void addReference() {
        this.reference.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean decreaseReference() {
        int value = this.reference.decrementAndGet();
        if (value == 0) {
            Object object = this.resourceLock;
            synchronized (object) {
                StreamResource streamResource = this.currentStreamResource.get();
                if (null != streamResource && !streamResource.isEndStream()) {
                    streamResource.closeStream(true);
                }
            }
            return true;
        }
        return false;
    }

    public void deleteInitRecord(ServiceIdentifier serviceIdentifier) {
        StreamResource streamResource = this.currentStreamResource.get();
        if (null != streamResource) {
            streamResource.deleteInitRecord(serviceIdentifier);
        }
    }
}

