/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.web.handler;

import java.util.HashMap;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.apache.shenyu.plugin.base.alert.AlarmSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.reactive.error.ErrorWebExceptionHandler;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.lang.NonNull;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class GlobalErrorHandler
implements ErrorWebExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(GlobalErrorHandler.class);

    @NonNull
    public Mono<Void> handle(@NonNull ServerWebExchange exchange, @NonNull Throwable throwable) {
        Object errorResult;
        HttpStatus httpStatusCode;
        LOG.error("handle error: {} formatError:{} throwable:", new Object[]{exchange.getLogPrefix(), this.formatError(throwable, exchange.getRequest()), throwable});
        String errorMsg = "";
        if (throwable instanceof IllegalArgumentException) {
            httpStatusCode = HttpStatus.BAD_REQUEST;
            errorResult = ShenyuResultWrap.error((ServerWebExchange)exchange, (int)httpStatusCode.value(), (String)throwable.getMessage(), null);
            errorMsg = throwable.getMessage();
        } else if (throwable instanceof ResponseStatusException) {
            httpStatus = httpStatusCode = ((ResponseStatusException)throwable).getStatusCode();
            String errMsg = StringUtils.hasLength((String)((ResponseStatusException)throwable).getReason()) ? ((ResponseStatusException)throwable).getReason() : httpStatus.getReasonPhrase();
            errorResult = ShenyuResultWrap.error((ServerWebExchange)exchange, (int)httpStatusCode.value(), (String)errMsg, null);
            errorMsg = errMsg;
        } else {
            httpStatus = httpStatusCode = HttpStatus.INTERNAL_SERVER_ERROR;
            errorResult = ShenyuResultWrap.error((ServerWebExchange)exchange, (int)httpStatusCode.value(), (String)httpStatus.getReasonPhrase(), null);
            errorMsg = httpStatus.getReasonPhrase();
        }
        exchange.getResponse().setStatusCode((HttpStatusCode)httpStatusCode);
        HashMap<String, String> labels = new HashMap<String, String>(8);
        labels.put("global", "error");
        labels.put("component", "gateway");
        AlarmSender.alarmMediumCritical((String)"ShenYu-Gateway-Global-Error", (String)errorMsg, labels);
        return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)errorResult);
    }

    private String formatError(Throwable throwable, ServerHttpRequest request) {
        String reason = throwable.getClass().getSimpleName() + ": " + throwable.getMessage();
        return "Resolved [" + reason + "] for HTTP " + request.getMethod() + " " + request.getURI().getRawPath();
    }
}

