/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd;

import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import java.nio.charset.Charset;

public final class ByteSequence {
    public static final ByteSequence EMPTY = new ByteSequence(ByteString.EMPTY);
    public static final ByteSequence NAMESPACE_DELIMITER = ByteSequence.from(new byte[]{47});
    private final int hashVal;
    private final ByteString byteString;

    private ByteSequence(ByteString byteString) {
        Preconditions.checkNotNull((Object)byteString, (Object)"byteString should not be null");
        this.byteString = byteString;
        this.hashVal = byteString.hashCode();
    }

    public boolean startsWith(ByteSequence prefix) {
        if (prefix == null) {
            return false;
        }
        ByteString baseByteString = this.byteString;
        ByteString prefixByteString = prefix.byteString;
        return baseByteString.startsWith(prefixByteString);
    }

    public ByteSequence concat(ByteSequence other) {
        Preconditions.checkNotNull((Object)other, (Object)"other byteSequence should not be null");
        return new ByteSequence(this.byteString.concat(other.byteString));
    }

    public ByteSequence concat(ByteString other) {
        Preconditions.checkNotNull((Object)other, (Object)"other byteSequence should not be null");
        return new ByteSequence(this.byteString.concat(other));
    }

    public ByteSequence substring(int beginIndex) {
        return this.substring(beginIndex, this.byteString.size());
    }

    public ByteSequence substring(int beginIndex, int endIndex) {
        return new ByteSequence(this.byteString.substring(beginIndex, endIndex));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ByteSequence) {
            ByteSequence other = (ByteSequence)obj;
            if (other.hashCode() != this.hashCode()) {
                return false;
            }
            return this.byteString.equals((Object)other.byteString);
        }
        return false;
    }

    public int hashCode() {
        return this.hashVal;
    }

    public String toString(Charset charset) {
        return this.byteString.toString(charset);
    }

    public byte[] getBytes() {
        return this.byteString.toByteArray();
    }

    public boolean isEmpty() {
        return this.byteString.isEmpty();
    }

    public int size() {
        return this.byteString.size();
    }

    public String toString() {
        return this.byteString.toStringUtf8();
    }

    public static ByteSequence from(String source, Charset charset) {
        byte[] bytes = source.getBytes(charset);
        return new ByteSequence(ByteString.copyFrom((byte[])bytes));
    }

    public static ByteSequence from(ByteString source) {
        return new ByteSequence(source);
    }

    public static ByteSequence from(byte[] source) {
        return new ByteSequence(ByteString.copyFrom((byte[])source));
    }
}

