/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.kernel.internal.trigger;

import org.apache.shardingsphere.elasticjob.kernel.internal.listener.AbstractListenerManager;
import org.apache.shardingsphere.elasticjob.kernel.internal.schedule.JobRegistry;
import org.apache.shardingsphere.elasticjob.kernel.internal.trigger.TriggerNode;
import org.apache.shardingsphere.elasticjob.kernel.internal.trigger.TriggerService;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.apache.shardingsphere.elasticjob.reg.listener.DataChangedEvent;
import org.apache.shardingsphere.elasticjob.reg.listener.DataChangedEventListener;

public final class TriggerListenerManager
extends AbstractListenerManager {
    private final String jobName;
    private final TriggerNode triggerNode;
    private final TriggerService triggerService;

    public TriggerListenerManager(CoordinatorRegistryCenter regCenter, String jobName) {
        super(regCenter, jobName);
        this.jobName = jobName;
        this.triggerNode = new TriggerNode(jobName);
        this.triggerService = new TriggerService(regCenter, jobName);
    }

    @Override
    public void start() {
        this.addDataListener(new JobTriggerStatusJobListener());
    }

    class JobTriggerStatusJobListener
    implements DataChangedEventListener {
        JobTriggerStatusJobListener() {
        }

        public void onChange(DataChangedEvent event) {
            if (!TriggerListenerManager.this.triggerNode.isLocalTriggerPath(event.getKey()) || DataChangedEvent.Type.ADDED != event.getType()) {
                return;
            }
            TriggerListenerManager.this.triggerService.removeTriggerFlag();
            if (!JobRegistry.getInstance().isShutdown(TriggerListenerManager.this.jobName) && !JobRegistry.getInstance().isJobRunning(TriggerListenerManager.this.jobName)) {
                JobRegistry.getInstance().getJobScheduleController(TriggerListenerManager.this.jobName).triggerJob();
            }
        }
    }
}

