/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.single.datanode;

import com.cedarsoftware.util.CaseInsensitiveMap;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.metadata.data.loader.type.SchemaMetaDataLoader;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.single.exception.SingleTablesLoadingException;
import org.apache.shardingsphere.single.util.SingleTableLoadUtils;

public final class SingleTableDataNodeLoader {
    public static Map<String, Collection<DataNode>> load(String databaseName, DatabaseType protocolType, Map<String, DataSource> dataSourceMap, Collection<ShardingSphereRule> builtRules, Collection<String> configuredTables) {
        Collection<String> featureRequiredSingleTables = SingleTableLoadUtils.getFeatureRequiredSingleTables(builtRules);
        if (configuredTables.isEmpty() && featureRequiredSingleTables.isEmpty()) {
            return new LinkedHashMap<String, Collection<DataNode>>();
        }
        Collection<String> excludedTables = SingleTableLoadUtils.getExcludedTables(builtRules);
        Collection<String> splitTables = SingleTableLoadUtils.splitTableLines(configuredTables);
        if (splitTables.contains("*.*") || splitTables.contains("*.*.*")) {
            return SingleTableDataNodeLoader.load(databaseName, dataSourceMap, excludedTables);
        }
        Collection configuredDataSources = configuredTables.stream().map(DataNode::new).map(DataNode::getDataSourceName).collect(Collectors.toSet());
        Map<String, DataSource> configuredDataSourceMap = dataSourceMap.entrySet().stream().filter(entry -> configuredDataSources.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<String, Collection<DataNode>> actualDataNodes = SingleTableDataNodeLoader.load(databaseName, configuredDataSourceMap, excludedTables);
        Map<String, Map<String, Collection<String>>> configuredTableMap = SingleTableDataNodeLoader.getConfiguredTableMap(databaseName, protocolType, splitTables);
        return SingleTableDataNodeLoader.loadSpecifiedDataNodes(actualDataNodes, featureRequiredSingleTables, configuredTableMap);
    }

    public static Map<String, Collection<DataNode>> load(String databaseName, Map<String, DataSource> dataSourceMap, Collection<String> excludedTables) {
        ConcurrentHashMap<String, Collection<DataNode>> result = new ConcurrentHashMap<String, Collection<DataNode>>();
        for (Map.Entry<String, DataSource> entry : dataSourceMap.entrySet()) {
            Map<String, Collection<DataNode>> dataNodeMap = SingleTableDataNodeLoader.load(databaseName, DatabaseTypeEngine.getStorageType((DataSource)entry.getValue()), entry.getKey(), entry.getValue(), excludedTables);
            for (Map.Entry<String, Collection<DataNode>> each : dataNodeMap.entrySet()) {
                Collection<DataNode> addedDataNodes = each.getValue();
                Collection existDataNodes = result.getOrDefault(each.getKey().toLowerCase(), new LinkedHashSet(addedDataNodes.size(), 1.0f));
                existDataNodes.addAll(addedDataNodes);
                result.putIfAbsent(each.getKey().toLowerCase(), existDataNodes);
            }
        }
        return result;
    }

    private static Map<String, Collection<DataNode>> load(String databaseName, DatabaseType storageType, String dataSourceName, DataSource dataSource, Collection<String> excludedTables) {
        Map<String, Collection<String>> schemaTableNames = SingleTableDataNodeLoader.loadSchemaTableNames(databaseName, storageType, dataSource, dataSourceName, excludedTables);
        CaseInsensitiveMap result = new CaseInsensitiveMap();
        for (Map.Entry<String, Collection<String>> entry : schemaTableNames.entrySet()) {
            for (String each : entry.getValue()) {
                Collection dataNodes = result.getOrDefault(each, new LinkedList());
                dataNodes.add(new DataNode(dataSourceName, entry.getKey(), each));
                result.putIfAbsent(each, dataNodes);
            }
        }
        return result;
    }

    private static Map<String, Collection<DataNode>> loadSpecifiedDataNodes(Map<String, Collection<DataNode>> actualDataNodes, Collection<String> featureRequiredSingleTables, Map<String, Map<String, Collection<String>>> configuredTableMap) {
        ConcurrentHashMap<String, Collection<DataNode>> result = new ConcurrentHashMap<String, Collection<DataNode>>(actualDataNodes.size(), 1.0f);
        for (Map.Entry<String, Collection<DataNode>> entry : actualDataNodes.entrySet()) {
            Collection<DataNode> singleNodes = SingleTableDataNodeLoader.loadSpecifiedDataNode(entry.getValue(), featureRequiredSingleTables, configuredTableMap);
            if (singleNodes.isEmpty()) continue;
            result.put(entry.getKey(), singleNodes);
        }
        return result;
    }

    private static Collection<DataNode> loadSpecifiedDataNode(Collection<DataNode> dataNodes, Collection<String> featureRequiredSingleTables, Map<String, Map<String, Collection<String>>> configuredTableMap) {
        LinkedList<DataNode> result = new LinkedList<DataNode>();
        for (DataNode each : dataNodes) {
            if (featureRequiredSingleTables.contains(each.getTableName())) {
                result.add(each);
                continue;
            }
            Map<String, Collection<String>> configuredTablesForDataSource = configuredTableMap.get(each.getDataSourceName());
            if (null == configuredTablesForDataSource) continue;
            if (configuredTablesForDataSource.containsKey("*")) {
                result.add(each);
                continue;
            }
            Collection<String> configuredTablesForSchema = configuredTablesForDataSource.get(each.getSchemaName());
            if (null == configuredTablesForSchema || !configuredTablesForSchema.contains("*") && !configuredTablesForSchema.contains(each.getTableName().toLowerCase())) continue;
            result.add(each);
        }
        return result;
    }

    private static Map<String, Map<String, Collection<String>>> getConfiguredTableMap(String databaseName, DatabaseType protocolType, Collection<String> configuredTables) {
        if (configuredTables.isEmpty()) {
            return Collections.emptyMap();
        }
        Collection<DataNode> dataNodes = SingleTableLoadUtils.convertToDataNodes(databaseName, protocolType, configuredTables);
        LinkedHashMap<String, Map<String, Collection<String>>> result = new LinkedHashMap<String, Map<String, Collection<String>>>(dataNodes.size(), 1.0f);
        for (DataNode each : dataNodes) {
            Map schemaTables = result.getOrDefault(each.getDataSourceName(), new LinkedHashMap());
            Collection tables = schemaTables.getOrDefault(each.getSchemaName(), new LinkedList());
            tables.add(each.getTableName());
            schemaTables.putIfAbsent(each.getSchemaName(), tables);
            result.putIfAbsent(each.getDataSourceName(), schemaTables);
        }
        return result;
    }

    public static Map<String, Collection<String>> loadSchemaTableNames(String databaseName, DatabaseType storageType, DataSource dataSource, String dataSourceName, Collection<String> excludedTables) {
        try {
            return new SchemaMetaDataLoader(storageType).loadSchemaTableNames(databaseName, dataSource, excludedTables);
        }
        catch (SQLException ex) {
            throw new SingleTablesLoadingException(databaseName, dataSourceName, ex);
        }
    }

    @Generated
    private SingleTableDataNodeLoader() {
    }
}

