/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.codec.DatabasePacketCodecEngine;
import org.apache.shardingsphere.database.protocol.packet.DatabasePacket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PacketCodec
extends ByteToMessageCodec<DatabasePacket> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PacketCodec.class);
    private final DatabasePacketCodecEngine databasePacketCodecEngine;

    protected void decode(ChannelHandlerContext context, ByteBuf in, List<Object> out) {
        int readableBytes = in.readableBytes();
        if (!this.databasePacketCodecEngine.isValidHeader(readableBytes)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Read from client {} :\n{}", (Object)context.channel().id().asShortText(), (Object)ByteBufUtil.prettyHexDump((ByteBuf)in));
        }
        this.databasePacketCodecEngine.decode(context, in, out);
    }

    protected void encode(ChannelHandlerContext context, DatabasePacket message, ByteBuf out) {
        this.databasePacketCodecEngine.encode(context, message, out);
        if (log.isDebugEnabled()) {
            log.debug("Write to client {} :\n{}", (Object)context.channel().id().asShortText(), (Object)ByteBufUtil.prettyHexDump((ByteBuf)out));
        }
    }

    @Generated
    public PacketCodec(DatabasePacketCodecEngine databasePacketCodecEngine) {
        this.databasePacketCodecEngine = databasePacketCodecEngine;
    }
}

