/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.connector.core.metadata.data.revise;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.exception.RuleAndStorageMetaDataMismatchedException;
import org.apache.shardingsphere.database.connector.core.metadata.data.model.TableMetaData;
import org.apache.shardingsphere.database.connector.core.metadata.data.revise.TableMetaDataViolation;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;

public final class SchemaTableMetaDataAggregator {
    private final boolean checkTableMetaDataEnabled;

    public Collection<TableMetaData> aggregate(Map<String, Collection<TableMetaData>> tableMetaDataMap) {
        LinkedList<TableMetaData> result = new LinkedList<TableMetaData>();
        for (Map.Entry<String, Collection<TableMetaData>> entry : tableMetaDataMap.entrySet()) {
            if (this.checkTableMetaDataEnabled) {
                this.checkUniformed(entry.getKey(), entry.getValue());
            }
            result.add(entry.getValue().iterator().next());
        }
        return result;
    }

    private void checkUniformed(String logicTableName, Collection<TableMetaData> tableMetaDataList) {
        TableMetaData sample = tableMetaDataList.iterator().next();
        Collection violations = tableMetaDataList.stream().filter(each -> !sample.toString().equals(each.toString())).map(each -> new TableMetaDataViolation(each.getName(), (TableMetaData)each)).collect(Collectors.toList());
        ShardingSpherePreconditions.checkMustEmpty((Collection)violations, () -> new RuleAndStorageMetaDataMismatchedException(this.createErrorReason(logicTableName, violations)));
    }

    private String createErrorReason(String logicTableName, Collection<TableMetaDataViolation> violations) {
        StringBuilder result = new StringBuilder("Can not get uniformed table structure for logic table '%s', it has different meta data of actual tables are as follows: ").append(System.lineSeparator());
        for (TableMetaDataViolation each : violations) {
            result.append("actual table: ").append(each.getActualTableName()).append(", meta data: ").append(each.getTableMetaData()).append(System.lineSeparator());
        }
        return String.format(result.toString(), logicTableName);
    }

    @Generated
    public SchemaTableMetaDataAggregator(boolean checkTableMetaDataEnabled) {
        this.checkTableMetaDataEnabled = checkTableMetaDataEnabled;
    }
}

