/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.mysql.packet.command.query.text;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.mysql.packet.MySQLPacket;
import org.apache.shardingsphere.database.protocol.mysql.payload.MySQLPacketPayload;
import org.apache.shardingsphere.infra.exception.generic.UnknownSQLException;
import org.apache.shardingsphere.infra.util.datetime.DateTimeFormatterFactory;

public final class MySQLTextResultSetRowPacket
extends MySQLPacket {
    private static final int NULL = 251;
    private final Collection<Object> data;

    public MySQLTextResultSetRowPacket(MySQLPacketPayload payload, int columnCount) {
        this.data = new ArrayList<Object>(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            this.data.add(payload.readStringLenenc());
        }
    }

    @Override
    protected void write(MySQLPacketPayload payload) {
        for (Object each : this.data) {
            if (null == each) {
                payload.writeInt1(251);
                continue;
            }
            this.writeDataIntoPayload(payload, each);
        }
    }

    private void writeDataIntoPayload(MySQLPacketPayload payload, Object data) {
        if (data instanceof byte[]) {
            payload.writeBytesLenenc((byte[])data);
        } else if (data instanceof Timestamp && 0 == ((Timestamp)data).getNanos()) {
            payload.writeStringLenenc(data.toString().split("\\.")[0]);
        } else if (data instanceof BigDecimal) {
            payload.writeStringLenenc(((BigDecimal)data).toPlainString());
        } else if (data instanceof Boolean) {
            byte[] byArray;
            if (((Boolean)data).booleanValue()) {
                byte[] byArray2 = new byte[1];
                byArray = byArray2;
                byArray2[0] = 1;
            } else {
                byte[] byArray3 = new byte[1];
                byArray = byArray3;
                byArray3[0] = 0;
            }
            payload.writeBytesLenenc(byArray);
        } else if (data instanceof LocalDateTime) {
            payload.writeStringLenenc(this.formatLocalDateTime((LocalDateTime)data));
        } else if (data instanceof LocalTime) {
            payload.writeStringLenenc(this.formatLocalTime((LocalTime)data));
        } else if (data instanceof Clob) {
            try {
                payload.writeBytesLenenc(ByteStreams.toByteArray((InputStream)((Clob)data).getAsciiStream()));
            }
            catch (IOException | SQLException ex) {
                throw new UnknownSQLException(ex);
            }
        } else {
            payload.writeStringLenenc(data.toString());
        }
    }

    private String formatLocalDateTime(LocalDateTime value) {
        int endIndex;
        int nanos = value.getNano();
        if (0 == nanos) {
            return DateTimeFormatterFactory.getDatetimeFormatter().format(value);
        }
        StringBuilder result = new StringBuilder(DateTimeFormatterFactory.getDatetimeFormatter().format(value)).append('.');
        String microsecondsText = String.format("%06d", nanos / 1000);
        for (endIndex = microsecondsText.length(); endIndex > 0 && '0' == microsecondsText.charAt(endIndex - 1); --endIndex) {
        }
        if (0 == endIndex) {
            return result.substring(0, result.length() - 1);
        }
        result.append(microsecondsText, 0, endIndex);
        return result.toString();
    }

    private String formatLocalTime(LocalTime value) {
        int endIndex;
        int nanos = value.getNano();
        if (0 == nanos) {
            return DateTimeFormatterFactory.getTimeFormatter().format(value);
        }
        StringBuilder result = new StringBuilder(DateTimeFormatterFactory.getTimeFormatter().format(value)).append('.');
        String microsecondsText = String.format("%06d", nanos / 1000);
        for (endIndex = microsecondsText.length(); endIndex > 0 && '0' == microsecondsText.charAt(endIndex - 1); --endIndex) {
        }
        if (0 == endIndex) {
            return result.substring(0, result.length() - 1);
        }
        result.append(microsecondsText, 0, endIndex);
        return result.toString();
    }

    @Generated
    public MySQLTextResultSetRowPacket(Collection<Object> data) {
        this.data = data;
    }

    @Generated
    public Collection<Object> getData() {
        return this.data;
    }
}

