/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.parameter.rewriter;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.column.EncryptColumn;
import org.apache.shardingsphere.infra.binder.context.segment.insert.values.OnDuplicateUpdateContext;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.ParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.impl.GroupedParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.impl.StandardParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.parameter.rewriter.ParameterRewriter;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.ParameterMarkerExpressionSegment;

public final class EncryptInsertOnDuplicateKeyUpdateValueParameterRewriter
implements ParameterRewriter {
    private final EncryptRule rule;
    private final String databaseName;

    public boolean isNeedRewrite(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof InsertStatementContext && ((InsertStatementContext)sqlStatementContext).getSqlStatement().getOnDuplicateKeyColumns().isPresent();
    }

    public void rewrite(ParameterBuilder paramBuilder, SQLStatementContext sqlStatementContext, List<Object> params) {
        InsertStatementContext insertStatementContext = (InsertStatementContext)sqlStatementContext;
        String tableName = insertStatementContext.getSqlStatement().getTable().map(optional -> optional.getTableName().getIdentifier().getValue()).orElse("");
        StandardParameterBuilder standardParamBuilder = paramBuilder instanceof StandardParameterBuilder ? (StandardParameterBuilder)paramBuilder : ((GroupedParameterBuilder)paramBuilder).getAfterGenericParameterBuilder();
        OnDuplicateUpdateContext onDuplicateKeyUpdateValueContext = insertStatementContext.getOnDuplicateKeyUpdateValueContext();
        String schemaName = insertStatementContext.getTablesContext().getSchemaName().orElseGet(() -> new DatabaseTypeRegistry(insertStatementContext.getSqlStatement().getDatabaseType()).getDefaultSchemaName(this.databaseName));
        int onDuplicateKeyParameterMarkerIndex = 0;
        for (int index = 0; index < onDuplicateKeyUpdateValueContext.getValueExpressions().size(); ++index) {
            ExpressionSegment valueExpression;
            String logicColumnName = onDuplicateKeyUpdateValueContext.getColumn(index).getIdentifier().getValue();
            if (!this.rule.findEncryptTable(tableName).map(optional -> optional.isEncryptColumn(logicColumnName)).orElse(false).booleanValue() || !((valueExpression = (ExpressionSegment)onDuplicateKeyUpdateValueContext.getValueExpressions().get(index)) instanceof ParameterMarkerExpressionSegment)) continue;
            int parameterIndex = this.getParameterMarkerIndex(paramBuilder, (ParameterMarkerExpressionSegment)valueExpression, onDuplicateKeyParameterMarkerIndex++);
            Object plainValue = onDuplicateKeyUpdateValueContext.getValue(index);
            EncryptColumn encryptColumn = this.rule.getEncryptTable(tableName).getEncryptColumn(logicColumnName);
            Object cipherColumnValue = encryptColumn.getCipher().encrypt(this.databaseName, schemaName, tableName, logicColumnName, plainValue);
            standardParamBuilder.addReplacedParameters(parameterIndex, cipherColumnValue);
            Collection<Object> addedParams = this.buildAddedParams(schemaName, tableName, encryptColumn, logicColumnName, plainValue);
            if (addedParams.isEmpty()) continue;
            if (!standardParamBuilder.getAddedIndexAndParameters().containsKey(parameterIndex)) {
                standardParamBuilder.getAddedIndexAndParameters().put(parameterIndex, new LinkedList());
            }
            ((Collection)standardParamBuilder.getAddedIndexAndParameters().get(parameterIndex)).addAll(addedParams);
        }
    }

    private int getParameterMarkerIndex(ParameterBuilder paramBuilder, ParameterMarkerExpressionSegment paramMarkerExpression, int index) {
        return paramBuilder instanceof StandardParameterBuilder ? paramMarkerExpression.getParameterMarkerIndex() : index;
    }

    private Collection<Object> buildAddedParams(String schemaName, String tableName, EncryptColumn encryptColumn, String logicColumnName, Object plainValue) {
        LinkedList<Object> result = new LinkedList<Object>();
        if (encryptColumn.getAssistedQuery().isPresent()) {
            result.add(encryptColumn.getAssistedQuery().get().encrypt(this.databaseName, schemaName, tableName, logicColumnName, plainValue));
        }
        if (encryptColumn.getLikeQuery().isPresent()) {
            result.add(encryptColumn.getLikeQuery().get().encrypt(this.databaseName, schemaName, tableName, logicColumnName, plainValue));
        }
        return result;
    }

    @Generated
    public EncryptInsertOnDuplicateKeyUpdateValueParameterRewriter(EncryptRule rule, String databaseName) {
        this.rule = rule;
        this.databaseName = databaseName;
    }
}

