/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.datasource.pool.props.creator;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.datasource.pool.CatalogSwitchableDataSource;
import org.apache.shardingsphere.infra.datasource.pool.config.ConnectionConfiguration;
import org.apache.shardingsphere.infra.datasource.pool.config.DataSourceConfiguration;
import org.apache.shardingsphere.infra.datasource.pool.config.PoolConfiguration;
import org.apache.shardingsphere.infra.datasource.pool.creator.DataSourcePoolReflection;
import org.apache.shardingsphere.infra.datasource.pool.metadata.DataSourcePoolMetaData;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.DataSourcePoolProperties;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.custom.CustomDataSourcePoolProperties;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.synonym.ConnectionPropertySynonyms;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.synonym.PoolPropertySynonyms;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;

public final class DataSourcePoolPropertiesCreator {
    public static DataSourcePoolProperties create(DataSourceConfiguration config) {
        return new DataSourcePoolProperties(config.getConnection().getDataSourceClassName(), DataSourcePoolPropertiesCreator.createProperties(config));
    }

    public static DataSourcePoolProperties create(DataSource dataSource) {
        DataSource realDataSource = dataSource instanceof CatalogSwitchableDataSource ? ((CatalogSwitchableDataSource)dataSource).getDataSource() : dataSource;
        return new DataSourcePoolProperties(realDataSource.getClass().getName(), DataSourcePoolPropertiesCreator.createProperties(realDataSource));
    }

    private static Map<String, Object> createProperties(DataSourceConfiguration config) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("dataSourceClassName", config.getConnection().getDataSourceClassName());
        result.put("url", config.getConnection().getUrl());
        result.put("username", config.getConnection().getUsername());
        result.put("password", config.getConnection().getPassword());
        result.put("connectionTimeoutMilliseconds", config.getPool().getConnectionTimeoutMilliseconds());
        result.put("idleTimeoutMilliseconds", config.getPool().getIdleTimeoutMilliseconds());
        result.put("maxLifetimeMilliseconds", config.getPool().getMaxLifetimeMilliseconds());
        result.put("maxPoolSize", config.getPool().getMaxPoolSize());
        result.put("minPoolSize", config.getPool().getMinPoolSize());
        result.put("readOnly", config.getPool().getReadOnly());
        if (null != config.getPool().getCustomProperties()) {
            result.putAll(config.getPool().getCustomProperties());
        }
        return result;
    }

    private static Map<String, Object> createProperties(DataSource dataSource) {
        Map<String, Object> props = new DataSourcePoolReflection(dataSource).convertToProperties();
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(props.size(), 1.0f);
        Optional metaData = TypedSPILoader.findService(DataSourcePoolMetaData.class, (Object)dataSource.getClass().getName());
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            String propertyName = entry.getKey();
            Object propertyValue = entry.getValue();
            if (metaData.isPresent() && (!DataSourcePoolPropertiesCreator.isValidProperty(propertyName, propertyValue, (DataSourcePoolMetaData)metaData.get()) || ((DataSourcePoolMetaData)metaData.get()).getTransientFieldNames().contains(propertyName))) continue;
            result.put(propertyName, propertyValue);
        }
        return result;
    }

    private static boolean isValidProperty(String key, Object value, DataSourcePoolMetaData metaData) {
        return null == value || !metaData.getSkippedProperties().containsKey(key) || !value.equals(metaData.getSkippedProperties().get(key));
    }

    public static DataSourceConfiguration createConfiguration(DataSourcePoolProperties props) {
        return new DataSourceConfiguration(DataSourcePoolPropertiesCreator.getConnectionConfiguration(props.getConnectionPropertySynonyms()), DataSourcePoolPropertiesCreator.getPoolConfiguration(props.getPoolPropertySynonyms(), props.getCustomProperties()));
    }

    private static ConnectionConfiguration getConnectionConfiguration(ConnectionPropertySynonyms connectionPropSynonyms) {
        Map<String, Object> standardProps = connectionPropSynonyms.getStandardProperties();
        return new ConnectionConfiguration((String)standardProps.get("dataSourceClassName"), (String)standardProps.get("url"), (String)standardProps.get("username"), (String)standardProps.get("password"));
    }

    private static PoolConfiguration getPoolConfiguration(PoolPropertySynonyms poolPropSynonyms, CustomDataSourcePoolProperties customProps) {
        Map<String, Object> standardProps = poolPropSynonyms.getStandardProperties();
        Long connectionTimeoutMilliseconds = DataSourcePoolPropertiesCreator.toLong(standardProps, "connectionTimeoutMilliseconds");
        Long idleTimeoutMilliseconds = DataSourcePoolPropertiesCreator.toLong(standardProps, "idleTimeoutMilliseconds");
        Long maxLifetimeMilliseconds = DataSourcePoolPropertiesCreator.toLong(standardProps, "maxLifetimeMilliseconds");
        Integer maxPoolSize = DataSourcePoolPropertiesCreator.toInt(standardProps, "maxPoolSize");
        Integer minPoolSize = DataSourcePoolPropertiesCreator.toInt(standardProps, "minPoolSize");
        Boolean readOnly = DataSourcePoolPropertiesCreator.toBoolean(standardProps, "readOnly");
        Properties newCustomProps = new Properties();
        newCustomProps.putAll(customProps.getProperties());
        return new PoolConfiguration(connectionTimeoutMilliseconds, idleTimeoutMilliseconds, maxLifetimeMilliseconds, maxPoolSize, minPoolSize, readOnly, newCustomProps);
    }

    private static Long toLong(Map<String, Object> props, String name) {
        if (!props.containsKey(name)) {
            return null;
        }
        try {
            return Long.parseLong(String.valueOf(props.get(name)));
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    private static Integer toInt(Map<String, Object> props, String name) {
        if (!props.containsKey(name)) {
            return null;
        }
        try {
            return Integer.parseInt(String.valueOf(props.get(name)));
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    private static Boolean toBoolean(Map<String, Object> props, String name) {
        return props.containsKey(name) ? Boolean.valueOf(Boolean.parseBoolean(String.valueOf(props.get(name)))) : null;
    }

    @Generated
    private DataSourcePoolPropertiesCreator() {
    }
}

