/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.props.temporary.TemporaryConfigurationProperties;
import org.apache.shardingsphere.infra.database.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.datasource.pool.destroyer.DataSourcePoolDestroyer;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabaseFactory;
import org.apache.shardingsphere.infra.metadata.database.resource.ResourceMetaData;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.metadata.identifier.ShardingSphereIdentifier;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.attribute.datasource.StaticDataSourceRuleAttribute;
import org.apache.shardingsphere.infra.rule.scope.GlobalRule;

public final class ShardingSphereMetaData
implements AutoCloseable {
    private final Map<ShardingSphereIdentifier, ShardingSphereDatabase> databases;
    private final ResourceMetaData globalResourceMetaData;
    private final RuleMetaData globalRuleMetaData;
    private final ConfigurationProperties props;
    private final TemporaryConfigurationProperties temporaryProps;
    private final DatabaseType protocolType;

    public ShardingSphereMetaData(Collection<ShardingSphereDatabase> databases, ResourceMetaData globalResourceMetaData, RuleMetaData globalRuleMetaData, ConfigurationProperties props) {
        this.databases = new ConcurrentHashMap<ShardingSphereIdentifier, ShardingSphereDatabase>(databases.stream().collect(Collectors.toMap(each -> new ShardingSphereIdentifier(each.getName()), each -> each)));
        this.globalResourceMetaData = globalResourceMetaData;
        this.globalRuleMetaData = globalRuleMetaData;
        this.props = props;
        this.temporaryProps = new TemporaryConfigurationProperties(props.getProps());
        this.protocolType = databases.isEmpty() ? DatabaseTypeEngine.getProtocolType(Collections.emptyMap(), props) : databases.iterator().next().getProtocolType();
    }

    public Collection<ShardingSphereDatabase> getAllDatabases() {
        return this.databases.values();
    }

    public boolean containsDatabase(String databaseName) {
        return this.databases.containsKey(new ShardingSphereIdentifier(databaseName));
    }

    public ShardingSphereDatabase getDatabase(String databaseName) {
        return this.databases.get(new ShardingSphereIdentifier(databaseName));
    }

    public void addDatabase(String databaseName, DatabaseType protocolType, ConfigurationProperties props) {
        ShardingSphereDatabase database = ShardingSphereDatabaseFactory.create(databaseName, protocolType, props);
        this.databases.put(new ShardingSphereIdentifier(database.getName()), database);
        this.globalRuleMetaData.getRules().forEach(each -> ((GlobalRule)each).refresh(this.databases.values(), GlobalRule.GlobalRuleChangedType.DATABASE_CHANGED));
    }

    public void putDatabase(ShardingSphereDatabase database) {
        this.databases.put(new ShardingSphereIdentifier(database.getName()), database);
    }

    public void dropDatabase(String databaseName) {
        this.cleanResources(this.databases.remove(new ShardingSphereIdentifier(databaseName)));
    }

    private void cleanResources(ShardingSphereDatabase database) {
        this.globalRuleMetaData.getRules().forEach(each -> ((GlobalRule)each).refresh(this.databases.values(), GlobalRule.GlobalRuleChangedType.DATABASE_CHANGED));
        for (ShardingSphereRule each2 : database.getRuleMetaData().getRules()) {
            if (!(each2 instanceof AutoCloseable)) continue;
            ((AutoCloseable)((Object)each2)).close();
        }
        database.getRuleMetaData().getAttributes(StaticDataSourceRuleAttribute.class).forEach(StaticDataSourceRuleAttribute::cleanStorageNodeDataSources);
        Optional.ofNullable(database.getResourceMetaData()).ifPresent(optional -> optional.getStorageUnits().values().forEach(each -> new DataSourcePoolDestroyer(each.getDataSource()).asyncDestroy()));
    }

    @Override
    public void close() {
        for (ShardingSphereRule each : this.getAllRules()) {
            if (!(each instanceof AutoCloseable)) continue;
            ((AutoCloseable)((Object)each)).close();
        }
    }

    private Collection<ShardingSphereRule> getAllRules() {
        LinkedList<ShardingSphereRule> result = new LinkedList<ShardingSphereRule>(this.globalRuleMetaData.getRules());
        this.getAllDatabases().stream().map(each -> each.getRuleMetaData().getRules()).forEach(result::addAll);
        return result;
    }

    @Generated
    public ResourceMetaData getGlobalResourceMetaData() {
        return this.globalResourceMetaData;
    }

    @Generated
    public RuleMetaData getGlobalRuleMetaData() {
        return this.globalRuleMetaData;
    }

    @Generated
    public ConfigurationProperties getProps() {
        return this.props;
    }

    @Generated
    public TemporaryConfigurationProperties getTemporaryProps() {
        return this.temporaryProps;
    }

    @Generated
    public DatabaseType getProtocolType() {
        return this.protocolType;
    }
}

