/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.config.rule.checker;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.config.rule.checker.DatabaseRuleConfigurationChecker;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.metadata.rule.DuplicateRuleException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.infra.spi.type.ordered.OrderedSPILoader;

public final class DatabaseRuleConfigurationCheckEngine {
    public static void check(RuleConfiguration ruleConfig, ShardingSphereDatabase database) {
        Collection<String> tableNames;
        DatabaseRuleConfigurationChecker checker = (DatabaseRuleConfigurationChecker)OrderedSPILoader.getServicesByClass(DatabaseRuleConfigurationChecker.class, Collections.singleton(ruleConfig.getClass())).get(ruleConfig.getClass());
        if (null == checker) {
            return;
        }
        Collection<String> requiredDataSourceNames = checker.getRequiredDataSourceNames(ruleConfig);
        if (!requiredDataSourceNames.isEmpty()) {
            database.checkStorageUnitsExisted(requiredDataSourceNames);
        }
        if (!(tableNames = checker.getTableNames(ruleConfig)).isEmpty()) {
            DatabaseRuleConfigurationCheckEngine.checkTablesNotDuplicated(ruleConfig, database.getName(), tableNames);
        }
        Map<String, DataSource> dataSources = database.getResourceMetaData().getStorageUnits().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((StorageUnit)entry.getValue()).getDataSource()));
        checker.check(database.getName(), ruleConfig, dataSources, database.getRuleMetaData().getRules());
    }

    private static void checkTablesNotDuplicated(RuleConfiguration ruleConfig, String databaseName, Collection<String> tableNames) {
        Collection duplicatedTables = tableNames.stream().collect(Collectors.groupingBy(each -> each, Collectors.counting())).entrySet().stream().filter(each -> (Long)each.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toSet());
        ShardingSpherePreconditions.checkMustEmpty((Collection)duplicatedTables, () -> new DuplicateRuleException(DatabaseRuleConfigurationCheckEngine.getRuleType(ruleConfig), databaseName, duplicatedTables));
    }

    private static String getRuleType(RuleConfiguration ruleConfig) {
        String ruleConfigClassName = ruleConfig.getClass().getSimpleName();
        return ruleConfigClassName.substring(0, ruleConfigClassName.indexOf("RuleConfiguration"));
    }

    @Generated
    private DatabaseRuleConfigurationCheckEngine() {
    }
}

