/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.ral.updatable.lock;

import java.sql.SQLException;
import org.apache.shardingsphere.distsql.handler.engine.update.DistSQLUpdateExecutor;
import org.apache.shardingsphere.distsql.handler.required.DistSQLExecutorClusterModeRequired;
import org.apache.shardingsphere.distsql.statement.type.ral.updatable.UnlockClusterStatement;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.mode.exclusive.ExclusiveOperation;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.cluster.lock.exception.NotLockedClusterException;
import org.apache.shardingsphere.mode.state.ShardingSphereState;
import org.apache.shardingsphere.proxy.backend.handler.distsql.ral.updatable.lock.LockClusterOperation;

@DistSQLExecutorClusterModeRequired
public final class UnlockClusterExecutor
implements DistSQLUpdateExecutor<UnlockClusterStatement> {
    public void executeUpdate(UnlockClusterStatement sqlStatement, ContextManager contextManager) throws SQLException {
        this.checkState(contextManager);
        contextManager.getExclusiveOperatorEngine().operate((ExclusiveOperation)new LockClusterOperation(), sqlStatement.getTimeoutMillis(), () -> {
            this.checkState(contextManager);
            contextManager.getPersistServiceFacade().getStateService().update(ShardingSphereState.OK);
        });
    }

    private void checkState(ContextManager contextManager) {
        ShardingSpherePreconditions.checkState((ShardingSphereState.OK != contextManager.getStateContext().getState() ? 1 : 0) != 0, NotLockedClusterException::new);
    }

    public Class<UnlockClusterStatement> getType() {
        return UnlockClusterStatement.class;
    }
}

