/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.connector.jdbc.transaction;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.session.connection.transaction.TransactionConnectionContext;
import org.apache.shardingsphere.infra.session.connection.transaction.TransactionManager;
import org.apache.shardingsphere.infra.spi.type.ordered.OrderedSPILoader;
import org.apache.shardingsphere.mode.exclusive.ExclusiveOperation;
import org.apache.shardingsphere.proxy.backend.connector.ProxyDatabaseConnectionManager;
import org.apache.shardingsphere.proxy.backend.connector.jdbc.transaction.LocalTransactionManager;
import org.apache.shardingsphere.proxy.backend.connector.jdbc.transaction.TransactionCommitOperation;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.util.TransactionUtils;
import org.apache.shardingsphere.transaction.ShardingSphereTransactionManagerEngine;
import org.apache.shardingsphere.transaction.api.TransactionType;
import org.apache.shardingsphere.transaction.rule.TransactionRule;
import org.apache.shardingsphere.transaction.savepoint.ConnectionSavepointManager;
import org.apache.shardingsphere.transaction.spi.ShardingSphereDistributedTransactionManager;
import org.apache.shardingsphere.transaction.spi.TransactionHook;

public final class ProxyBackendTransactionManager {
    private final ProxyDatabaseConnectionManager connection;
    private final TransactionType transactionType;
    private final LocalTransactionManager localTransactionManager;
    private final ShardingSphereDistributedTransactionManager distributedTransactionManager;
    private final Map<ShardingSphereRule, TransactionHook> transactionHooks;
    private final TransactionConnectionContext transactionContext;

    public ProxyBackendTransactionManager(ProxyDatabaseConnectionManager databaseConnectionManager) {
        this.connection = databaseConnectionManager;
        this.localTransactionManager = new LocalTransactionManager(databaseConnectionManager);
        TransactionRule transactionRule = (TransactionRule)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getGlobalRuleMetaData().getSingleRule(TransactionRule.class);
        this.transactionContext = this.connection.getConnectionSession().getConnectionContext().getTransactionContext();
        this.transactionType = transactionRule.getDefaultType();
        ShardingSphereTransactionManagerEngine engine = transactionRule.getResource();
        this.distributedTransactionManager = this.transactionContext.getTransactionManager().isPresent() ? (ShardingSphereDistributedTransactionManager)this.transactionContext.getTransactionManager().get() : (null == engine ? null : engine.getTransactionManager(this.transactionType));
        this.transactionHooks = OrderedSPILoader.getServices(TransactionHook.class, (Collection)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getGlobalRuleMetaData().getRules());
    }

    public void begin() {
        if (!this.connection.getConnectionSession().getTransactionStatus().isInTransaction()) {
            this.connection.closeHandlers(true);
            this.connection.closeConnections(false);
            this.connection.getConnectionSession().getTransactionStatus().setInTransaction(true);
            this.transactionContext.beginTransaction(this.transactionType.name(), (TransactionManager)this.distributedTransactionManager);
        }
        this.doBegin();
    }

    private void doBegin() {
        DatabaseType databaseType = ProxyContext.getInstance().getContextManager().getDatabaseType();
        for (Map.Entry<ShardingSphereRule, TransactionHook> entry : this.transactionHooks.entrySet()) {
            entry.getValue().beforeBegin(entry.getKey(), databaseType, this.transactionContext);
        }
        if (TransactionType.LOCAL == this.transactionType || null == this.distributedTransactionManager) {
            this.localTransactionManager.begin();
        } else {
            this.distributedTransactionManager.begin();
        }
        for (Map.Entry<ShardingSphereRule, TransactionHook> entry : this.transactionHooks.entrySet()) {
            entry.getValue().afterBegin(entry.getKey(), databaseType, this.transactionContext);
        }
    }

    public void commit() throws SQLException {
        if (!this.connection.getConnectionSession().getTransactionStatus().isInTransaction()) {
            return;
        }
        DatabaseType databaseType = ProxyContext.getInstance().getContextManager().getDatabaseType();
        boolean isNeedLock = this.isNeedLockWhenCommit();
        if (isNeedLock) {
            ProxyContext.getInstance().getContextManager().getExclusiveOperatorEngine().operate((ExclusiveOperation)new TransactionCommitOperation(), 200L, () -> this.commit(databaseType));
        } else {
            this.commit(databaseType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commit(DatabaseType databaseType) throws SQLException {
        try {
            for (Map.Entry<ShardingSphereRule, TransactionHook> entry : this.transactionHooks.entrySet()) {
                entry.getValue().beforeCommit(entry.getKey(), databaseType, this.connection.getCachedConnections().values(), this.transactionContext);
            }
            if (TransactionType.LOCAL == TransactionUtils.getTransactionType(this.transactionContext) || null == this.distributedTransactionManager) {
                this.localTransactionManager.commit();
            } else {
                this.distributedTransactionManager.commit(this.transactionContext.isExceptionOccur());
            }
        }
        finally {
            this.clear();
        }
    }

    private boolean isNeedLockWhenCommit() {
        for (Map.Entry<ShardingSphereRule, TransactionHook> entry : this.transactionHooks.entrySet()) {
            if (!entry.getValue().isNeedLockWhenCommit(entry.getKey())) continue;
            return true;
        }
        return false;
    }

    private void clear() {
        for (Connection each : this.connection.getCachedConnections().values()) {
            ConnectionSavepointManager.getInstance().transactionFinished(each);
        }
        this.connection.getConnectionSession().getTransactionStatus().setInTransaction(false);
        this.connection.getConnectionSession().getConnectionContext().close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws SQLException {
        if (!this.connection.getConnectionSession().getTransactionStatus().isInTransaction()) {
            return;
        }
        DatabaseType databaseType = ProxyContext.getInstance().getContextManager().getDatabaseType();
        for (Map.Entry<ShardingSphereRule, TransactionHook> entry : this.transactionHooks.entrySet()) {
            entry.getValue().beforeRollback(entry.getKey(), databaseType, this.connection.getCachedConnections().values(), this.transactionContext);
        }
        if (this.connection.getConnectionSession().getTransactionStatus().isInTransaction()) {
            try {
                if (TransactionType.LOCAL == TransactionUtils.getTransactionType(this.transactionContext) || null == this.distributedTransactionManager) {
                    this.localTransactionManager.rollback();
                } else {
                    this.distributedTransactionManager.rollback();
                }
            }
            finally {
                for (Map.Entry<ShardingSphereRule, TransactionHook> entry : this.transactionHooks.entrySet()) {
                    entry.getValue().afterRollback(entry.getKey(), databaseType, this.connection.getCachedConnections().values(), this.transactionContext);
                }
                this.clear();
            }
        }
    }

    public void setSavepoint(String savepointName) throws SQLException {
        for (Connection each : this.connection.getCachedConnections().values()) {
            ConnectionSavepointManager.getInstance().setSavepoint(each, savepointName);
        }
        this.connection.getConnectionPostProcessors().add(target -> ConnectionSavepointManager.getInstance().setSavepoint(target, savepointName));
    }

    public void rollbackTo(String savepointName) throws SQLException {
        LinkedList<SQLException> result = new LinkedList<SQLException>();
        for (Connection each : this.connection.getCachedConnections().values()) {
            try {
                ConnectionSavepointManager.getInstance().rollbackToSavepoint(each, savepointName);
            }
            catch (SQLException ex) {
                result.add(ex);
            }
        }
        if (result.isEmpty() && this.transactionContext.isExceptionOccur()) {
            this.transactionContext.setExceptionOccur(false);
        }
        this.throwSQLExceptionIfNecessary(result);
    }

    public void releaseSavepoint(String savepointName) throws SQLException {
        LinkedList<SQLException> result = new LinkedList<SQLException>();
        for (Connection each : this.connection.getCachedConnections().values()) {
            try {
                ConnectionSavepointManager.getInstance().releaseSavepoint(each, savepointName);
            }
            catch (SQLException ex) {
                result.add(ex);
            }
        }
        this.throwSQLExceptionIfNecessary(result);
    }

    private void throwSQLExceptionIfNecessary(Collection<SQLException> exceptions) throws SQLException {
        if (exceptions.isEmpty()) {
            return;
        }
        Iterator<SQLException> iterator = exceptions.iterator();
        SQLException firstException = iterator.next();
        while (iterator.hasNext()) {
            firstException.setNextException(iterator.next());
        }
        throw firstException;
    }
}

