/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.mysql.handler.admin.factory;

import com.cedarsoftware.util.CaseInsensitiveSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.statement.type.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminExecutor;
import org.apache.shardingsphere.proxy.backend.mysql.handler.admin.factory.schema.MySQLSystemSchemaQueryExecutorFactory;
import org.apache.shardingsphere.proxy.backend.mysql.handler.admin.factory.withoutfrom.MySQLSelectWithoutFromAdminExecutorFactory;

public final class MySQLSelectAdminExecutorFactory {
    private static final Collection<String> SYSTEM_SCHEMAS = new CaseInsensitiveSet(Arrays.asList("information_schema", "performance_schema", "mysql", "sys"));

    public static Optional<DatabaseAdminExecutor> newInstance(SelectStatementContext selectStatementContext, String sql, List<Object> parameters, String databaseName, ShardingSphereMetaData metaData) {
        if (!selectStatementContext.getSqlStatement().getFrom().isPresent()) {
            return MySQLSelectWithoutFromAdminExecutorFactory.newInstance(selectStatementContext, sql, databaseName, metaData);
        }
        return MySQLSelectAdminExecutorFactory.getSchemaName(databaseName, metaData).flatMap(optional -> MySQLSystemSchemaQueryExecutorFactory.newInstance(selectStatementContext, sql, parameters, optional));
    }

    private static Optional<String> getSchemaName(String databaseName, ShardingSphereMetaData metaData) {
        return SYSTEM_SCHEMAS.contains(databaseName) && !metaData.getDatabase(databaseName).isComplete() ? Optional.of(databaseName) : Optional.empty();
    }

    @Generated
    private MySQLSelectAdminExecutorFactory() {
    }
}

