/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor.show;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.metadata.database.system.SystemDatabase;
import org.apache.shardingsphere.database.exception.core.exception.syntax.database.UnknownDatabaseException;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.metadata.RawQueryResultColumnMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.metadata.RawQueryResultMetaData;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataMergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.util.regex.RegexUtils;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminQueryExecutor;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.ShowFilterSegment;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.table.MySQLShowTablesStatement;

public final class MySQLShowTablesExecutor
implements DatabaseAdminQueryExecutor {
    private final MySQLShowTablesStatement sqlStatement;
    private QueryResultMetaData queryResultMetaData;
    private MergedResult mergedResult;

    public void execute(ConnectionSession connectionSession, ShardingSphereMetaData metaData) {
        String databaseName = this.sqlStatement.getFromDatabase().map(optional -> optional.getDatabase().getIdentifier().getValue()).orElseGet(() -> ((ConnectionSession)connectionSession).getUsedDatabaseName());
        this.queryResultMetaData = this.createQueryResultMetaData(databaseName);
        this.mergedResult = new LocalDataMergedResult(this.getQueryResultRows(databaseName, metaData));
    }

    private QueryResultMetaData createQueryResultMetaData(String databaseName) {
        ArrayList<RawQueryResultColumnMetaData> columnNames = new ArrayList<RawQueryResultColumnMetaData>(2);
        String tableColumnName = String.format("Tables_in_%s", databaseName);
        columnNames.add(new RawQueryResultColumnMetaData("", tableColumnName, tableColumnName, 12, "VARCHAR", 255, 0));
        if (this.sqlStatement.isContainsFull()) {
            columnNames.add(new RawQueryResultColumnMetaData("", "Table_type", "Table_type", 12, "VARCHAR", 20, 0));
        }
        return new RawQueryResultMetaData(columnNames);
    }

    private Collection<LocalDataQueryResultRow> getQueryResultRows(String databaseName, ShardingSphereMetaData metaData) {
        SystemDatabase systemDatabase = new SystemDatabase(this.sqlStatement.getDatabaseType());
        ShardingSpherePreconditions.checkState((boolean)metaData.containsDatabase(databaseName), () -> new UnknownDatabaseException(databaseName));
        ShardingSphereDatabase database = metaData.getDatabase(databaseName);
        return systemDatabase.getSystemSchemas().contains(databaseName) || database.isComplete() ? (Collection)this.getTables(database).stream().map(this::getQueryResultRow).collect(Collectors.toList()) : Collections.emptyList();
    }

    private Collection<ShardingSphereTable> getTables(ShardingSphereDatabase database) {
        if (null == database.getSchema(database.getName())) {
            return Collections.emptyList();
        }
        Collection tables = database.getSchema(database.getName()).getAllTables();
        Collection<ShardingSphereTable> filteredTables = this.filterByLike(tables);
        return filteredTables.stream().sorted(Comparator.comparing(ShardingSphereTable::getName)).collect(Collectors.toList());
    }

    private Collection<ShardingSphereTable> filterByLike(Collection<ShardingSphereTable> tables) {
        Optional<Pattern> likePattern = this.getLikePattern();
        return likePattern.isPresent() ? (Collection)tables.stream().filter(each -> ((Pattern)likePattern.get()).matcher(each.getName()).matches()).collect(Collectors.toList()) : tables;
    }

    private Optional<Pattern> getLikePattern() {
        if (!this.sqlStatement.getFilter().isPresent()) {
            return Optional.empty();
        }
        Optional<String> regex = ((ShowFilterSegment)this.sqlStatement.getFilter().get()).getLike().map(optional -> RegexUtils.convertLikePatternToRegex((String)optional.getPattern()));
        return regex.map(optional -> Pattern.compile(optional, 2));
    }

    private LocalDataQueryResultRow getQueryResultRow(ShardingSphereTable table) {
        return this.sqlStatement.isContainsFull() ? new LocalDataQueryResultRow(new Object[]{table.getName(), table.getType()}) : new LocalDataQueryResultRow(new Object[]{table.getName()});
    }

    @Generated
    public MySQLShowTablesExecutor(MySQLShowTablesStatement sqlStatement) {
        this.sqlStatement = sqlStatement;
    }

    @Generated
    public QueryResultMetaData getQueryResultMetaData() {
        return this.queryResultMetaData;
    }

    @Generated
    public MergedResult getMergedResult() {
        return this.mergedResult;
    }
}

