/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.firebird.packet.handshake;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.firebird.constant.FirebirdArchType;
import org.apache.shardingsphere.database.protocol.firebird.constant.FirebirdAuthenticationMethod;
import org.apache.shardingsphere.database.protocol.firebird.constant.FirebirdUserDataType;
import org.apache.shardingsphere.database.protocol.firebird.constant.protocol.FirebirdProtocol;
import org.apache.shardingsphere.database.protocol.firebird.packet.FirebirdPacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.FirebirdCommandPacketType;
import org.apache.shardingsphere.database.protocol.firebird.payload.FirebirdPacketPayload;

public final class FirebirdConnectPacket
extends FirebirdPacket {
    private final FirebirdCommandPacketType opCode;
    private final int connectVersion;
    private final FirebirdArchType archType;
    private final String database;
    private final int protocolsCount;
    private final Map<FirebirdUserDataType, String> userInfoMap = new EnumMap<FirebirdUserDataType, String>(FirebirdUserDataType.class);
    private final List<FirebirdProtocol> userProtocols = new ArrayList<FirebirdProtocol>();

    public FirebirdConnectPacket(FirebirdPacketPayload payload) {
        this.opCode = FirebirdCommandPacketType.valueOf(payload.readInt4());
        this.connectVersion = payload.readInt4();
        this.archType = FirebirdArchType.valueOf(payload.readInt4());
        this.database = payload.readString();
        this.protocolsCount = payload.readInt4();
        this.parseUserInfo(payload.readBuffer());
        this.parseProtocols(payload.getByteBuf());
    }

    private void parseUserInfo(ByteBuf userInfo) {
        TreeMap<Integer, String> pendingData = new TreeMap<Integer, String>();
        while (userInfo.isReadable()) {
            FirebirdUserDataType type = FirebirdUserDataType.valueOf(userInfo.readUnsignedByte());
            short length = userInfo.readUnsignedByte();
            ByteBuf data = userInfo.readSlice((int)length);
            if (type == FirebirdUserDataType.CNCT_SPECIFIC_DATA) {
                short step = data.readUnsignedByte();
                pendingData.put(Integer.valueOf(step), data.toString(StandardCharsets.US_ASCII));
                continue;
            }
            this.userInfoMap.put(type, data.toString(StandardCharsets.UTF_8));
        }
        if (!pendingData.isEmpty()) {
            this.userInfoMap.put(FirebirdUserDataType.CNCT_SPECIFIC_DATA, String.join((CharSequence)"", pendingData.values()));
        }
    }

    private void parseProtocols(ByteBuf protocolBuf) {
        for (int i = 0; i < this.protocolsCount; ++i) {
            this.userProtocols.add(new FirebirdProtocol(protocolBuf));
        }
    }

    public String getUsername() {
        return this.userInfoMap.get((Object)FirebirdUserDataType.CNCT_USER);
    }

    public String getHost() {
        return this.userInfoMap.get((Object)FirebirdUserDataType.CNCT_HOST);
    }

    public String getLogin() {
        return this.userInfoMap.get((Object)FirebirdUserDataType.CNCT_LOGIN);
    }

    public String getAuthData() {
        return this.userInfoMap.get((Object)FirebirdUserDataType.CNCT_SPECIFIC_DATA);
    }

    public String getPluginName() {
        return this.userInfoMap.get((Object)FirebirdUserDataType.CNCT_PLUGIN_NAME);
    }

    public FirebirdAuthenticationMethod getPlugin() {
        return FirebirdAuthenticationMethod.valueOf(this.getPluginName().toUpperCase());
    }

    @Override
    protected void write(FirebirdPacketPayload payload) {
    }

    @Generated
    public FirebirdCommandPacketType getOpCode() {
        return this.opCode;
    }

    @Generated
    public int getConnectVersion() {
        return this.connectVersion;
    }

    @Generated
    public FirebirdArchType getArchType() {
        return this.archType;
    }

    @Generated
    public String getDatabase() {
        return this.database;
    }

    @Generated
    public int getProtocolsCount() {
        return this.protocolsCount;
    }

    @Generated
    public Map<FirebirdUserDataType, String> getUserInfoMap() {
        return this.userInfoMap;
    }

    @Generated
    public List<FirebirdProtocol> getUserProtocols() {
        return this.userProtocols;
    }
}

