/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.firebird.packet.command.query.statement.prepare;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.firebird.packet.FirebirdPacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.info.FirebirdInfoPacketType;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.info.type.common.FirebirdCommonInfoPacketType;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.info.type.sql.FirebirdSQLInfoPacketType;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.info.type.sql.FirebirdSQLInfoReturnValue;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.statement.prepare.FirebirdReturnColumnPacket;
import org.apache.shardingsphere.database.protocol.firebird.payload.FirebirdPacketPayload;

public final class FirebirdPrepareStatementReturnPacket
extends FirebirdPacket {
    private FirebirdSQLInfoReturnValue type;
    private final List<FirebirdReturnColumnPacket> describeSelect = new ArrayList<FirebirdReturnColumnPacket>();
    private final List<FirebirdReturnColumnPacket> describeBind = new ArrayList<FirebirdReturnColumnPacket>();

    @Override
    protected void write(FirebirdPacketPayload payload) {
        FirebirdPrepareStatementReturnPacket.writeInt(FirebirdSQLInfoPacketType.STMT_TYPE, this.type.getCode(), payload);
        FirebirdPrepareStatementReturnPacket.writeCode(FirebirdSQLInfoPacketType.SELECT, payload);
        FirebirdPrepareStatementReturnPacket.writeInt(FirebirdSQLInfoPacketType.DESCRIBE_VARS, this.describeSelect.size(), payload);
        for (FirebirdReturnColumnPacket column : this.describeSelect) {
            column.write(payload);
        }
        FirebirdPrepareStatementReturnPacket.writeCode(FirebirdSQLInfoPacketType.BIND, payload);
        FirebirdPrepareStatementReturnPacket.writeInt(FirebirdSQLInfoPacketType.DESCRIBE_VARS, this.describeBind.size(), payload);
        for (FirebirdReturnColumnPacket column : this.describeBind) {
            column.write(payload);
        }
        FirebirdPrepareStatementReturnPacket.writeCode(FirebirdCommonInfoPacketType.END, payload);
    }

    static void writeCode(FirebirdInfoPacketType code, FirebirdPacketPayload payload) {
        payload.writeInt1(code.getCode());
    }

    static void writeInt(FirebirdInfoPacketType code, int value, FirebirdPacketPayload payload) {
        payload.writeInt1(code.getCode());
        payload.writeInt2LE(4);
        payload.writeInt4LE(value);
    }

    static void writeString(FirebirdInfoPacketType code, String value, FirebirdPacketPayload payload) {
        payload.writeInt1(code.getCode());
        byte[] valueBytes = null != value ? value.getBytes(payload.getCharset()) : new byte[]{};
        payload.writeInt2LE(valueBytes.length);
        payload.writeBytes(valueBytes);
    }

    @Generated
    public FirebirdPrepareStatementReturnPacket() {
    }

    @Generated
    public FirebirdSQLInfoReturnValue getType() {
        return this.type;
    }

    @Generated
    public List<FirebirdReturnColumnPacket> getDescribeSelect() {
        return this.describeSelect;
    }

    @Generated
    public List<FirebirdReturnColumnPacket> getDescribeBind() {
        return this.describeBind;
    }

    @Generated
    public void setType(FirebirdSQLInfoReturnValue type) {
        this.type = type;
    }
}

