/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.firebird.packet.command.query.statement;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.FirebirdCommandPacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.FirebirdBinaryColumnType;
import org.apache.shardingsphere.database.protocol.firebird.payload.FirebirdPacketPayload;

public final class FirebirdFetchStatementPacket
extends FirebirdCommandPacket {
    private final int statementId;
    private final List<FirebirdBinaryColumnType> parameterTypes;
    private final int message;
    private final int fetchSize;

    public FirebirdFetchStatementPacket(FirebirdPacketPayload payload) {
        payload.skipReserved(4);
        this.statementId = payload.readInt4();
        this.parameterTypes = this.parseBLR(payload.readBuffer());
        this.message = payload.readInt4();
        this.fetchSize = payload.readInt4();
    }

    private List<FirebirdBinaryColumnType> parseBLR(ByteBuf blrBuffer) {
        if (!blrBuffer.isReadable()) {
            return new ArrayList<FirebirdBinaryColumnType>(0);
        }
        blrBuffer.skipBytes(4);
        int length = blrBuffer.readUnsignedByte();
        ArrayList<FirebirdBinaryColumnType> result = new ArrayList<FirebirdBinaryColumnType>((length += 256 * blrBuffer.readUnsignedByte()) / 2);
        short blrType = blrBuffer.readUnsignedByte();
        while (blrType != 255) {
            FirebirdBinaryColumnType type = FirebirdBinaryColumnType.valueOfBLRType(blrType);
            result.add(type);
            blrBuffer.skipBytes(this.getSkipCount(type) + 2);
            blrType = blrBuffer.readUnsignedByte();
        }
        return result;
    }

    private int getSkipCount(FirebirdBinaryColumnType type) {
        switch (type) {
            case VARYING: 
            case TEXT: {
                return 4;
            }
            case NULL: 
            case LEGACY_TEXT: 
            case LEGACY_VARYING: {
                return 2;
            }
            case BLOB: 
            case ARRAY: 
            case LONG: 
            case SHORT: 
            case INT64: 
            case QUAD: 
            case INT128: {
                return 1;
            }
        }
        return 0;
    }

    public static int getLength(FirebirdPacketPayload payload) {
        int length = 8;
        length += payload.getBufferLength(length);
        return length + 8;
    }

    @Override
    protected void write(FirebirdPacketPayload payload) {
    }

    @Generated
    public int getStatementId() {
        return this.statementId;
    }

    @Generated
    public List<FirebirdBinaryColumnType> getParameterTypes() {
        return this.parameterTypes;
    }

    @Generated
    public int getMessage() {
        return this.message;
    }

    @Generated
    public int getFetchSize() {
        return this.fetchSize;
    }
}

