/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.opengauss.command;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.opengauss.packet.command.OpenGaussCommandPacketType;
import org.apache.shardingsphere.database.protocol.opengauss.packet.command.bind.OpenGaussComBatchBindPacket;
import org.apache.shardingsphere.database.protocol.packet.command.CommandPacketType;
import org.apache.shardingsphere.database.protocol.packet.sql.SQLReceivedPacket;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.PostgreSQLCommandPacket;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.PostgreSQLCommandPacketType;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.query.extended.PostgreSQLAggregatedCommandPacket;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.query.extended.bind.PostgreSQLComBindPacket;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.query.extended.close.PostgreSQLComClosePacket;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.query.extended.describe.PostgreSQLComDescribePacket;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.query.extended.execute.PostgreSQLComExecutePacket;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.query.extended.parse.PostgreSQLComParsePacket;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.query.simple.PostgreSQLComQueryPacket;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.frontend.command.executor.CommandExecutor;
import org.apache.shardingsphere.proxy.frontend.opengauss.command.query.extended.bind.OpenGaussComBatchBindExecutor;
import org.apache.shardingsphere.proxy.frontend.opengauss.command.query.simple.OpenGaussComQueryExecutor;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.PortalContext;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.generic.PostgreSQLComTerminationExecutor;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.generic.PostgreSQLUnsupportedCommandExecutor;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.query.extended.PostgreSQLAggregatedBatchedStatementsCommandExecutor;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.query.extended.PostgreSQLAggregatedCommandExecutor;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.query.extended.bind.PostgreSQLComBindExecutor;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.query.extended.close.PostgreSQLComCloseExecutor;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.query.extended.describe.PostgreSQLComDescribeExecutor;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.query.extended.execute.PostgreSQLComExecuteExecutor;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.query.extended.flush.PostgreSQLComFlushExecutor;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.query.extended.parse.PostgreSQLComParseExecutor;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.query.extended.sync.PostgreSQLComSyncExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OpenGaussCommandExecutorFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenGaussCommandExecutorFactory.class);

    public static CommandExecutor newInstance(CommandPacketType commandPacketType, PostgreSQLCommandPacket commandPacket, ConnectionSession connectionSession, PortalContext portalContext) throws SQLException {
        if (commandPacket instanceof SQLReceivedPacket) {
            log.debug("Execute packet type: {}, sql: {}", (Object)commandPacketType, (Object)((SQLReceivedPacket)commandPacket).getSQL());
        } else {
            log.debug("Execute packet type: {}", (Object)commandPacketType);
        }
        if (!(commandPacket instanceof PostgreSQLAggregatedCommandPacket)) {
            return OpenGaussCommandExecutorFactory.getCommandExecutor(commandPacketType, commandPacket, connectionSession, portalContext);
        }
        PostgreSQLAggregatedCommandPacket aggregatedCommandPacket = (PostgreSQLAggregatedCommandPacket)commandPacket;
        if (aggregatedCommandPacket.isContainsBatchedStatements()) {
            if (aggregatedCommandPacket.getPackets().stream().noneMatch(OpenGaussComBatchBindPacket.class::isInstance)) {
                return new PostgreSQLAggregatedCommandExecutor(OpenGaussCommandExecutorFactory.getExecutorsOfAggregatedBatchedStatements(aggregatedCommandPacket, connectionSession, portalContext));
            }
        }
        ArrayList<CommandExecutor> result = new ArrayList<CommandExecutor>(aggregatedCommandPacket.getPackets().size());
        for (PostgreSQLCommandPacket each : aggregatedCommandPacket.getPackets()) {
            result.add(OpenGaussCommandExecutorFactory.getCommandExecutor((CommandPacketType)each.getIdentifier(), each, connectionSession, portalContext));
        }
        return new PostgreSQLAggregatedCommandExecutor(result);
    }

    private static List<CommandExecutor> getExecutorsOfAggregatedBatchedStatements(PostgreSQLAggregatedCommandPacket aggregatedCommandPacket, ConnectionSession connectionSession, PortalContext portalContext) throws SQLException {
        PostgreSQLCommandPacket each;
        int i;
        List packets = aggregatedCommandPacket.getPackets();
        int batchPacketBeginIndex = aggregatedCommandPacket.getBatchPacketBeginIndex();
        int batchPacketEndIndex = aggregatedCommandPacket.getBatchPacketEndIndex();
        ArrayList<CommandExecutor> result = new ArrayList<CommandExecutor>(batchPacketBeginIndex + packets.size() - batchPacketEndIndex);
        for (i = 0; i < batchPacketBeginIndex; ++i) {
            each = (PostgreSQLCommandPacket)packets.get(i);
            result.add(OpenGaussCommandExecutorFactory.getCommandExecutor((CommandPacketType)each.getIdentifier(), each, connectionSession, portalContext));
        }
        result.add((CommandExecutor)new PostgreSQLAggregatedBatchedStatementsCommandExecutor(connectionSession, packets.subList(batchPacketBeginIndex, batchPacketEndIndex + 1)));
        for (i = batchPacketEndIndex + 1; i < packets.size(); ++i) {
            each = (PostgreSQLCommandPacket)packets.get(i);
            result.add(OpenGaussCommandExecutorFactory.getCommandExecutor((CommandPacketType)each.getIdentifier(), each, connectionSession, portalContext));
        }
        return result;
    }

    private static CommandExecutor getCommandExecutor(CommandPacketType commandPacketType, PostgreSQLCommandPacket commandPacket, ConnectionSession connectionSession, PortalContext portalContext) throws SQLException {
        if (OpenGaussCommandPacketType.BATCH_BIND_COMMAND == commandPacketType) {
            return new OpenGaussComBatchBindExecutor((OpenGaussComBatchBindPacket)commandPacket, connectionSession);
        }
        switch ((PostgreSQLCommandPacketType)commandPacketType) {
            case SIMPLE_QUERY: {
                return new OpenGaussComQueryExecutor(portalContext, (PostgreSQLComQueryPacket)commandPacket, connectionSession);
            }
            case PARSE_COMMAND: {
                return new PostgreSQLComParseExecutor((PostgreSQLComParsePacket)commandPacket, connectionSession);
            }
            case BIND_COMMAND: {
                return new PostgreSQLComBindExecutor(portalContext, (PostgreSQLComBindPacket)commandPacket, connectionSession);
            }
            case DESCRIBE_COMMAND: {
                return new PostgreSQLComDescribeExecutor(portalContext, (PostgreSQLComDescribePacket)commandPacket, connectionSession);
            }
            case EXECUTE_COMMAND: {
                return new PostgreSQLComExecuteExecutor(portalContext, (PostgreSQLComExecutePacket)commandPacket);
            }
            case SYNC_COMMAND: {
                return new PostgreSQLComSyncExecutor(connectionSession);
            }
            case CLOSE_COMMAND: {
                return new PostgreSQLComCloseExecutor(portalContext, (PostgreSQLComClosePacket)commandPacket, connectionSession);
            }
            case FLUSH_COMMAND: {
                return new PostgreSQLComFlushExecutor();
            }
            case TERMINATE: {
                return new PostgreSQLComTerminationExecutor();
            }
        }
        return new PostgreSQLUnsupportedCommandExecutor();
    }

    @Generated
    private OpenGaussCommandExecutorFactory() {
    }
}

