/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.job.progress.yaml.swapper;

import java.util.stream.Collectors;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.position.yaml.YamlTableCheckRangePositionSwapper;
import org.apache.shardingsphere.data.pipeline.core.job.JobStatus;
import org.apache.shardingsphere.data.pipeline.core.job.progress.ConsistencyCheckJobItemProgress;
import org.apache.shardingsphere.data.pipeline.core.job.progress.yaml.config.YamlConsistencyCheckJobItemProgress;
import org.apache.shardingsphere.data.pipeline.core.job.progress.yaml.swapper.YamlPipelineJobItemProgressSwapper;

public final class YamlConsistencyCheckJobItemProgressSwapper
implements YamlPipelineJobItemProgressSwapper<YamlConsistencyCheckJobItemProgress, ConsistencyCheckJobItemProgress> {
    private final YamlTableCheckRangePositionSwapper tableCheckPositionSwapper = new YamlTableCheckRangePositionSwapper();

    public YamlConsistencyCheckJobItemProgress swapToYamlConfiguration(ConsistencyCheckJobItemProgress data) {
        YamlConsistencyCheckJobItemProgress result = new YamlConsistencyCheckJobItemProgress();
        result.setStatus(data.getStatus().name());
        result.setTableNames(data.getTableNames());
        result.setIgnoredTableNames(data.getIgnoredTableNames());
        result.setCheckedRecordsCount(data.getCheckedRecordsCount());
        result.setRecordsCount(data.getRecordsCount());
        result.setCheckBeginTimeMillis(data.getCheckBeginTimeMillis());
        result.setCheckEndTimeMillis(data.getCheckEndTimeMillis());
        result.setTableCheckRangePositions(data.getTableCheckRangePositions().stream().map(this.tableCheckPositionSwapper::swapToYamlConfiguration).collect(Collectors.toList()));
        result.setSourceDatabaseType(data.getSourceDatabaseType());
        return result;
    }

    public ConsistencyCheckJobItemProgress swapToObject(YamlConsistencyCheckJobItemProgress yamlConfig) {
        ConsistencyCheckJobItemProgress result = new ConsistencyCheckJobItemProgress(yamlConfig.getTableNames(), yamlConfig.getIgnoredTableNames(), yamlConfig.getCheckedRecordsCount(), yamlConfig.getRecordsCount(), yamlConfig.getCheckBeginTimeMillis(), yamlConfig.getCheckEndTimeMillis(), yamlConfig.getSourceDatabaseType());
        if (null != yamlConfig.getTableCheckRangePositions()) {
            result.getTableCheckRangePositions().addAll(yamlConfig.getTableCheckRangePositions().stream().map(this.tableCheckPositionSwapper::swapToObject).collect(Collectors.toList()));
        }
        result.setStatus(JobStatus.valueOf(yamlConfig.getStatus()));
        return result;
    }

    @Override
    public Class<YamlConsistencyCheckJobItemProgress> getYamlProgressClass() {
        return YamlConsistencyCheckJobItemProgress.class;
    }
}

