/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.ingest.position.type.pk;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.math.BigInteger;
import java.util.Base64;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.query.Range;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.IngestPosition;

public final class UniqueKeyIngestPosition<T>
implements IngestPosition {
    private final char type;
    private final Range<T> range;

    public static <T> UniqueKeyIngestPosition<?> newInstance(Range<T> range) {
        T lowerBound = range.getLowerBound();
        T upperBound = range.getUpperBound();
        if (lowerBound instanceof Number) {
            BigInteger lower = UniqueKeyIngestPosition.convertToBigInteger((Number)lowerBound);
            BigInteger upper = null == upperBound ? null : UniqueKeyIngestPosition.convertToBigInteger((Number)upperBound);
            return UniqueKeyIngestPosition.ofInteger(range.isLowerInclusive() ? Range.closed(lower, upper) : Range.openClosed(lower, upper));
        }
        if (lowerBound instanceof CharSequence) {
            String lower = lowerBound.toString();
            String upper = null == upperBound ? null : upperBound.toString();
            return UniqueKeyIngestPosition.ofString(range.isLowerInclusive() ? Range.closed(lower, upper) : Range.openClosed(lower, upper));
        }
        if (lowerBound instanceof byte[]) {
            byte[] lower = (byte[])lowerBound;
            byte[] upper = (byte[])upperBound;
            return UniqueKeyIngestPosition.ofBinary(range.isLowerInclusive() ? Range.closed(lower, upper) : Range.openClosed(lower, upper));
        }
        return UniqueKeyIngestPosition.ofUnsplit();
    }

    private static BigInteger convertToBigInteger(Number number) {
        if (number instanceof BigInteger) {
            return (BigInteger)number;
        }
        return BigInteger.valueOf(number.longValue());
    }

    public static UniqueKeyIngestPosition<BigInteger> ofInteger(Range<BigInteger> range) {
        return new UniqueKeyIngestPosition<BigInteger>('i', range);
    }

    public static UniqueKeyIngestPosition<String> ofString(Range<String> range) {
        return new UniqueKeyIngestPosition<String>('s', range);
    }

    public static UniqueKeyIngestPosition<byte[]> ofBinary(Range<byte[]> range) {
        return new UniqueKeyIngestPosition<byte[]>('b', range);
    }

    public static UniqueKeyIngestPosition<Void> ofUnsplit() {
        return new UniqueKeyIngestPosition<Object>('u', Range.closed(null, null));
    }

    public static UniqueKeyIngestPosition<?> decode(String text) {
        List parts = Splitter.on((char)',').splitToList((CharSequence)text);
        Preconditions.checkArgument((3 == parts.size() ? 1 : 0) != 0, (Object)("Unknown unique key position: " + text));
        Preconditions.checkArgument((1 == ((String)parts.get(0)).length() ? 1 : 0) != 0, (Object)("Invalid unique key position type: " + (String)parts.get(0)));
        char type = ((String)parts.get(0)).charAt(0);
        String lowerBound = (String)parts.get(1);
        String upperBound = (String)parts.get(2);
        switch (type) {
            case 'i': {
                BigInteger lower = Strings.isNullOrEmpty((String)lowerBound) ? null : new BigInteger(lowerBound);
                BigInteger upper = Strings.isNullOrEmpty((String)upperBound) ? null : new BigInteger(upperBound);
                return UniqueKeyIngestPosition.ofInteger(Range.closed(lower, upper));
            }
            case 's': {
                return UniqueKeyIngestPosition.ofString(Range.closed(lowerBound, upperBound));
            }
            case 'b': {
                byte[] lowerBytes = Strings.isNullOrEmpty((String)lowerBound) ? null : Base64.getDecoder().decode(lowerBound);
                byte[] upperBytes = Strings.isNullOrEmpty((String)upperBound) ? null : Base64.getDecoder().decode(upperBound);
                return UniqueKeyIngestPosition.ofBinary(Range.closed(lowerBytes, upperBytes));
            }
            case 'u': {
                return UniqueKeyIngestPosition.ofUnsplit();
            }
        }
        throw new IllegalArgumentException("Unknown unique key position type: " + type);
    }

    public String encode() {
        String encodedUpperBound;
        String encodedLowerBound;
        T lowerBound = this.getLowerBound();
        T upperBound = this.getUpperBound();
        switch (this.getType()) {
            case 'i': 
            case 's': 
            case 'u': {
                encodedLowerBound = null == lowerBound ? "" : lowerBound.toString();
                encodedUpperBound = null == upperBound ? "" : upperBound.toString();
                break;
            }
            case 'b': {
                encodedLowerBound = null == lowerBound ? "" : Base64.getEncoder().encodeToString((byte[])lowerBound);
                encodedUpperBound = null == upperBound ? "" : Base64.getEncoder().encodeToString((byte[])upperBound);
                break;
            }
            default: {
                throw new RuntimeException("Unknown unique key position type: " + this.getType());
            }
        }
        return String.format("%s,%s,%s", Character.valueOf(this.getType()), encodedLowerBound, encodedUpperBound);
    }

    public T getLowerBound() {
        return this.range.getLowerBound();
    }

    public T getUpperBound() {
        return this.range.getUpperBound();
    }

    public String toString() {
        return this.encode();
    }

    @Generated
    private UniqueKeyIngestPosition(char type, Range<T> range) {
        this.type = type;
        this.range = range;
    }

    @Generated
    public char getType() {
        return this.type;
    }
}

