/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.query.calculator;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.datasource.PipelineDataSource;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.query.QueryType;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.query.Range;
import org.apache.shardingsphere.data.pipeline.core.metadata.model.PipelineColumnMetaData;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedTable;

public final class TableInventoryCalculateParameter {
    private final PipelineDataSource dataSource;
    private final QualifiedTable table;
    private final List<String> columnNames;
    private final List<PipelineColumnMetaData> uniqueKeys;
    private final AtomicReference<AutoCloseable> calculationContext = new AtomicReference();
    private final AtomicReference<Collection<Object>> uniqueKeysValues = new AtomicReference();
    private final AtomicReference<Range<?>> uniqueKeysValuesRange = new AtomicReference();
    private final AtomicReference<List<String>> shardingColumnsNames = new AtomicReference();
    private final AtomicReference<List<Object>> shardingColumnsValues = new AtomicReference();
    private final QueryType queryType;
    private final String queryCondition;

    public DatabaseType getDatabaseType() {
        return this.dataSource.getDatabaseType();
    }

    public PipelineColumnMetaData getFirstUniqueKey() {
        return this.uniqueKeys.get(0);
    }

    public AutoCloseable getCalculationContext() {
        return this.calculationContext.get();
    }

    public void setCalculationContext(AutoCloseable calculationContext) {
        this.calculationContext.set(calculationContext);
    }

    public List<String> getUniqueKeysNames() {
        return this.uniqueKeys.stream().map(PipelineColumnMetaData::getName).collect(Collectors.toList());
    }

    public Collection<Object> getUniqueKeysValues() {
        return this.uniqueKeysValues.get();
    }

    public void setUniqueKeysValues(Collection<Object> uniqueKeysValues) {
        this.uniqueKeysValues.set(uniqueKeysValues);
    }

    public Range<?> getRange() {
        return this.uniqueKeysValuesRange.get();
    }

    public void setRange(Range<?> range) {
        this.uniqueKeysValuesRange.set(range);
    }

    public List<String> getShardingColumnsNames() {
        return Optional.ofNullable(this.shardingColumnsNames.get()).orElse(Collections.emptyList());
    }

    public void setShardingColumnsNames(List<String> shardingColumnsNames) {
        this.shardingColumnsNames.set(shardingColumnsNames);
    }

    public List<Object> getShardingColumnsValues() {
        return Optional.ofNullable(this.shardingColumnsValues.get()).orElse(Collections.emptyList());
    }

    public void setShardingColumnsValues(List<Object> shardingColumnsValues) {
        this.shardingColumnsValues.set(shardingColumnsValues);
    }

    @Generated
    public TableInventoryCalculateParameter(PipelineDataSource dataSource, QualifiedTable table, List<String> columnNames, List<PipelineColumnMetaData> uniqueKeys, QueryType queryType, String queryCondition) {
        this.dataSource = dataSource;
        this.table = table;
        this.columnNames = columnNames;
        this.uniqueKeys = uniqueKeys;
        this.queryType = queryType;
        this.queryCondition = queryCondition;
    }

    @Generated
    public PipelineDataSource getDataSource() {
        return this.dataSource;
    }

    @Generated
    public QualifiedTable getTable() {
        return this.table;
    }

    @Generated
    public List<String> getColumnNames() {
        return this.columnNames;
    }

    @Generated
    public List<PipelineColumnMetaData> getUniqueKeys() {
        return this.uniqueKeys;
    }

    @Generated
    public AtomicReference<Range<?>> getUniqueKeysValuesRange() {
        return this.uniqueKeysValuesRange;
    }

    @Generated
    public QueryType getQueryType() {
        return this.queryType;
    }

    @Generated
    public String getQueryCondition() {
        return this.queryCondition;
    }
}

