/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.distsql.handler.transmission.update;

import org.apache.shardingsphere.data.pipeline.core.channel.PipelineChannelCreator;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContextKey;
import org.apache.shardingsphere.data.pipeline.core.exception.param.PipelineInvalidParameterException;
import org.apache.shardingsphere.data.pipeline.core.job.progress.config.PipelineProcessConfiguration;
import org.apache.shardingsphere.data.pipeline.core.job.progress.config.PipelineReadConfiguration;
import org.apache.shardingsphere.data.pipeline.core.job.progress.config.PipelineWriteConfiguration;
import org.apache.shardingsphere.data.pipeline.core.job.type.PipelineJobType;
import org.apache.shardingsphere.data.pipeline.core.metadata.PipelineProcessConfigurationPersistService;
import org.apache.shardingsphere.data.pipeline.distsql.statement.updatable.AlterTransmissionRuleStatement;
import org.apache.shardingsphere.distsql.handler.engine.update.DistSQLUpdateExecutor;
import org.apache.shardingsphere.distsql.segment.AlgorithmSegment;
import org.apache.shardingsphere.distsql.segment.ReadOrWriteSegment;
import org.apache.shardingsphere.distsql.segment.TransmissionRuleSegment;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.instance.metadata.InstanceType;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.mode.manager.ContextManager;

public final class AlterTransmissionRuleExecutor
implements DistSQLUpdateExecutor<AlterTransmissionRuleStatement> {
    private final PipelineProcessConfigurationPersistService processConfigPersistService = new PipelineProcessConfigurationPersistService();

    public void executeUpdate(AlterTransmissionRuleStatement sqlStatement, ContextManager contextManager) {
        PipelineProcessConfiguration processConfig = this.convertToProcessConfiguration(sqlStatement.getProcessConfigSegment());
        AlgorithmConfiguration streamChannel = processConfig.getStreamChannel();
        if (null != streamChannel && !TypedSPILoader.findService(PipelineChannelCreator.class, (Object)streamChannel.getType()).isPresent()) {
            throw new PipelineInvalidParameterException("Unknown stream channel type `" + streamChannel.getType() + "`.");
        }
        String jobType = ((PipelineJobType)TypedSPILoader.getService(PipelineJobType.class, (Object)sqlStatement.getJobTypeName())).getType();
        this.processConfigPersistService.persist(new PipelineContextKey(InstanceType.PROXY), jobType, processConfig);
    }

    private PipelineProcessConfiguration convertToProcessConfiguration(TransmissionRuleSegment segment) {
        return new PipelineProcessConfiguration(this.convertToReadConfiguration(segment.getReadSegment()), this.convertToWriteConfiguration(segment.getWriteSegment()), this.convertToAlgorithm(segment.getStreamChannel()));
    }

    private PipelineReadConfiguration convertToReadConfiguration(ReadOrWriteSegment readSegment) {
        return null == readSegment ? null : new PipelineReadConfiguration(readSegment.getWorkerThread(), readSegment.getBatchSize(), readSegment.getShardingSize(), this.convertToAlgorithm(readSegment.getRateLimiter()));
    }

    private PipelineWriteConfiguration convertToWriteConfiguration(ReadOrWriteSegment writeSegment) {
        return null == writeSegment ? null : new PipelineWriteConfiguration(writeSegment.getWorkerThread(), writeSegment.getBatchSize(), this.convertToAlgorithm(writeSegment.getRateLimiter()));
    }

    private AlgorithmConfiguration convertToAlgorithm(AlgorithmSegment algorithmSegment) {
        return null == algorithmSegment ? null : new AlgorithmConfiguration(algorithmSegment.getName(), algorithmSegment.getProps());
    }

    public Class<AlterTransmissionRuleStatement> getType() {
        return AlterTransmissionRuleStatement.class;
    }
}

