/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.AttributeMap;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.shardingsphere.authentication.result.AuthenticationResult;
import org.apache.shardingsphere.database.protocol.constant.CommonConstants;
import org.apache.shardingsphere.infra.executor.sql.process.Process;
import org.apache.shardingsphere.infra.executor.sql.process.ProcessEngine;
import org.apache.shardingsphere.infra.executor.sql.process.ProcessRegistry;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.infra.session.connection.ConnectionContext;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.frontend.exception.ExpectedExceptions;
import org.apache.shardingsphere.proxy.frontend.executor.ConnectionThreadExecutorGroup;
import org.apache.shardingsphere.proxy.frontend.executor.UserExecutorGroup;
import org.apache.shardingsphere.proxy.frontend.spi.DatabaseProtocolFrontendEngine;
import org.apache.shardingsphere.proxy.frontend.state.ProxyStateContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FrontendChannelInboundHandler
extends ChannelInboundHandlerAdapter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FrontendChannelInboundHandler.class);
    private final DatabaseProtocolFrontendEngine databaseProtocolFrontendEngine;
    private final ConnectionSession connectionSession;
    private final ProcessEngine processEngine = new ProcessEngine();
    private final AtomicBoolean authenticated = new AtomicBoolean(false);

    public FrontendChannelInboundHandler(DatabaseProtocolFrontendEngine databaseProtocolFrontendEngine, Channel channel) {
        this.databaseProtocolFrontendEngine = databaseProtocolFrontendEngine;
        this.connectionSession = new ConnectionSession(databaseProtocolFrontendEngine.getType(), (AttributeMap)channel);
    }

    public void channelActive(ChannelHandlerContext context) {
        int connectionId = this.databaseProtocolFrontendEngine.getAuthenticationEngine().handshake(context);
        ConnectionThreadExecutorGroup.getInstance().register(connectionId);
        this.connectionSession.setConnectionId(connectionId);
    }

    public void channelRead(ChannelHandlerContext context, Object message) {
        if (!this.authenticated.get()) {
            this.authenticated.set(this.authenticate(context, (ByteBuf)message));
            return;
        }
        ProxyStateContext.execute(context, message, this.databaseProtocolFrontendEngine, this.connectionSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean authenticate(ChannelHandlerContext context, ByteBuf message) {
        try {
            AuthenticationResult authResult = this.databaseProtocolFrontendEngine.getAuthenticationEngine().authenticate(context, this.databaseProtocolFrontendEngine.getCodecEngine().createPacketPayload(message, (Charset)context.channel().attr(CommonConstants.CHARSET_ATTRIBUTE_KEY).get()));
            if (authResult.isFinished()) {
                this.connectionSession.setGrantee(new Grantee(authResult.getUsername(), authResult.getHostname()));
                this.connectionSession.setCurrentDatabaseName(authResult.getDatabase());
                this.connectionSession.setProcessId(this.processEngine.connect(this.connectionSession.getUsedDatabaseName(), this.connectionSession.getConnectionContext().getGrantee()));
            }
            boolean bl = authResult.isFinished();
            return bl;
        }
        catch (Exception ex) {
            if (ExpectedExceptions.isExpected(ex.getClass())) {
                log.debug("Exception occur: ", (Throwable)ex);
            } else {
                log.error("Exception occur: ", (Throwable)ex);
            }
            context.writeAndFlush((Object)this.databaseProtocolFrontendEngine.getCommandExecuteEngine().getErrorPacket(ex));
            context.close();
        }
        finally {
            message.release();
        }
        return false;
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object event) throws Exception {
        if (event instanceof IdleStateEvent) {
            if (this.isIdle()) {
                ConnectionContext connectionContext = this.connectionSession.getConnectionContext();
                Grantee grantee = null == connectionContext ? null : connectionContext.getGrantee();
                String databaseName = null == connectionContext ? null : connectionContext.getCurrentDatabaseName().orElse("NONE");
                log.info("Connection {} (processId: {}) will be closed due to receiving an IdleStateEvent as it is idle. Grantee: {}, database name: {}", new Object[]{this.connectionSession.getConnectionId(), this.connectionSession.getProcessId(), grantee, databaseName});
                ctx.close();
            } else {
                log.info("Received IdleStateEvent, but connection {} (processId: {}) is not idle, ignore.", (Object)this.connectionSession.getConnectionId(), (Object)this.connectionSession.getProcessId());
            }
        }
        super.userEventTriggered(ctx, event);
    }

    private boolean isIdle() {
        if (null == this.connectionSession.getProcessId()) {
            return true;
        }
        Process process = ProcessRegistry.getInstance().get(this.connectionSession.getProcessId());
        return null == process || process.isIdle();
    }

    public void channelInactive(ChannelHandlerContext context) {
        context.fireChannelInactive();
        UserExecutorGroup.getInstance().getExecutorService().execute(this::closeAllResources);
    }

    private void closeAllResources() {
        ConnectionThreadExecutorGroup.getInstance().unregisterAndAwaitTermination(this.connectionSession.getConnectionId());
        this.processCloseExceptions(this.connectionSession.getDatabaseConnectionManager().closeAllResources());
        Optional.ofNullable(this.connectionSession.getProcessId()).ifPresent(arg_0 -> ((ProcessEngine)this.processEngine).disconnect(arg_0));
        this.databaseProtocolFrontendEngine.release(this.connectionSession);
    }

    private void processCloseExceptions(Collection<SQLException> exceptions) {
        if (exceptions.isEmpty()) {
            return;
        }
        SQLException ex = new SQLException("");
        for (SQLException each : exceptions) {
            ex.setNextException(each);
        }
        this.processException(ex);
    }

    private void processException(Exception cause) {
        if (ExpectedExceptions.isExpected(cause.getClass())) {
            log.debug("Exception occur: ", (Throwable)cause);
        } else {
            log.error("Exception occur: ", (Throwable)cause);
        }
    }

    public void channelWritabilityChanged(ChannelHandlerContext context) {
        if (context.channel().isWritable()) {
            this.connectionSession.getDatabaseConnectionManager().getConnectionResourceLock().doNotify();
        }
    }
}

