/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.command;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.database.exception.core.exception.SQLDialectException;
import org.apache.shardingsphere.database.protocol.constant.CommonConstants;
import org.apache.shardingsphere.database.protocol.packet.command.CommandPacket;
import org.apache.shardingsphere.database.protocol.packet.command.CommandPacketType;
import org.apache.shardingsphere.database.protocol.payload.PacketPayload;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.exception.external.sql.ShardingSphereSQLException;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.exception.BackendConnectionException;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.frontend.command.CommandExecuteEngine;
import org.apache.shardingsphere.proxy.frontend.command.executor.CommandExecutor;
import org.apache.shardingsphere.proxy.frontend.command.executor.QueryCommandExecutor;
import org.apache.shardingsphere.proxy.frontend.event.WriteCompleteEvent;
import org.apache.shardingsphere.proxy.frontend.exception.ExpectedExceptions;
import org.apache.shardingsphere.proxy.frontend.spi.DatabaseProtocolFrontendEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public final class CommandExecutorTask
implements Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CommandExecutorTask.class);
    private final DatabaseProtocolFrontendEngine databaseProtocolFrontendEngine;
    private final ConnectionSession connectionSession;
    private final ChannelHandlerContext context;
    private final Object message;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean isNeedFlush = false;
        boolean sqlShowEnabled = (Boolean)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.SQL_SHOW);
        try {
            if (sqlShowEnabled) {
                this.fillLogMDC();
            }
            isNeedFlush = this.executeCommand(this.context, this.databaseProtocolFrontendEngine.getCodecEngine().createPacketPayload((ByteBuf)this.message, (Charset)this.context.channel().attr(CommonConstants.CHARSET_ATTRIBUTE_KEY).get()));
        }
        catch (Exception ex) {
            this.processException(ex);
        }
        catch (Error error) {
            this.processException(new RuntimeException(error));
        }
        finally {
            this.connectionSession.clearQueryContext();
            Collection<SQLException> exceptions = Collections.emptyList();
            try {
                this.connectionSession.getDatabaseConnectionManager().closeExecutionResources();
            }
            catch (BackendConnectionException ex) {
                exceptions = ex.getExceptions().stream().filter(SQLException.class::isInstance).map(SQLException.class::cast).collect(Collectors.toList());
            }
            if (isNeedFlush) {
                this.context.flush();
            }
            this.processClosedExceptions(exceptions);
            this.context.pipeline().fireUserEventTriggered((Object)new WriteCompleteEvent());
            if (sqlShowEnabled) {
                this.clearLogMDC();
            }
            if (this.message instanceof CompositeByteBuf) {
                this.releaseCompositeByteBuf((CompositeByteBuf)this.message);
            }
            ((ByteBuf)this.message).release();
        }
    }

    private void fillLogMDC() {
        MDC.put((String)"database", (String)this.connectionSession.getUsedDatabaseName());
        MDC.put((String)"user", (String)this.connectionSession.getConnectionContext().getGrantee().toString());
    }

    private boolean executeCommand(ChannelHandlerContext context, PacketPayload payload) throws SQLException {
        CommandExecuteEngine commandExecuteEngine = this.databaseProtocolFrontendEngine.getCommandExecuteEngine();
        CommandPacketType type = commandExecuteEngine.getCommandPacketType(payload);
        CommandPacket commandPacket = commandExecuteEngine.getCommandPacket(payload, type, this.connectionSession);
        CommandExecutor commandExecutor = commandExecuteEngine.getCommandExecutor(type, commandPacket, this.connectionSession);
        return this.doExecuteCommand(context, commandExecuteEngine, commandExecutor);
    }

    private boolean doExecuteCommand(ChannelHandlerContext context, CommandExecuteEngine commandExecuteEngine, CommandExecutor commandExecutor) throws SQLException {
        try {
            Collection responsePackets = commandExecutor.execute();
            if (responsePackets.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            responsePackets.forEach(arg_0 -> ((ChannelHandlerContext)context).write(arg_0));
            if (commandExecutor instanceof QueryCommandExecutor) {
                commandExecuteEngine.writeQueryData(context, this.connectionSession.getDatabaseConnectionManager(), (QueryCommandExecutor)commandExecutor, responsePackets.size());
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException | SQLDialectException | ShardingSphereSQLException ex) {
            this.databaseProtocolFrontendEngine.handleException(this.connectionSession, (Exception)ex);
            throw ex;
        }
        finally {
            commandExecutor.close();
        }
    }

    private void processException(Exception cause) {
        if (ExpectedExceptions.isExpected(cause.getClass())) {
            log.debug("Exception occur: ", (Throwable)cause);
        } else {
            log.error("Exception occur: ", (Throwable)cause);
        }
        this.context.write((Object)this.databaseProtocolFrontendEngine.getCommandExecuteEngine().getErrorPacket(cause));
        this.databaseProtocolFrontendEngine.getCommandExecuteEngine().getOtherPacket(this.connectionSession).ifPresent(arg_0 -> ((ChannelHandlerContext)this.context).write(arg_0));
        this.context.flush();
    }

    private void processClosedExceptions(Collection<SQLException> exceptions) {
        if (exceptions.isEmpty()) {
            return;
        }
        SQLException ex = new SQLException("");
        for (SQLException each : exceptions) {
            ex.setNextException(each);
        }
        this.processException(ex);
    }

    private void clearLogMDC() {
        MDC.clear();
    }

    private void releaseCompositeByteBuf(CompositeByteBuf compositeByteBuf) {
        int remainBytes = compositeByteBuf.readableBytes();
        if (remainBytes > 0) {
            compositeByteBuf.skipBytes(remainBytes);
        }
        compositeByteBuf.discardReadComponents();
    }

    @Generated
    public CommandExecutorTask(DatabaseProtocolFrontendEngine databaseProtocolFrontendEngine, ConnectionSession connectionSession, ChannelHandlerContext context, Object message) {
        this.databaseProtocolFrontendEngine = databaseProtocolFrontendEngine;
        this.connectionSession = connectionSession;
        this.context = context;
        this.message = message;
    }
}

