/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.globalclock.executor;

import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Optional;
import org.apache.shardingsphere.database.connector.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.globalclock.executor.GlobalClockTransactionExecutor;
import org.apache.shardingsphere.globalclock.provider.GlobalClockProvider;
import org.apache.shardingsphere.globalclock.rule.GlobalClockRule;
import org.apache.shardingsphere.infra.session.connection.transaction.TransactionConnectionContext;
import org.apache.shardingsphere.sql.parser.statement.core.enums.TransactionIsolationLevel;
import org.apache.shardingsphere.transaction.spi.TransactionHook;

public final class GlobalClockTransactionHook
implements TransactionHook<GlobalClockRule> {
    public void beforeBegin(GlobalClockRule rule, DatabaseType databaseType, TransactionConnectionContext transactionContext) {
    }

    public void afterBegin(GlobalClockRule rule, DatabaseType databaseType, TransactionConnectionContext transactionContext) {
        rule.getGlobalClockProvider().ifPresent(optional -> transactionContext.setBeginMillis(optional.getCurrentTimestamp()));
    }

    public void afterCreateConnections(GlobalClockRule rule, DatabaseType databaseType, Collection<Connection> connections, TransactionConnectionContext transactionContext) throws SQLException {
        if (!rule.getConfiguration().isEnabled()) {
            return;
        }
        Optional globalClockTransactionExecutor = DatabaseTypedSPILoader.findService(GlobalClockTransactionExecutor.class, (DatabaseType)databaseType);
        if (globalClockTransactionExecutor.isPresent()) {
            ((GlobalClockTransactionExecutor)globalClockTransactionExecutor.get()).sendSnapshotTimestamp(connections, transactionContext.getBeginMillis());
        }
    }

    public void beforeExecuteSQL(GlobalClockRule rule, DatabaseType databaseType, Collection<Connection> connections, TransactionConnectionContext connectionContext, TransactionIsolationLevel isolationLevel) throws SQLException {
        if (!rule.getConfiguration().isEnabled() || null != isolationLevel && TransactionIsolationLevel.READ_COMMITTED != isolationLevel) {
            return;
        }
        Optional globalClockTransactionExecutor = DatabaseTypedSPILoader.findService(GlobalClockTransactionExecutor.class, (DatabaseType)databaseType);
        if (!globalClockTransactionExecutor.isPresent()) {
            return;
        }
        Optional<GlobalClockProvider> globalClockProvider = rule.getGlobalClockProvider();
        Preconditions.checkState((boolean)globalClockProvider.isPresent());
        ((GlobalClockTransactionExecutor)globalClockTransactionExecutor.get()).sendSnapshotTimestamp(connections, globalClockProvider.get().getCurrentTimestamp());
    }

    public void beforeCommit(GlobalClockRule rule, DatabaseType databaseType, Collection<Connection> connections, TransactionConnectionContext transactionContext) throws SQLException {
        if (!rule.getConfiguration().isEnabled()) {
            return;
        }
        Optional globalClockTransactionExecutor = DatabaseTypedSPILoader.findService(GlobalClockTransactionExecutor.class, (DatabaseType)databaseType);
        Preconditions.checkArgument((boolean)globalClockTransactionExecutor.isPresent());
        Optional<GlobalClockProvider> globalClockProvider = rule.getGlobalClockProvider();
        Preconditions.checkState((boolean)globalClockProvider.isPresent());
        ((GlobalClockTransactionExecutor)globalClockTransactionExecutor.get()).sendCommitTimestamp(connections, globalClockProvider.get().getCurrentTimestamp());
    }

    public void afterCommit(GlobalClockRule rule, DatabaseType databaseType, Collection<Connection> connections, TransactionConnectionContext transactionContext) {
        if (!rule.getConfiguration().isEnabled()) {
            return;
        }
        Optional<GlobalClockProvider> globalClockProvider = rule.getGlobalClockProvider();
        Preconditions.checkState((boolean)globalClockProvider.isPresent());
        globalClockProvider.get().getNextTimestamp();
    }

    public boolean isNeedLockWhenCommit(GlobalClockRule rule) {
        return rule.getConfiguration().isEnabled();
    }

    public void beforeRollback(GlobalClockRule rule, DatabaseType databaseType, Collection<Connection> connections, TransactionConnectionContext transactionContext) {
    }

    public void afterRollback(GlobalClockRule rule, DatabaseType databaseType, Collection<Connection> connections, TransactionConnectionContext transactionContext) {
    }

    public int getOrder() {
        return 1300;
    }

    public Class<GlobalClockRule> getTypeClass() {
        return GlobalClockRule.class;
    }
}

