/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mask.algorithm;

import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.infra.algorithm.core.ShardingSphereAlgorithm;
import org.apache.shardingsphere.infra.algorithm.core.exception.AlgorithmInitializationException;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.mask.spi.MaskAlgorithm;

public final class MaskAlgorithmPropertiesChecker {
    public static void checkSingleChar(Properties props, String propKey, MaskAlgorithm<?, ?> algorithm) {
        MaskAlgorithmPropertiesChecker.checkRequired(props, propKey, algorithm);
        ShardingSpherePreconditions.checkState((1 == props.getProperty(propKey).length() ? 1 : 0) != 0, () -> new AlgorithmInitializationException((ShardingSphereAlgorithm)algorithm, "%s's length must be one", new Object[]{propKey}));
    }

    public static void checkAtLeastOneChar(Properties props, String propKey, MaskAlgorithm<?, ?> algorithm) {
        MaskAlgorithmPropertiesChecker.checkRequired(props, propKey, algorithm);
        ShardingSpherePreconditions.checkNotEmpty((String)props.getProperty(propKey), () -> new AlgorithmInitializationException((ShardingSphereAlgorithm)algorithm, "%s's length must be at least one", new Object[]{propKey}));
    }

    public static void checkPositiveInteger(Properties props, String propKey, MaskAlgorithm<?, ?> algorithm) {
        MaskAlgorithmPropertiesChecker.checkRequired(props, propKey, algorithm);
        try {
            int integerValue = Integer.parseInt(props.getProperty(propKey));
            ShardingSpherePreconditions.checkState((integerValue > 0 ? 1 : 0) != 0, () -> new AlgorithmInitializationException((ShardingSphereAlgorithm)algorithm, "%s must be a positive integer.", new Object[]{propKey}));
        }
        catch (NumberFormatException ex) {
            throw new AlgorithmInitializationException(algorithm, "%s must be a valid integer number", new Object[]{propKey});
        }
    }

    private static void checkRequired(Properties props, String requiredPropKey, MaskAlgorithm<?, ?> algorithm) {
        ShardingSpherePreconditions.checkContainsKey((Map)props, (Object)requiredPropKey, () -> new AlgorithmInitializationException((ShardingSphereAlgorithm)algorithm, "%s is required", new Object[]{requiredPropKey}));
    }

    @Generated
    private MaskAlgorithmPropertiesChecker() {
    }
}

