/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.engine.opengauss.visitor.statement.type;

import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.statement.type.TCLStatementVisitor;
import org.apache.shardingsphere.sql.parser.autogen.OpenGaussStatementParser;
import org.apache.shardingsphere.sql.parser.engine.opengauss.visitor.statement.OpenGaussStatementVisitor;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.BeginTransactionStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.CommitStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.ReleaseSavepointStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.RollbackStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.SavepointStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.SetConstraintsStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.SetTransactionStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.StartTransactionStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.xa.XACommitStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.xa.XARollbackStatement;

public final class OpenGaussTCLStatementVisitor
extends OpenGaussStatementVisitor
implements TCLStatementVisitor {
    public OpenGaussTCLStatementVisitor(DatabaseType databaseType) {
        super(databaseType);
    }

    @Override
    public ASTNode visitSetTransaction(OpenGaussStatementParser.SetTransactionContext ctx) {
        return new SetTransactionStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitBeginTransaction(OpenGaussStatementParser.BeginTransactionContext ctx) {
        return new BeginTransactionStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCommit(OpenGaussStatementParser.CommitContext ctx) {
        return new CommitStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitRollback(OpenGaussStatementParser.RollbackContext ctx) {
        return new RollbackStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAbort(OpenGaussStatementParser.AbortContext ctx) {
        return new RollbackStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitSavepoint(OpenGaussStatementParser.SavepointContext ctx) {
        return new SavepointStatement(this.getDatabaseType(), ctx.colId().getText());
    }

    @Override
    public ASTNode visitRollbackToSavepoint(OpenGaussStatementParser.RollbackToSavepointContext ctx) {
        return new RollbackStatement(this.getDatabaseType(), ctx.colId().getText());
    }

    @Override
    public ASTNode visitReleaseSavepoint(OpenGaussStatementParser.ReleaseSavepointContext ctx) {
        return new ReleaseSavepointStatement(this.getDatabaseType(), ctx.colId().getText());
    }

    @Override
    public ASTNode visitStartTransaction(OpenGaussStatementParser.StartTransactionContext ctx) {
        return new StartTransactionStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitEnd(OpenGaussStatementParser.EndContext ctx) {
        return new CommitStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitSetConstraints(OpenGaussStatementParser.SetConstraintsContext ctx) {
        return new SetConstraintsStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCommitPrepared(OpenGaussStatementParser.CommitPreparedContext ctx) {
        return new XACommitStatement(this.getDatabaseType(), ctx.gid().getText());
    }

    @Override
    public ASTNode visitRollbackPrepared(OpenGaussStatementParser.RollbackPreparedContext ctx) {
        return new XARollbackStatement(this.getDatabaseType(), ctx.gid().getText());
    }
}

