/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.firebird.command;

import io.netty.channel.ChannelHandlerContext;
import java.sql.SQLException;
import java.util.Optional;
import org.apache.shardingsphere.database.protocol.firebird.constant.protocol.FirebirdConnectionProtocolVersion;
import org.apache.shardingsphere.database.protocol.firebird.constant.protocol.FirebirdProtocolVersion;
import org.apache.shardingsphere.database.protocol.firebird.packet.FirebirdPacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.FirebirdCommandPacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.FirebirdCommandPacketFactory;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.FirebirdCommandPacketType;
import org.apache.shardingsphere.database.protocol.firebird.payload.FirebirdPacketPayload;
import org.apache.shardingsphere.database.protocol.packet.DatabasePacket;
import org.apache.shardingsphere.database.protocol.packet.command.CommandPacket;
import org.apache.shardingsphere.database.protocol.packet.command.CommandPacketType;
import org.apache.shardingsphere.database.protocol.payload.PacketPayload;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.proxy.backend.connector.ProxyDatabaseConnectionManager;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.frontend.command.CommandExecuteEngine;
import org.apache.shardingsphere.proxy.frontend.command.executor.CommandExecutor;
import org.apache.shardingsphere.proxy.frontend.command.executor.QueryCommandExecutor;
import org.apache.shardingsphere.proxy.frontend.command.executor.ResponseType;
import org.apache.shardingsphere.proxy.frontend.firebird.command.FirebirdCommandExecutorFactory;
import org.apache.shardingsphere.proxy.frontend.firebird.err.FirebirdErrorPacketFactory;

public final class FirebirdCommandExecuteEngine
implements CommandExecuteEngine {
    public FirebirdCommandPacketType getCommandPacketType(PacketPayload payload) {
        return FirebirdCommandPacketType.valueOf((int)payload.getByteBuf().getInt(payload.getByteBuf().readerIndex()));
    }

    public FirebirdCommandPacket getCommandPacket(PacketPayload payload, CommandPacketType type, ConnectionSession connectionSession) {
        return FirebirdCommandPacketFactory.newInstance((FirebirdCommandPacketType)((FirebirdCommandPacketType)type), (FirebirdPacketPayload)((FirebirdPacketPayload)payload), (FirebirdProtocolVersion)FirebirdConnectionProtocolVersion.getInstance().getProtocolVersion(connectionSession.getConnectionId()));
    }

    public CommandExecutor getCommandExecutor(CommandPacketType type, CommandPacket packet, ConnectionSession connectionSession) {
        return FirebirdCommandExecutorFactory.newInstance((FirebirdCommandPacketType)type, packet, connectionSession);
    }

    public FirebirdPacket getErrorPacket(Exception cause) {
        return FirebirdErrorPacketFactory.newInstance(cause);
    }

    public Optional<DatabasePacket> getOtherPacket(ConnectionSession connectionSession) {
        return Optional.empty();
    }

    public void writeQueryData(ChannelHandlerContext context, ProxyDatabaseConnectionManager databaseConnectionManager, QueryCommandExecutor queryCommandExecutor, int headerPackagesCount) throws SQLException {
        if (ResponseType.QUERY != queryCommandExecutor.getResponseType() || !context.channel().isActive()) {
            return;
        }
        int count = 0;
        int flushThreshold = (Integer)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.PROXY_FRONTEND_FLUSH_THRESHOLD);
        while (queryCommandExecutor.next()) {
            databaseConnectionManager.getConnectionResourceLock().doAwait(context);
            DatabasePacket dataValue = queryCommandExecutor.getQueryRowPacket();
            context.write((Object)dataValue);
            if (flushThreshold != ++count) continue;
            context.flush();
            count = 0;
        }
        context.flush();
    }
}

