/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class TypeHolder<T> {
    private final Type type;

    protected TypeHolder() {
        Type superClass = this.getClass().getGenericSuperclass();
        if (!(superClass instanceof ParameterizedType)) {
            throw new IllegalArgumentException("TypeHolder must be created with a type parameter.");
        }
        ParameterizedType pt = (ParameterizedType)superClass;
        this.type = pt.getActualTypeArguments()[0];
    }

    protected TypeHolder(Type type) {
        if (type == null) {
            throw new IllegalArgumentException("Type cannot be null.");
        }
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public String toString() {
        return this.type.toString();
    }

    public static <T> TypeHolder<T> of(Type type) {
        return new TypeHolder<T>(type){};
    }
}

