/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.context.segment.select.pagination;

import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.statement.type.dml.SelectStatementContext;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.CaseWhenExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.pagination.ExpressionPaginationValueSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.pagination.NumberLiteralPaginationValueSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.pagination.PaginationValueSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.pagination.ParameterMarkerPaginationValueSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.pagination.limit.LimitValueSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.pagination.rownum.ExpressionRowNumberValueSegment;

public final class PaginationContext {
    private final boolean hasPagination;
    private final PaginationValueSegment offsetSegment;
    private final PaginationValueSegment rowCountSegment;
    private final Long actualOffset;
    private final Long actualRowCount;

    public PaginationContext(PaginationValueSegment offsetSegment, PaginationValueSegment rowCountSegment, List<Object> params) {
        this.hasPagination = null != offsetSegment || null != rowCountSegment;
        this.offsetSegment = offsetSegment;
        this.rowCountSegment = rowCountSegment;
        this.actualOffset = null == offsetSegment ? Long.valueOf(0L) : this.getValue(offsetSegment, params);
        this.actualRowCount = null == rowCountSegment ? null : this.getValue(rowCountSegment, params);
    }

    private Long getValue(PaginationValueSegment paginationValueSegment, List<Object> params) {
        if (paginationValueSegment instanceof ParameterMarkerPaginationValueSegment) {
            Long obj;
            Long l = obj = null == params || params.isEmpty() ? Long.valueOf(0L) : params.get(((ParameterMarkerPaginationValueSegment)paginationValueSegment).getParameterIndex());
            if (null == obj) {
                return null;
            }
            return this.getLongValue(obj);
        }
        if (paginationValueSegment instanceof ExpressionRowNumberValueSegment) {
            return ((ExpressionRowNumberValueSegment)paginationValueSegment).getValue(params);
        }
        if (paginationValueSegment instanceof ExpressionPaginationValueSegment) {
            Long result = this.getValueFromExpression(((ExpressionPaginationValueSegment)paginationValueSegment).getExpression(), params);
            return result;
        }
        return ((NumberLiteralPaginationValueSegment)paginationValueSegment).getValue();
    }

    private Long getLongValue(Object value) {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof byte[]) {
            return Long.parseLong(new String((byte[])value, StandardCharsets.UTF_8));
        }
        return Long.parseLong(value.toString());
    }

    private Long getValueFromExpression(ExpressionSegment expressionSegment, List<Object> params) {
        if (expressionSegment instanceof BinaryOperationExpression) {
            return this.getValueFromBinaryOperationExpression((BinaryOperationExpression)expressionSegment, params);
        }
        if (expressionSegment instanceof CaseWhenExpression) {
            return this.getValueFromCaseWhenExpression((CaseWhenExpression)expressionSegment, params);
        }
        return null;
    }

    private Long getValueFromBinaryOperationExpression(BinaryOperationExpression binaryOperationExpression, List<Object> params) {
        Long left = this.getValueFromExpression(binaryOperationExpression.getLeft(), params);
        Long right = this.getValueFromExpression(binaryOperationExpression.getRight(), params);
        if (null == left || null == right) {
            return null;
        }
        switch (binaryOperationExpression.getOperator()) {
            case "+": {
                return left + right;
            }
            case "-": {
                return left - right;
            }
            case "*": {
                return left * right;
            }
            case "/": {
                return 0L == right ? null : Long.valueOf(left / right);
            }
        }
        return null;
    }

    private Long getValueFromCaseWhenExpression(CaseWhenExpression caseWhenExpression, List<Object> params) {
        if (null != caseWhenExpression.getCaseExpr()) {
            return null;
        }
        Iterator whenIterator = caseWhenExpression.getWhenExprs().iterator();
        Iterator thenIterator = caseWhenExpression.getThenExprs().iterator();
        while (whenIterator.hasNext() && thenIterator.hasNext()) {
            Boolean whenValue = this.getBooleanValueFromExpression((ExpressionSegment)whenIterator.next(), params);
            if (Boolean.TRUE.equals(whenValue)) {
                return this.getValueFromExpression((ExpressionSegment)thenIterator.next(), params);
            }
            thenIterator.next();
        }
        return null == caseWhenExpression.getElseExpr() ? null : this.getValueFromExpression(caseWhenExpression.getElseExpr(), params);
    }

    private Boolean getBooleanValueFromExpression(ExpressionSegment expressionSegment, List<Object> params) {
        if (expressionSegment instanceof LiteralExpressionSegment) {
            Object literals = ((LiteralExpressionSegment)expressionSegment).getLiterals();
            if (literals instanceof Boolean) {
                return (Boolean)literals;
            }
            return null == literals ? null : Boolean.valueOf(Boolean.parseBoolean(literals.toString()));
        }
        if (expressionSegment instanceof ParameterMarkerExpressionSegment) {
            Object obj = null == params || params.isEmpty() ? null : params.get(((ParameterMarkerExpressionSegment)expressionSegment).getParameterMarkerIndex());
            return null == obj ? null : Boolean.valueOf(Boolean.parseBoolean(obj.toString()));
        }
        return null;
    }

    public Optional<PaginationValueSegment> getOffsetSegment() {
        return Optional.ofNullable(this.offsetSegment);
    }

    public Optional<PaginationValueSegment> getRowCountSegment() {
        return Optional.ofNullable(this.rowCountSegment);
    }

    public long getActualOffset() {
        if (null == this.offsetSegment) {
            return 0L;
        }
        return this.offsetSegment.isBoundOpened() ? this.actualOffset - 1L : this.actualOffset;
    }

    public Optional<Long> getActualRowCount() {
        if (null == this.rowCountSegment) {
            return Optional.empty();
        }
        return Optional.of(this.rowCountSegment.isBoundOpened() ? this.actualRowCount + 1L : this.actualRowCount);
    }

    public Optional<Integer> getOffsetParameterIndex() {
        return this.offsetSegment instanceof ParameterMarkerPaginationValueSegment ? Optional.of(((ParameterMarkerPaginationValueSegment)this.offsetSegment).getParameterIndex()) : Optional.empty();
    }

    public Optional<Integer> getRowCountParameterIndex() {
        return this.rowCountSegment instanceof ParameterMarkerPaginationValueSegment ? Optional.of(((ParameterMarkerPaginationValueSegment)this.rowCountSegment).getParameterIndex()) : Optional.empty();
    }

    public long getRevisedOffset() {
        return 0L;
    }

    public long getRevisedRowCount(SelectStatementContext selectStatementContext) {
        if (this.isMaxRowCount(selectStatementContext)) {
            return Integer.MAX_VALUE;
        }
        return this.rowCountSegment instanceof LimitValueSegment ? this.actualOffset + this.actualRowCount : this.actualRowCount;
    }

    private boolean isMaxRowCount(SelectStatementContext selectStatementContext) {
        return (!selectStatementContext.getGroupByContext().getItems().isEmpty() || !selectStatementContext.getProjectionsContext().getAggregationProjections().isEmpty()) && !selectStatementContext.isSameGroupByAndOrderByItems();
    }

    @Generated
    public boolean isHasPagination() {
        return this.hasPagination;
    }
}

